package com.polestar.naosdk.api.external;


/**
 * Sensor state callbacks
 */
public interface NAOSensorsListener {

    /**
     * Receives notification that the client app needs to display calibration message to the user.
     */
    void requiresCompassCalibration();

    /**
     * Receives notification that the Wifi needs to be activated on the device
     */
    void requiresWifiOn();

    /**
     * Receives notification that the Bluetooth needs to be activated on the device
     */
    void requiresBLEOn();


    /**
     * Receives notification that the Localisation needs to be activated on the device
     */
    void requiresLocationOn();
}
