package com.polestar.naosdk.api.external;

import android.content.Context;
import android.support.annotation.NonNull;

import com.polestar.naosdk.managers.NAOLocationProvider;

public final class NAOLocationHandle extends NAOServiceHandle<NAOLocationProvider> {

    /**
     * @param context context of your application
     * @param cls the class (your service class that inherit from NaoServiceManager)
     * @param key API key to activate that service. Key is available on your NAO Cloud account.
     * @param client listener for location fix updates
     * @param sensorsListener listener for sensor activation requests
     */
    public NAOLocationHandle(Context context, Class<?> cls, @NonNull String key, @NonNull NAOLocationListener client, @NonNull NAOSensorsListener sensorsListener) {
        myProvider = new NAOLocationProvider(context, cls, key, client, sensorsListener);
    }

    /**
     * @return version of the positioning database used by the location service
     */
    public String getDatabaseVersions() {
        return myProvider.getDatabaseVersions();
    }

}
