package com.polestar.naosdk.api.external;

/**
 * @since 4.1.2
 * Geofencing service callbacks
 * This interface adds callbacks to NAOGeofencingListener.
 * There could be a single interface but for maintaining backward compatibility
 * with code using NAOGeofencingListener.
 */
public interface NAOGeofenceListener extends NAOGeofencingListener{

     /**
      * @since 4.1.2
      * Receives notification when entering a geofence, regardless of whether an alert is
      * defined for that geofence.
      * @param regionId: id of the region affected by the change
      * @param regionName: name of the region affected by the change
      */
     void onEnterGeofence(final int regionId, final String regionName);

     /**
      * @since 4.1.2
      * Receives notification when leaving a geofence, regardless of whether an alert is
      * defined for that geofence.
      * @param regionId: id of the region affected by the change
      * @param regionName: name of the region affected by the change
      */
     void onExitGeofence(final int regionId, final String regionName);
}
