package com.polestar.naosdk.api;

import android.content.Context;
import android.os.Handler;

import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.api.external.NAOSensorsListener;
import com.polestar.naosdk.managers.NaoLoggerProvider;
import com.polestar.naosdk.managers.NaoServiceManager;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jchouki on 14/12/2015.
 */
public class NAOLoggerManager implements LoggerNaoLocationListener {

    private NAOInternalListener internalListener;
    Handler mainHandler;
    private NaoLoggerProvider myNaoLoggerProvider;


    public NAOLoggerManager(Context ctx,Class<?> cls,NAOInternalListener listener, NAOSensorsListener sensorsListener) {
        mainHandler = new Handler(ctx.getMainLooper());
        myNaoLoggerProvider = new NaoLoggerProvider(ctx,cls,this, mainHandler, sensorsListener);
        internalListener = listener;
    }


    public void switchSensors(boolean wifi, boolean ble, boolean mems, boolean osLoc) {
        myNaoLoggerProvider.switchSensors(wifi, ble, mems, osLoc);
    }

    public void recordMarker(long timestamp, double lat, double lon, double alt, int type) {
        myNaoLoggerProvider.recordMarker(timestamp, lat, lon, alt, type);
    }

    /**
     * Starts the recording of sensors info into a file.
     *
     * @param filename
     *            : name of the binary log file into which data will be recorded.
     */
    public void startLogging(String filename, boolean isMems) {
        myNaoLoggerProvider.startLogging(filename, isMems);
    }

    public void startListeningSensors(String apikey, boolean wifi, boolean ble) {
        myNaoLoggerProvider.registerSensorsListener(this, apikey, wifi, ble);
    }

    public void stopListening() {
        myNaoLoggerProvider.unregisterLoggerListener();
    }


    public void startMeasurementLoop() {
        myNaoLoggerProvider.startMeasurementLoop();
    }

    /**
     * Stops recording a log of the sensors data.
     */
    public void stopLogging() {
        myNaoLoggerProvider.stopLogging();
    }

    public List<CGeofencePolygon> regionsOfAllActiveAlerts(String apiKey) {
        return NaoServiceManager.getService().getNaoContext().naoServiceManager.getGeofencePolygons(apiKey);
    }

    @Override
    public void onError(final NAOERRORCODE errCode, final String message) {
        if(internalListener!=null) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    if(internalListener!=null) {
                        internalListener.onError(errCode,message);
                    }
                }
            };
            mainHandler.post(myRunnable);

        }
    }

    @Override
    public void onUnrecoverableError() {
        //NaoNativeBridge.instance().notifyNaoLocationError(NAOERRORCODE.GENERIC_ERROR);
    }

    @Override
    public void NotifyWifiAPsNumberUpdate(final int numberOfAps) {

        if(internalListener!=null) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    if(internalListener!=null) {
                        internalListener.onWifiAPsNumberChanged(numberOfAps);
                    }
                }
            };
            mainHandler.post(myRunnable);

        }
    }

    @Override
    public void NotifyBleBeaconsNumberUpdate(final int numberOfBeacons) {
        if(internalListener!=null) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    if(internalListener!=null) {
                        internalListener.onBleBeaconsNumberChanged(numberOfBeacons);
                    }
                }
            };
            mainHandler.post(myRunnable);
        }
    }

    @Override
    public void onReplayComplete() {
        if(internalListener !=null) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    if(internalListener!=null) {
                        internalListener.onReplayComplete();
                    }
                }
            };
            mainHandler.post(myRunnable);

        }
    }

    @Override
    public void deviceHasLimitedAccuracy() {
        if(internalListener!=null) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    if(internalListener!=null) {
                        internalListener.deviceHasLimitedAccuracy();
                    }
                }
            };
            mainHandler.post(myRunnable);

        }
    }

    @Override
    public void onNewNativeBleListArray(final ArrayList<LoggerBeaconData> data) {

        if(internalListener != null) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    if(internalListener!=null) {
                        internalListener.onBleListChanged(data);
                    }
                }
            };
            mainHandler.post(myRunnable);

        }
    }


}
