// AUTOGENERATED FILE - DO NOT MODIFY!
// This file generated by Djinni from com_polestar_naosdk_api.djinni

package com.polestar.naosdk.api;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ISensorProxyFactory {
    public abstract ISensorProxy create(TSENSORTYPE sensorType, ISensorObserver observer);

    public abstract void setBLEDevicesScanFilter(ArrayList<String> devicesList);

    /** iOS only - ignore on other platforms */
    public abstract void setUuidMap(UuidMap uuidMap);

    /** Android only - ignore on other platforms */
    public abstract void bleResetEnabled(boolean enabled);

    /** checkOSLoc: if True, Wakelock request or release is conditional on being in coverage area based on an OS loc check */
    public abstract void requestWakelock(boolean checkOSLoc);

    public abstract void releaseWakelock(boolean checkOSLoc);

    private static final class CppProxy extends ISensorProxyFactory
    {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef)
        {
            if (nativeRef == 0) throw new RuntimeException("nativeRef is zero");
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long nativeRef);
        public void destroy()
        {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) nativeDestroy(this.nativeRef);
        }
        protected void finalize() throws java.lang.Throwable
        {
            destroy();
            super.finalize();
        }

        @Override
        public ISensorProxy create(TSENSORTYPE sensorType, ISensorObserver observer)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            return native_create(this.nativeRef, sensorType, observer);
        }
        private native ISensorProxy native_create(long _nativeRef, TSENSORTYPE sensorType, ISensorObserver observer);

        @Override
        public void setBLEDevicesScanFilter(ArrayList<String> devicesList)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_setBLEDevicesScanFilter(this.nativeRef, devicesList);
        }
        private native void native_setBLEDevicesScanFilter(long _nativeRef, ArrayList<String> devicesList);

        @Override
        public void setUuidMap(UuidMap uuidMap)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_setUuidMap(this.nativeRef, uuidMap);
        }
        private native void native_setUuidMap(long _nativeRef, UuidMap uuidMap);

        @Override
        public void bleResetEnabled(boolean enabled)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_bleResetEnabled(this.nativeRef, enabled);
        }
        private native void native_bleResetEnabled(long _nativeRef, boolean enabled);

        @Override
        public void requestWakelock(boolean checkOSLoc)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_requestWakelock(this.nativeRef, checkOSLoc);
        }
        private native void native_requestWakelock(long _nativeRef, boolean checkOSLoc);

        @Override
        public void releaseWakelock(boolean checkOSLoc)
        {
            assert !this.destroyed.get() : "trying to use a destroyed object";
            native_releaseWakelock(this.nativeRef, checkOSLoc);
        }
        private native void native_releaseWakelock(long _nativeRef, boolean checkOSLoc);
    }
}
