package com.polestar.models;

import android.location.Location;

import com.polestar.enums.NRProximityEnum;

import java.util.ArrayList;

public class Region implements Comparable<Region>{
	protected int id;
	protected int siteId;
	public int getSiteId() {
		return siteId;
	}

	public void setSiteId(int siteId) {
		this.siteId = siteId;
	}
	
	protected ArrayList<Location> polygon;
	
	public ArrayList<Location> getPolygon() {
		return polygon;
	}

	public void setPolygon(ArrayList<Location> polygon) {
		this.polygon = polygon;
	}
	
	public boolean hasAltitude() {
		if (polygon==null) {
			return false;
		}
		return polygon.get(0).hasAltitude();
	}

	protected String name;
	protected NRProximityEnum proximity = NRProximityEnum.NRProximityUnknown;
	
	@Override
	public int compareTo(Region another) {
		return NRProximityEnum.compare(proximity, another.proximity);
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public NRProximityEnum getProximity() {
		return proximity;
	}
	
	public void setName(String newName){
		name = newName;
	}
	
	public String toString(){
		return name;
	}
	 
}
