package com.polestar.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import android.location.Location;
import android.util.Log;

public class PolygonRegion extends Region{
	public static List<PolygonRegion> list = new ArrayList<PolygonRegion>();
	public static PolygonRegion current = null;
	
	// Private instance varialbes
	private int numberOfTimesLocationIsInRegion = 0;
	private int numberOfTimesLocationIsOutRegion = 0;
	private boolean userIsInRegion = false;
	
	// create when got from cloud
	public PolygonRegion(int id, int siteId, String name) {
		this.id = id;
		this.siteId=siteId;
		this.name = name;
		list.add(this);
	}

	// create new from setup app
	public PolygonRegion(String name) {
		this.id = getTempId();
		this.name = name;
		list.add(this);
	}
	
	public static int getTempId(){
		int maxId = 0;
		for (Iterator<PolygonRegion> iterator = list.iterator(); iterator.hasNext();) {
			PolygonRegion region = (PolygonRegion) iterator.next();
			if (Math.abs(region.getId()) > maxId){
				maxId = Math.abs(region.getId()) ;
			}
		}
		return -maxId -1;
	}
	
	public static PolygonRegion findById(int id){
		for (Iterator<PolygonRegion> iterator = list.iterator(); iterator.hasNext();) {
			PolygonRegion region = (PolygonRegion) iterator.next();
			if (region.id == id){
				return region;
			}
		}
		return null;
	}
	
	
	public boolean isLocationInside(Location location) {

		// local variables
		double crossp;
		Location A = null;
		Location B = null;
		Location AB = null;
		Location AP = null;

		boolean result = false;

		if (polygon == null) {
			Log.w(this.getClass().getName(), "null polygon for beacon region "
					+ name);
			return false;
		} else if (this.polygon.size() < 2 || location == null) {
			return false;
		}

		// loop over edges
		Location it2 = this.polygon.get(this.polygon.size() - 1);
		if (it2.getAltitude() != location.getAltitude()) {
			// The polygon and the location are not on the same floor
			Log.w(this.getClass().getName(), "polygon and the location are not on the same floor: "
					+ name);
			return false;
		}

		for (int i = 0; i < this.polygon.size(); i++) {
			Location it1 = this.polygon.get(i);
			// define vectors AB and AP in 2D where A is the vertex of lowest y,
			// B the other vertex.
			if (it1.getLongitude() < it2.getLongitude()) {
				A = new Location("Temp");
				A.setLatitude(it1.getLatitude());
				A.setLongitude(it1.getLongitude());
				B = new Location("Temp");
				B.setLatitude(it2.getLatitude());
				B.setLongitude(it2.getLongitude());
			} else {
				B = new Location("Temp");
				B.setLatitude(it1.getLatitude());
				B.setLongitude(it1.getLongitude());
				A = new Location("Temp");
				A.setLatitude(it2.getLatitude());
				A.setLongitude(it2.getLongitude());
			}
			AB = new Location("Temp");
			AB.setLatitude(B.getLatitude() - A.getLatitude());
			AB.setLongitude(B.getLongitude() - A.getLongitude());
			AP = new Location("Temp");
			AP.setLatitude(location.getLatitude() - A.getLatitude());
			AP.setLongitude(location.getLongitude() - A.getLongitude());
			// AB * AP [2]
			crossp = AB.getLatitude() * AP.getLongitude() - AB.getLongitude()
					* AP.getLatitude();
			// if the vectors are colinear
			if (crossp == 0) {
				// either the point is between the two points ie on the edge
				double dotProduct = AB.getLatitude() * AP.getLatitude()
						+ AB.getLongitude() * AP.getLongitude();
				double normAP = AP.getLatitude() * AP.getLatitude()
						+ AP.getLongitude() * AP.getLongitude();
				double normAB = AB.getLatitude() * AB.getLatitude()
						+ AB.getLongitude() * AB.getLongitude();
				if ((dotProduct >= 0) && (normAP <= normAB)) {
					result = true;
					return result;
				}
			} else if (crossp < 0) {
				// if the point is in the band cound bby the y coordinates of
				// the two points bound are excluded
				if (A.getLongitude() < location.getLongitude()
						&& location.getLongitude() <= B.getLongitude()) {
					result = !result;
				}
			}
			it2 = it1;
		}

		return result;
	}

	// Setters and Getters of private instance variables
	public int getNumberOfTimesLocationIsInRegion() {
		return numberOfTimesLocationIsInRegion;
	}

	public void setNumberOfTimesLocationIsInRegion(
			int numberOfTimesLocationIsInRegion) {
		this.numberOfTimesLocationIsInRegion = numberOfTimesLocationIsInRegion;
	}

	public int getNumberOfTimesLocationIsOutRegion() {
		return numberOfTimesLocationIsOutRegion;
	}

	public void setNumberOfTimesLocationIsOutRegion(
			int numberOfTimesLocationIsOutRegion) {
		this.numberOfTimesLocationIsOutRegion = numberOfTimesLocationIsOutRegion;
	}

	public boolean isUserIsInRegion() {
		return userIsInRegion;
	}

	public void setUserIsInRegion(boolean userIsInRegion) {
		this.userIsInRegion = userIsInRegion;
	}
	
}
