package com.polestar.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.polestar.enums.NRProximityEnum;
import com.polestar.enums.NaoZoneTypeEnum;

public class NaoZone implements Parcelable {
	
	private NaoZoneTypeEnum type;
	private int id;
	private String name;
	private NRProximityEnum proximity;
	
	
	public static final Parcelable.Creator<NaoZone> CREATOR = new Parcelable.Creator<NaoZone>() {
		  public NaoZone createFromParcel(Parcel in) {
		      return new NaoZone(in);
		    }
		
		    @Override
		    public NaoZone[] newArray(int size) {
		      //return new NaoAlert[size];
		    	return null;
		    }
	};
	
	@Override
	public int describeContents() {
	  return 0;
	}
	
	@Override
	public void writeToParcel(Parcel out, int flags) {
		out.writeInt(this.type.getValue());
		out.writeInt(this.id);
		out.writeString(this.name);
		out.writeInt(this.proximity.getValue());
	}
	  
	public void readFromParcel(Parcel in) {
		this.type = NaoZoneTypeEnum.values()[in.readInt()];
		this.id = in.readInt();
		this.name = in.readString();
		this.proximity = NRProximityEnum.values()[in.readInt()];
	}

	public NaoZone() {
		//
	}
	
	public NaoZone(Parcel in) {
		readFromParcel(in);
	}
	
	public NaoZone(Region region){
		if (region instanceof NAORegion){
			type = NaoZoneTypeEnum.BeaconZone;
		}else{
			type = NaoZoneTypeEnum.UnknownZone;
		}
		id = region.getId();
		name = region.getName();
		proximity = region.getProximity();
	}

	public  NaoZoneTypeEnum getType(){
		return type;
	}
	
	public int getId(){
		return id;
	}
	
	public String getName(){
		return name;
	}
	
	public NRProximityEnum getProximity(){
		return proximity;
	}
	
	public String proximityString(NRProximityEnum prox){
		return NRProximityEnum.proximityString(prox);
	}
	
}
