package com.polestar.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import android.location.Location;
import android.util.Log;

import com.polestar.enums.NRProximityEnum;

public class NAORegion extends Region{
	public static List<NAORegion> list = new ArrayList<NAORegion>(); // this list will always be ordered by proximity (immediate, near, far, not seen)
	public static NAORegion current = null;
	
	// Private instance variables
	private int numberOfTimesLocationIsInRegion = 0;
	private int numberOfTimesLocationIsOutRegion = 0;
	private boolean userIsInRegion = false;
	
	// create when got from cloud
	public NAORegion(int id, int siteId, String name) {
		this.id = id;
		this.siteId=siteId;
		this.name = name;
		list.add(this);
	}

	// create new from setup app
	public NAORegion(String name) {
		this.id = getTempId();
		this.name = name;
		list.add(this);
	}
	
	public static int getTempId(){
		int maxId = 0;
		for (Iterator<NAORegion> iterator = list.iterator(); iterator.hasNext();) {
			NAORegion region = iterator.next();
			if (Math.abs(region.getId()) > maxId){
				maxId = Math.abs(region.getId()) ;
			}
		}
		return -maxId -1;
	}
	
	public List<Beacon> beacons(){
		return BeaconRegionPair.beaconsForRegion(this);
	}
	
	public static NAORegion findById(int id){
		for (Iterator<NAORegion> iterator = list.iterator(); iterator.hasNext();) {
			NAORegion region = (NAORegion) iterator.next();
			if (region.id == id){
				return region;
			}
		}
		return null;
	}
	
	public Beacon closestBeacon(){
		Beacon b = null;
		Set<Beacon> beacons = BeaconRegionPair.regionsMap.get(this.getId());
		if(beacons == null) {
			return b;
		}
		if (beacons.size() > 0){
			List<Beacon> beconsToBeSorted = new ArrayList<Beacon>(beacons);
			Collections.sort(beconsToBeSorted);
			b = beconsToBeSorted.get(0);
		}
		return b;
	}
	
	public boolean hasBeacon(Beacon beacon){
		boolean res = false;
		Set<Beacon> myBeacons = BeaconRegionPair.regionsMap.get(this.getId());
		if(myBeacons == null) {
			return res;
		}
		for (Iterator<Beacon> iterator = myBeacons.iterator(); iterator.hasNext();) {
			Beacon b = (Beacon) iterator.next();
			if (b == beacon){
				res = true;
				break;
			}
		}
		return res;
	}
	
	// did enter when a beacon enters ?
	public boolean didEnterWhenABeaconEnters(Beacon beacon){
		boolean res = false;
		if (hasBeacon(beacon)){
			if (proximity == NRProximityEnum.NRProximityUnknown){
				res = true;
			}	
		}
		return res;
	}
	
	// did exit the region when a beacon exited ?
	public boolean didExitWhenaBeaconExits(Beacon beacon){
		boolean res = false;
		if (hasBeacon(beacon)){
			Set<Beacon> myBeacons = BeaconRegionPair.regionsMap.get(this.getId());
			int nbNotSeenBeacons = 0; 
			if(myBeacons == null) {
				return res;
			}
			for (Iterator<Beacon> iterator = myBeacons.iterator(); iterator.hasNext();) {
				Beacon b= (Beacon) iterator.next();
				if (!b.isSeen()){
					nbNotSeenBeacons++;
				}
			}
			if (nbNotSeenBeacons == myBeacons.size()){
				proximity = NRProximityEnum.NRProximityUnknown;
				//Collections.sort(list);
				res = true;
			}
		}
		return res;
	}
	
	// called in didChangeProximityBeacon
	public boolean didChangeProximityWhenABeaconChanges(Beacon beacon){
		boolean res = false;
		if (hasBeacon(beacon)){
			NRProximityEnum closestBeaconProximity = closestBeacon().getProximity();
			if (proximity.getValue() != closestBeaconProximity.getValue()){
				proximity = closestBeaconProximity;
				//Collections.sort(list);
				res = true;
			}
		}
		//Collections.sort(list);
		return res;
	}

	public static void delete(NAORegion region) {
		BeaconRegionPair.deletePairsWithRegion(region);
		/*DBG*/Log.w("com.polestar", "region remove ......");
		list.remove(region);
	}

	public void resetProximity() {
		proximity = NRProximityEnum.NRProximityUnknown;
		Set<Beacon> myBeacons = BeaconRegionPair.regionsMap.get(this.getId());
		if(myBeacons == null) {
			return;
		}
		for (Iterator<Beacon> iterator = myBeacons.iterator(); iterator.hasNext();) {
			Beacon b = (Beacon) iterator.next();
			b.resetProximity();
		}
	}
	
	
	public boolean isLocationInside(Location location) {
		boolean result;

		if (location == null) {
			result = false;
		} else {
			result = isLocationInside(location.getLatitude(), location.getLongitude(), location.getAltitude());
		}

		return result;
}
	
	public boolean isLocationInside(double latitude, double longitude, double altitude) {

		// local variables
		double crossp;
		Location A = null;
		Location B = null;
		Location AB = null;
		Location AP = null;

		boolean result = false;

		if (polygon == null) {
			Log.w(this.getClass().getName(), "null polygon for beacon region "
					+ name);
			return false;
		} else if (this.polygon.size() < 2) {
			return false;
		}

		// loop over edges
		Location it2 = this.polygon.get(this.polygon.size() - 1);
		if (it2.getAltitude() != altitude) {
			// The polygon and the location are not on the same floor
			Log.w(this.getClass().getName(), "polygon and the location are not on the same floor: "
					+ name);
			return false;
		}

		for (int i = 0; i < this.polygon.size(); i++) {
			Location it1 = this.polygon.get(i);
			// define vectors AB and AP in 2D where A is the vertex of lowest y,
			// B the other vertex.
			if (it1.getLongitude() < it2.getLongitude()) {
				A = new Location("Temp");
				A.setLatitude(it1.getLatitude());
				A.setLongitude(it1.getLongitude());
				B = new Location("Temp");
				B.setLatitude(it2.getLatitude());
				B.setLongitude(it2.getLongitude());
			} else {
				B = new Location("Temp");
				B.setLatitude(it1.getLatitude());
				B.setLongitude(it1.getLongitude());
				A = new Location("Temp");
				A.setLatitude(it2.getLatitude());
				A.setLongitude(it2.getLongitude());
			}
			AB = new Location("Temp");
			AB.setLatitude(B.getLatitude() - A.getLatitude());
			AB.setLongitude(B.getLongitude() - A.getLongitude());
			AP = new Location("Temp");
			AP.setLatitude(latitude - A.getLatitude());
			AP.setLongitude(longitude - A.getLongitude());
			// AB * AP [2]
			crossp = AB.getLatitude() * AP.getLongitude() - AB.getLongitude()
					* AP.getLatitude();
			// if the vectors are colinear
			if (crossp == 0) {
				// either the point is between the two points ie on the edge
				double dotProduct = AB.getLatitude() * AP.getLatitude()
						+ AB.getLongitude() * AP.getLongitude();
				double normAP = AP.getLatitude() * AP.getLatitude()
						+ AP.getLongitude() * AP.getLongitude();
				double normAB = AB.getLatitude() * AB.getLatitude()
						+ AB.getLongitude() * AB.getLongitude();
				if ((dotProduct >= 0) && (normAP <= normAB)) {
					result = true;
					return result;
				}
			} else if (crossp < 0) {
				// if the point is in the band cound bby the y coordinates of
				// the two points bound are excluded
				if (A.getLongitude() < longitude
						&& longitude <= B.getLongitude()) {
					result = !result;
				}
			}
			it2 = it1;
		}

		return result;
	}

	// Setters and Getters of private instance variables
	public int getNumberOfTimesLocationIsInRegion() {
		return numberOfTimesLocationIsInRegion;
	}

	public void setNumberOfTimesLocationIsInRegion(
			int numberOfTimesLocationIsInRegion) {
		this.numberOfTimesLocationIsInRegion = numberOfTimesLocationIsInRegion;
	}

	public int getNumberOfTimesLocationIsOutRegion() {
		return numberOfTimesLocationIsOutRegion;
	}

	public void setNumberOfTimesLocationIsOutRegion(
			int numberOfTimesLocationIsOutRegion) {
		this.numberOfTimesLocationIsOutRegion = numberOfTimesLocationIsOutRegion;
	}

	public boolean isUserIsInRegion() {
		return userIsInRegion;
	}

	public void setUserIsInRegion(boolean userIsInRegion) {
		this.userIsInRegion = userIsInRegion;
	}
	
}
