//______________________________________________________________________________________
//
//  Measurement.java
// 
//  Pole Star Confidential Proprietary
//    Copyright (c) Pole Star 2010, All Rights Reserved
//    No publication authorized. Reverse engineering prohibited
//______________________________________________________________________________________
package com.polestar.models;

/**
 * An abstract class as a model for sensor measurement data containers.
 *    
 * <br/><br/><b>Revision history:</b><br/>
 * <table border>
 * <tr>
 *   <td>Author</td>
 *   <td>Modification date</td>
 *   <td>Tracking Number</td>
 *   <td>Description of Change</td>
 * </tr>
 * <!-- add lines to the table for modifications, following the model -->
 * <tr>
 *   <td>sterrenoir</td>
 *   <td>15 mars 2010</td>
 *   <td>Trunk</td>
 *   <td>Creation of this class</td>
 * </tr>
 * </table>    
 * @author sterrenoir
 */
public abstract class Measurement {
	/**
	 * This method generates a serialized byte array from measurement data
	 */
	public abstract byte[] toByteArray();
	
	/**
	 * This method generates a human-readable string from the measurement data
	 */
	public abstract String toHumanString();
	
	public static String formatDouble(double d,boolean withSign,int integerDigits,int fractionalDigits) {
		String str = "";
		if ((withSign) || (d<0)) {
			str += (d<0)?"-":"+";
		}
		double absd = Math.abs(d);
		int ipart = (int) absd;
		absd = (absd-(double) ipart)*Math.pow(10.0, fractionalDigits);
		String myFormat = "%0"+integerDigits+"d.%0"+fractionalDigits+"d";
		str += String.format(myFormat, ipart,(int) (absd+0.5));		
		return str;
	}

}
