//______________________________________________________________________________________
//
//  ISensorListener.java
// 
//  Pole Star Confidential Proprietary
//    Copyright (c) Pole Star 2010, All Rights Reserved
//    No publication authorized. Reverse engineering prohibited
//______________________________________________________________________________________
package com.polestar.models;


/**
 * Interface for processing new sensor measurements when they come<br/>
 * Register this interface to a GpsSensor or a WifiSensor, and use the method below to
 * process the measurement as it arrives.
 *    
 * <br/><br/><b>Revision history:</b><br/>
 * <table border>
 * <tr>
 *   <td>Author</td>
 *   <td>Modification date</td>
 *   <td>Tracking Number</td>
 *   <td>Description of Change</td>
 * </tr>
 * <!-- add lines to the table for modifications, following the model -->
 * <tr>
 *   <td>sterrenoir</td>
 *   <td>14 avril 2010</td>
 *   <td>trunk</td>
 *   <td>Creation of this class</td>
 * </tr>
 * </table>    
 * @author sterrenoir
 */
public interface ISensorListener {
	/**
	 * Implement this method to process a new incoming measurement
	 * @param meas : new measurement
	 */
	void onNewMeasurement(Measurement meas);

	
	/**
	 * Implement this method to process updates of statuses. Though this is generic, it is only used by Loc OS.
	 * @param isOk: tells whether the measurements are good enough for the sensor to consider itself "hooked"
	 */
	void onNewLocOsStatus(boolean isOk);
	
}
