package com.polestar.models;

import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.polestar.helpers.Log;
import com.polestar.naosdk.controllers.AndroidGeofencingService;

import android.app.IntentService;
import android.content.Intent;
import android.os.Build;

public class GeofenceTransition extends IntentService {
    /**
     * Sets an identifier for this class' background thread
     */
    public GeofenceTransition() {
        super("ReceiveGeofenceTransitionIntentService");
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        Log.writeToLog(this.getClass().getName(), "GeofenceTransition >> onHandleIntent");
        GeofencingEvent event = GeofencingEvent.fromIntent(intent);
        if(event != null){
            if(event.hasError()){
                onError(event.getErrorCode());
            } else {
                int transition = event.getGeofenceTransition();
                if(transition == Geofence.GEOFENCE_TRANSITION_ENTER || transition == Geofence.GEOFENCE_TRANSITION_DWELL || transition == Geofence.GEOFENCE_TRANSITION_EXIT){
                    String[] geofenceIds = new String[event.getTriggeringGeofences().size()];
                    for (int index = 0; index < event.getTriggeringGeofences().size(); index++) {
                        geofenceIds[index] = event.getTriggeringGeofences().get(index).getRequestId();
                    }

                    if (transition == Geofence.GEOFENCE_TRANSITION_ENTER || transition == Geofence.GEOFENCE_TRANSITION_DWELL) {
                        onEnteredGeofences(geofenceIds);
                    } else if (transition == Geofence.GEOFENCE_TRANSITION_EXIT) {
                        onExitedGeofences(geofenceIds);
                    }
                }else{
                    Log.writeToLog(this.getClass().getName(), "GeofenceTransition >> onHandleIntent unsupported geofence type");
                }
            }
        }else{
            Log.writeToLog(this.getClass().getName(),"GeofenceTransition >> onHandleIntent without event");
        }
    }

    protected void onEnteredGeofences(String[] geofenceIds){
        com.polestar.helpers.Log.alwaysWarn(this.getClass().getName(), "GeofenceTransition >> onEnter");
        // start new service
        Intent intent = new Intent(this, AndroidGeofencingService.class);
        intent.putExtra(AndroidGeofencingService.EVENT, AndroidGeofencingService.EVENT_ENTER);

        // start service depending on Android_SDK version
        if (Build.VERSION.SDK_INT >= 26) {
            this.startForegroundService(intent);
        }
        else this.startService(intent);
    }

    protected void onExitedGeofences(String[] geofenceIds){
        com.polestar.helpers.Log.alwaysWarn(this.getClass().getName(), "GeofenceTransition >> onExit");
        // start new service
        Intent intent = new Intent(this, AndroidGeofencingService.class);
        intent.putExtra(AndroidGeofencingService.EVENT, AndroidGeofencingService.EVENT_EXIT);

        // start service depending on Android_SDK version
        if (Build.VERSION.SDK_INT >= 26) {
            this.startForegroundService(intent);
        }
        else this.startService(intent);
    }

    protected void onError(int errorCode){
        Log.alwaysError(this.getClass().getName(), "Error: " + errorCode);
        Log.writeToLog(this.getClass().getName(), "AndroidGeofencingService >> onError with code " + errorCode);
    }
}
