package com.polestar.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import android.util.SparseArray;

public class BeaconRegionPair {
	public static List<BeaconRegionPair> list = new ArrayList<BeaconRegionPair>();
	public static SparseArray<Set<Beacon>> regionsMap = new SparseArray<Set<Beacon>>();
	
	private Beacon beacon;
	private NAORegion region;
	
	public BeaconRegionPair(Beacon beacon, NAORegion region) {
		this.beacon = beacon;
		this.region = region;
		list.add(this);
		
		Set<Beacon> beacons = regionsMap.get(region.getId());
		if(beacons != null) {
			beacons.add(beacon);
			regionsMap.put(region.getId(), beacons);
		} else {
			Set<Beacon> newBeacons = new HashSet<Beacon>();
			newBeacons.add(beacon);
			regionsMap.put(region.getId(), newBeacons);
		}
	}
	
	public static void removePair(NAORegion region, Beacon beacon){
		BeaconRegionPair pairToRemove = null;
		for (Iterator<BeaconRegionPair> iterator = list.iterator(); iterator.hasNext();) {
			BeaconRegionPair pair = (BeaconRegionPair) iterator.next();
			if (pair.region == region && pair.beacon == beacon){
				pairToRemove = pair;
				break;
			}
		}
		if (pairToRemove != null){
			list.remove(pairToRemove);
		}
	}
	
	// list always sorted by RSSI, proximity
	public static List<Beacon> beaconsForRegion(NAORegion region){
		List<Beacon> beacons = new ArrayList<Beacon>();
		for (Iterator<BeaconRegionPair> iterator = list.iterator(); iterator.hasNext();) {
			BeaconRegionPair pair = (BeaconRegionPair) iterator.next();
			if (pair.region == region){
				beacons.add(pair.beacon);
			}
		}
		Collections.sort(beacons);
		return beacons;
	}
	
	public static List<NAORegion> regionsForBeacon(Beacon beacon){
		List<NAORegion> regions = new ArrayList<NAORegion>();
		for (Iterator<BeaconRegionPair> iterator = list.iterator(); iterator.hasNext();) {
			BeaconRegionPair pair = (BeaconRegionPair) iterator.next();
			if (pair.beacon == beacon){
				regions.add(pair.region);
			}
		}
		return regions;
	
	}
	
	public Beacon getBeacon() {
		return beacon;
	}

	public NAORegion getRegion() {
		return region;
	}

	public static void deletePairsWithRegion(NAORegion region) {
		List<BeaconRegionPair> pairsToDelete = new ArrayList<BeaconRegionPair>();
		for (Iterator<BeaconRegionPair> iterator = list.iterator(); iterator.hasNext();) {
			BeaconRegionPair pair = (BeaconRegionPair) iterator.next();
			if (pair.region == region){
				pairsToDelete.add(pair);
			}
		}
		if (pairsToDelete.size() > 0){
			list.removeAll(pairsToDelete);
		}
	}

	public static void deletePair(Beacon beacon, NAORegion region) {
		BeaconRegionPair pairToDelete = null;
		for (Iterator<BeaconRegionPair> iterator = list.iterator(); iterator.hasNext();) {
			BeaconRegionPair pair = (BeaconRegionPair) iterator.next();
			if (pair.region == region && pair.beacon == beacon){
				pairToDelete = pair;
				break;
			}
		}
		if (pairToDelete != null){
			list.remove(pairToDelete);
		}
	}

	
}
