package com.polestar.models;

import java.io.UnsupportedEncodingException;

import android.util.Log;

public class BeaconAuthent {
	public static final int NAO_BTAUTHENT_SIZE_ID = 5;
	public static final int NAO_BTAUTHENT_DEFAULT_CIPHERING_KEY = 0x01CAFE;
	public static final int[][] NAO_BTAUTHENT_DEFAULT_CIPHERING_PERM_ARRAY = new int[][] {
			{ 1, 2, 3, 4, 5 }, { 1, 3, 2, 5, 4 }, { 1, 4, 3, 2, 5 },
			{ 1, 5, 3, 4, 2 }, { 2, 1, 5, 3, 4 }, { 2, 3, 5, 4, 1 },
			{ 2, 5, 1, 3, 4 }, { 3, 1, 2, 5, 4 }, { 3, 2, 4, 1, 5 },
			{ 3, 4, 2, 5, 1 }, { 3, 5, 4, 1, 2 }, { 4, 1, 5, 3, 2 },
			{ 4, 3, 1, 2, 5 }, { 4, 5, 1, 3, 2 }, { 5, 1, 3, 2, 4 },
			{ 5, 2, 3, 4, 1 } };

	private int key;

	public BeaconAuthent(int key) {
		super();
		this.key = key;
	}

	public BeaconAuthent() {
		this.key = NAO_BTAUTHENT_DEFAULT_CIPHERING_KEY;
	}

	public int decode(String localName) {
		int res = 0;
		int[] keyDigits = new int[NAO_BTAUTHENT_SIZE_ID];
		long hash = 0;
		int[] hashDigits = new int[NAO_BTAUTHENT_SIZE_ID];
		long ciphCode = 0;
		int[] ciphCodeDigits = new int[NAO_BTAUTHENT_SIZE_ID];
		int[] logicalIdDigits = new int[NAO_BTAUTHENT_SIZE_ID];
		long si;
		char[] charLocalName = new char[localName.length()];

		localName.getChars(0, localName.length(), charLocalName, 0);

		/*
		 * DBG
		 
		for (int i = 0; i < charLocalName.length; i++) {
			Log.d(this.getClass().getName(), "decode, charLocalName[" + i + "]"
					+ ": " + charLocalName[i]);
		}*/

		fillKeyDigitsFromKey(keyDigits);
		fillCiphCodeDigitsAndHashDigitsFromCharLocalName(ciphCodeDigits,
				hashDigits, charLocalName);
		/*
		 * DBG
		 
		for (int i = 0; i < hashDigits.length; i++) {
			Log.d(this.getClass().getName(), "decode, hashDigits[" + i + "]="
					+ hashDigits[i]);
			Log.d(this.getClass().getName(), "decode, ciphCodeDigits[" + i
					+ "]=" + ciphCodeDigits[i]);
		}*/

		hash = getHashCode(hashDigits);
		ciphCode = getCiphCode(ciphCodeDigits);
		/*
		 * DBG Log.d(this.getClass().getName(), "decode, hash: "+ hash);
		 * Log.d(this.getClass().getName(), "decode, ciphCode: "+ ciphCode);
		 */
		// get permutation index
		si = (hash * NAO_BTAUTHENT_DEFAULT_CIPHERING_KEY) & 0x0000000F;
		/*
		 * DBG Log.d(this.getClass().getName(), "decode, si " + si);
		 */

		fillFogicalIdDigits(logicalIdDigits, ciphCodeDigits, hashDigits,
				keyDigits, (int) si);
		/* DBG 
		for (int i = 0; i < logicalIdDigits.length; i++) {
			Log.d(this.getClass().getName(), "decode, logicalIdDigits[" + i
					+ "]=" + logicalIdDigits[i]);
		}*/

		// compute the final res value
		res = (logicalIdDigits[0] << 16) + (logicalIdDigits[1] << 12)
				+ (logicalIdDigits[2] << 8) + (logicalIdDigits[3] << 4)
				+ logicalIdDigits[4];
		return res;
	}

	private void fillFogicalIdDigits(int[] logicalIdDigits,
			int[] ciphCodeDigits, int[] hashDigits, int[] keyDigits, int si) {
		for (int i = 0; i < NAO_BTAUTHENT_SIZE_ID; i++) {
			logicalIdDigits[i] = ciphCodeDigits[NAO_BTAUTHENT_DEFAULT_CIPHERING_PERM_ARRAY[si][i] - 1];
		}
		for (int i = 0; i < NAO_BTAUTHENT_SIZE_ID; i++) {
			logicalIdDigits[i] = (logicalIdDigits[i] - hashDigits[i]
					* keyDigits[i]) & 0x0F;
		}
	}

	private int getHashCode(int[] hashDigits) {
		int hash = 0;
		for (int i = 0; i < NAO_BTAUTHENT_SIZE_ID; i++) {
			hash = hash
					+ (hashDigits[i] << 4 * (NAO_BTAUTHENT_SIZE_ID - i - 1));
		}
		return hash;
	}

	private int getCiphCode(int[] ciphCodeDigits) {
		int ciphCode = 0;
		for (int i = 0; i < NAO_BTAUTHENT_SIZE_ID; i++) {
			ciphCode = ciphCode
					+ (ciphCodeDigits[i] << 4 * (NAO_BTAUTHENT_SIZE_ID - i - 1));
		}
		return ciphCode;
	}

	private void fillCiphCodeDigitsAndHashDigitsFromCharLocalName(
			int[] ciphCodeDigits, int[] hashDigits, char[] charLocalName) {
		if (ciphCodeDigits.length != hashDigits.length) {
			Log.e(this.getClass().getName(),
					"fillCiphCodeDigitsAndHashDigits: ciphCodeDigits and hashDigits must have the length !");
			return;
		}
		for (int i = 0; i < NAO_BTAUTHENT_SIZE_ID; i++) {
			String stringCiphChari = "" + charLocalName[2 + 2 * i];
			String stringHashChari = "" + charLocalName[2 + 2 * i + 1];
			ciphCodeDigits[i] = Integer.valueOf(stringCiphChari, 16);
			hashDigits[i] = Integer.valueOf(stringHashChari, 16);
		}
	}

	private void fillKeyDigitsFromKey(int[] keyDigits) {
		int tmp = key;
		for (int i = NAO_BTAUTHENT_SIZE_ID; i > 0; i--) {
			keyDigits[i - 1] = tmp & (0x0F);
			tmp = tmp >> 4;
			/*
			 * DBG Log.d(this.getClass().getName(),
			 * "fillKeyDigitsFromKey  keyDigits["+i+"] : " + keyDigits[i-1] +
			 * "  key: " + key);
			 */
		}
	}

	public int getCurrentCycle(String localName) {
		return 0;
	}

}
