package com.polestar.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
	public static void zipFolder(String srcFolder, String destZipFile) throws Exception {
	    ZipOutputStream zip = null;
	    FileOutputStream fileWriter = null;

	    fileWriter = new FileOutputStream(destZipFile);
	    zip = new ZipOutputStream(fileWriter);

	    addFolderToZip("", srcFolder, zip);
	    zip.flush();
	    zip.close();
	  }

	public static void zipFiles(ArrayList<String> srcFiles, String destZipFile) throws Exception {
		ZipOutputStream zip = null;
		FileOutputStream fileWriter = null;

		fileWriter = new FileOutputStream(destZipFile);
		zip = new ZipOutputStream(fileWriter);

		for (String fileName : srcFiles) {
			addFileToZip(fileName.substring(fileName.lastIndexOf('/')), fileName, zip);
		}

		zip.flush();
		zip.close();
	}

	/**
	 *
	 * @param path file name
	 * @param srcFile path to file
	 * @param zip ZipOutputStream of zip
	 * @throws Exception
	 */
	  private static void addFileToZip(String path, String srcFile, ZipOutputStream zip)
	      throws Exception {
	    File file = new File(srcFile);
	    if (file.isDirectory()) {
	      addFolderToZip(path, srcFile, zip);
	    } else {
	    	if(FileHelper.getFileExtension(file.getName()).equalsIgnoreCase("zip") == false){
	  	      byte[] buf = new byte[1024];
		      int len;
		      FileInputStream in = new FileInputStream(srcFile);
		      zip.putNextEntry(new ZipEntry(path));
		      while ((len = in.read(buf)) > 0) {
		        zip.write(buf, 0, len);
		      }	
	    	}
	    }
	  }
	  
	  private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip)
	  throws Exception {
	    File folder = new File(srcFolder);

	    for (String fileName : folder.list()) {
	      if (path.equals("")) {
	        addFileToZip(fileName, srcFolder + "/" + fileName, zip);
	      } else {
	        addFileToZip(path + "/" + fileName, srcFolder + "/" + fileName, zip);
	      }
	    }
	  }
}
