package com.polestar.helpers;

import android.content.Context;
import android.content.SharedPreferences;

import com.polestar.R;
import com.polestar.naosdk.api.IPrefHelper;

/**
 * Created by ASimonigh on 11/07/2016.
 */
public class PrefHelper{

	public static final String PREF_GEOFENCE_REGISTERED = "android_geofencing_registered";
	public static final String PREF_WAKE_UP_NOTIFIER_NAME = "[logger]wake_up_notifier";
	public static final String PREF_APP_KEY = "[logger]logs_app_key";
	public static final String PREF_SERVICE_NAME = "[logger]service_name";
	public static final String PREF_USER_ID = "user_id";

	public static SharedPreferences getAppSharedPrefs(Context context){
		return context.getSharedPreferences(context.getString(R.string.preference_file_key), Context.MODE_PRIVATE);
	}

	public static void put(Context context, String key, boolean value){
		SharedPreferences sharedPreferences = getAppSharedPrefs(context);
		SharedPreferences.Editor editor = sharedPreferences.edit();
		editor.putBoolean(key, value);
		editor.commit();
	}

	public static void put(Context context, String key, int value){
		SharedPreferences sharedPreferences = getAppSharedPrefs(context);
		SharedPreferences.Editor editor = sharedPreferences.edit();
		editor.putInt(key, value);
		editor.commit();
	}

	public static void put(Context context, String key, long value){
		SharedPreferences sharedPreferences = getAppSharedPrefs(context);
		SharedPreferences.Editor editor = sharedPreferences.edit();
		editor.putLong(key, value);
		editor.commit();
	}

	public static void put(Context context, String key, double value){
		SharedPreferences sharedPreferences = getAppSharedPrefs(context);
		SharedPreferences.Editor editor = sharedPreferences.edit();
		editor.putLong(key, Double.doubleToRawLongBits(value));
		editor.commit();
	}

	public static void put(Context context, String key, String value) {
		SharedPreferences sharedPreferences = getAppSharedPrefs(context);
		SharedPreferences.Editor editor = sharedPreferences.edit();
		editor.putString(key, value);
		editor.commit();
	}

	public static boolean get(Context context, String key, boolean defaultValue){
		return getAppSharedPrefs(context).getBoolean(key, defaultValue);
	}

	public static int get(Context context, String key, int defaultValue){
		return getAppSharedPrefs(context).getInt(key, defaultValue);
	}

	public static long get(Context context, String key, long defaultValue){
		return getAppSharedPrefs(context).getLong(key, defaultValue);
	}

	public static double get(Context context, String key, double defaultValue){
		return Double.longBitsToDouble(getAppSharedPrefs(context).getLong(key, Double.doubleToRawLongBits(defaultValue)));
	}

	public static String get(Context context, String key, String defaultValue){
		return getAppSharedPrefs(context).getString(key, defaultValue);
	}


	public class PrefHelperProxy extends IPrefHelper {

		private Context myContext;
		public PrefHelperProxy( Context ctx) {
			this.myContext = ctx;
		}

		@Override
		public boolean getPreferenceBool(String key, boolean defaultValue) {
			return PrefHelper.get(this.myContext, key, defaultValue);
		}

		@Override
		public void setPreferenceBool(String key, boolean value) {
			PrefHelper.put(this.myContext, key, value);
		}

		@Override
		public int getPreferenceInt(String key, int defaultValue) {
			return PrefHelper.get(this.myContext, key, defaultValue);
		}

		@Override
		public void setPreferenceInt(String key, int value) {
			PrefHelper.put(this.myContext, key, value);
		}

		@Override
		public long getPreferenceLong(String key, long defaultValue) {
			return PrefHelper.get(this.myContext, key, defaultValue);
		}

		@Override
		public void setPreferenceLong(String key, long value) {
			PrefHelper.put(this.myContext, key, value);
		}

		@Override
		public double getPreferenceDouble(String key, double defaultValue) {
			return PrefHelper.get(this.myContext, key, defaultValue);
		}

		@Override
		public void setPreferenceDouble(String key, double value) {
			PrefHelper.put(this.myContext, key, value);
		}

		@Override
		public String getPreferenceString(String key, String defaultValue) {
			return PrefHelper.get(this.myContext, key, defaultValue);
		}

		@Override
		public void setPreferenceString(String key, String value) {
			PrefHelper.put(this.myContext, key, value);
		}
	}
}
