package com.polestar.helpers;

import android.os.Parcel;

/**
 * Utility class for Parcel.
 * 
 * @author mmichel
 *
 */
public final class ParcelUtils {

	/**
	 * Because this class is an utility class only, its sole constructor is
	 * private to avoid useless instantiations.
	 */
	private ParcelUtils() {
		super();
	}

	/**
	 * Write a boolean to a parcel (using a byte)
	 * 
	 * @param parcel
	 *            The parcel.
	 * @param value
	 *            The value.
	 */
	public static final void writeBoolean(Parcel parcel, boolean value) {
		parcel.writeByte((byte) (value ? 1 : 0)); // if myBoolean == true, byte == 1
	}

	/**
	 * Read a boolean from a parcel (using a byte)
	 * 
	 * @param parcel
	 *            The parcel.
	 * 
	 * @return The boolean value.
	 */
	public static final boolean readBoolean(Parcel parcel) {
		return parcel.readByte() != 0; // myBoolean == true if byte != 0
	}

}
