package com.polestar.helpers;

//____________________________________________________________________________________
//
//  Log.java
// 
//  Pole Star Confidential Proprietary
//    Copyright (c) Pole Star 2010, All Rights Reserved
//    No publication authorized. Reverse engineering prohibited
//______________________________________________________________________________________

import com.polestar.Constants;
import com.polestar.naosdk.managers.NaoServiceManager;

/**
 * Filter log messages and redirect them to LogCat if needed<br />
 * Implemented as a singleton.
 *
 */

public class Log {
	/** singleton instance */
	static Log instance;
	
	/** tells if restricted logs are active */
	private final boolean isRestrictedLoggingActive  = ((Constants.mode_profile) <= (Constants.MODE_PROFILE_EL));
	
	/**
	 * get the single instance of Log<br />
	 * Default log level is LOG_LEVEL_NOLOG
	 */
	public static Log getInstance() {
		if (instance == null) {
			synchronized (Log.class) {
				// second check within the sync block ("Double-Check Locking")
				if (instance == null) {
					instance = new Log();
				}
			}
		}
		return instance;
	}
	
	/**
	 * private constructor
	 */
	private Log() {
		// void
	}
	
	/**
	 * Checks if restricted logs are active
	 * @return
	 */
	public static boolean getIsRestrictedLogActive() {
		return getInstance().isRestrictedLoggingActive;
	}
	
	public static void restricted(String tag, String message) {
		if (getInstance().isRestrictedLoggingActive) {
			android.util.Log.d(tag,message);
		}
	}

	public static void alwaysWarn(String tag, String message) {
		android.util.Log.w(tag,message);
	}

	public static void alwaysError(String tag, String message) {
		android.util.Log.e(tag, message);
	}

	/**
	 * writeToLog to .naolg if naocontext exit, otherwise on logCat
	 * @param tag
	 * @param log
	 */
	public static void writeToLog(String tag,String log) {
		if(NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null)  {
			NaoServiceManager.getService().getNaoContext().writeToLog(tag, log);
		} else {
			alwaysWarn(tag, log);
		}
	}

}
