package com.polestar.helpers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * Utility class for dates.
 * 
 * @author mmichel
 *
 */
public final class DateUtils {

	/**
	 * Because this class is an utility class only, its sole constructor is
	 * private to avoid useless instantiations.
	 */
	private DateUtils() {
		super();
	}

	/**
	 * Returns a string version of date formatted using ISO-8601 (only the date,
	 * not the time).
	 * 
	 * @param date
	 *            The date to get data from.
	 * 
	 * @return a string version of date formatted using ISO-8601 (only the date,
	 *         not the time).
	 */
	public static String toIso8601StringDate(Date date) {
		TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
		DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd",
				Locale.ENGLISH);
		dateFormat.setTimeZone(utcTimeZone);
		return dateFormat.format(date);
	}

	/**
	 * Return date to string formatted (yyyyMMddHHmmss)
	 * getDateString
	 *
	 * @return
	 */
	public static String getDateString() {
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
		Date now = new Date(); // Always initialized with current date & time
		return formatter.format(now);
	}
}
