package com.polestar.helpers;

import android.os.ParcelUuid;

import com.polestar.advertisement.ByteUtilsHelper;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;

/**
 * Created by claderriere on 19/04/2017.
 */

public class AssignedUuid {
    public static final int ASSIGNED_UUID_UNASSIGNED =	-1;

    public static final int ASSIGNED_UUID16_BYTES =	2;
    public static final int ASSIGNED_UUID32_BYTES =	4;
    public static final int UNASSIGNED_UUID_BYTES =	16;
    private static final byte[] ASSIGNED_UUID_NOBYTE = {};

    public static final int ASSIGNED_UUID_OFFSET =	8;
    public static final String ASSIGNED_UUID_ROOT =	"-0000-1000-8000-00805f9b34fb";

    ParcelUuid mUuid;
    int mAssignedUuid;



    public AssignedUuid(ParcelUuid uuid){
        mUuid = uuid;
        mAssignedUuid = processUuid(uuid);
    }

    public boolean isAssignedUuid(){
        return (mAssignedUuid != ASSIGNED_UUID_UNASSIGNED);
    }
    public boolean isAssignedUuid16(){
        if(this.isAssignedUuid() && (mAssignedUuid<Math.pow(2,16)))
            return true;

        return false;
    }
    public boolean isAssignedUuid32(){
        if( this.isAssignedUuid() && (!this.isAssignedUuid16()))
            return true;

        return false;
    }

    public int uuidLength(){
        if(this.isAssignedUuid16()){
            return ASSIGNED_UUID16_BYTES;
        }else if(this.isAssignedUuid32()){
            return ASSIGNED_UUID32_BYTES;
        }
        return UNASSIGNED_UUID_BYTES;
    }
    public byte[] uuidBytes(){
        byte [] uuidbytes;
        if(this.isAssignedUuid16()){
            uuidbytes = ByteUtilsHelper.getBytesFromShort((short) mAssignedUuid);
        }else if (this.isAssignedUuid32()){
            uuidbytes = ByteUtilsHelper.getBytesFromInt(mAssignedUuid);
        }else{
            // else, regular 128 bits uuid
            uuidbytes = AssignedUuid.uuidToByteArray(mUuid) ;
        }
        // invert endianness
        ByteUtilsHelper.invertArray(uuidbytes);
        return uuidbytes;
    }
    public String toString(){
        if(!this.isAssignedUuid()){
            return mUuid.toString();
        }else{
            if(this.isAssignedUuid16())
                return String.format ("%04x",mAssignedUuid);
            else
                return String.format ("%08x",mAssignedUuid);
        }
    }

    public static byte[] uuidToByteArray(ParcelUuid uid)
    {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uid.getUuid().getMostSignificantBits());
        bb.putLong(uid.getUuid().getLeastSignificantBits());

        return bb.array();
    }

    public static ParcelUuid  uuidFomByteArray(byte [] bytes)
    {
        if(bytes!=null){
            switch(bytes.length){
                case ASSIGNED_UUID16_BYTES:
                    String uidString = String.format ("0000%04X",ByteUtilsHelper.getShortFromByteArray(bytes)) + ASSIGNED_UUID_ROOT;
                    ParcelUuid uid = ParcelUuid.fromString(uidString);
                    return uid;
                case ASSIGNED_UUID32_BYTES:
                    return ParcelUuid.fromString(String.format ("%04x",ByteUtilsHelper.getIntFromByteArray(bytes)) + ASSIGNED_UUID_ROOT);
                default:
                    long msw = ByteBuffer.wrap(bytes).getLong();
                    long lsw = ByteBuffer.wrap(Arrays.copyOfRange(bytes,UNASSIGNED_UUID_BYTES/2,UNASSIGNED_UUID_BYTES)).getLong();
                    UUID u= new UUID(msw,lsw);
                    return new ParcelUuid(u);
            }
        }
        return null;
    }

    private static int processUuid(ParcelUuid uuid)
    {
        int assignedUuid = ASSIGNED_UUID_UNASSIGNED;
        String uuidRoot = uuid.toString().substring(ASSIGNED_UUID_OFFSET);
        if(uuidRoot.equalsIgnoreCase(ASSIGNED_UUID_ROOT) == true){
            assignedUuid = Integer.parseInt(uuid.toString().substring(0,ASSIGNED_UUID_OFFSET),16);
        }
        return assignedUuid;
    }
}