package com.polestar.enums;

public enum NRProximityEnum {
    NRProximityUnknown(0),
    NRProximityFar(1),
    NRProximityNear(2),
    NRProximityImmediate(3);
    
    private final int value;
    
    NRProximityEnum(int value) {
		this.value = value;
	}
    
    // order: 3, 2, 1, 0
    public static int compare(NRProximityEnum aProximity, NRProximityEnum anotherProximity){
    	int res = 0;
    	if (aProximity.value > anotherProximity.value){
    		res = -1;
    	}else if (aProximity.value < anotherProximity.value){
    		res = 1;
    	}
    	return res;
    }
    
    public int getValue() {
		return value;
	}

	public static String proximityString(NRProximityEnum prox){
		String proximityStr = "Unknown";
		switch (prox) {
		case NRProximityImmediate:
			proximityStr = "Immediate";
			break;
		case NRProximityNear:
			proximityStr = "Near";
			break;
		case NRProximityFar:
			proximityStr = "Far";
			break;	
		default:
			break;
		}
		return proximityStr;
    }
}
