package com.polestar.advertisement;

import java.util.Arrays;

public final class AdvertisementHelper {

    private AdvertisementHelper(){
        // TO AVOID INSTANTIATION
    }

    public static Advertisement parseScanRecord(final byte[] scanRecord) {
        final Advertisement ad = new Advertisement();

        int index = 0;
        while (index < scanRecord.length) {
            final int length = scanRecord[index++];
            //Done once we run out of records
            if (length == 0) break;

            final int type = ByteUtilsHelper.getIntFromByte(scanRecord[index]);

            //Done if our record isn't a valid type
            if (type == 0) break;
            
            try {
            	final byte[] data = Arrays.copyOfRange(scanRecord, index + 1, index + length);
            	ad.add(new AdvertisementData(length, type, data));
            } catch (ArrayIndexOutOfBoundsException e) {
            	throw new UnsupportedOperationException("Advertisement does not respect AD type format, thus cannot be correctly parsed");
            }

            //Advance
            index += length;
        }

        return ad;
    }
    public static Advertisement filterAdvertisement(final Advertisement advertisement, int type) {
       final Advertisement filteredAdv = new Advertisement();
       for (AdvertisementData data:advertisement) {
            if(data.getType() == type){
                filteredAdv.add(data);
            }
        }
        return filteredAdv;
    }
    public static AdvertisementData getADrecord(final Advertisement advertisement, int type) {
        for (AdvertisementData data:advertisement) {
            if(data.getType() == type){
                return data;
            }
        }
        return null;
    }

}
