package com.polestar.advertisement;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

import java.util.Arrays;


public final class AdvertisementData implements Parcelable {

    public static final int TYPE_FLAGS = 0x01;
    // SERVICE
    public static final int TYPE_UUID16_INC = 0x02;
    public static final int TYPE_UUID16 = 0x03;
    public static final int TYPE_UUID32_INC = 0x04;
    public static final int TYPE_UUID32 = 0x05;
    public static final int TYPE_UUID128_INC = 0x06;
    public static final int TYPE_UUID128 = 0x07;

    public static final int TYPE_LOCAL_NAME_SHORT = 0x08;
    public static final int TYPE_LOCAL_NAME_COMPLETE = 0x09;
    public static final int TYPE_TX_POWER_LEVEL = 0x0A;

    public static final int TYPE_DEVICE_CLASS = 0x0D;
    public static final int TYPE_SIMPLE_PAIRING_HASH_C = 0x0E;
    public static final int TYPE_SIMPLE_PAIRING_RANDOMIZER_R = 0x0F;

    public static final int TYPE_TK_VALUE = 0x10;
    public static final int TYPE_SECURITY_MANAGER_OOB_FLAGS = 0x11;

    public static final int TYPE_CONNECTION_INTERVAL_RANGE = 0x12;

    public static final int TYPE_SERVICE_UUIDS_LIST_16BIT = 0x14;
    public static final int TYPE_SERVICE_UUIDS_LIST_128BIT = 0x15;
    public static final int TYPE_SERVICE_DATA16 = 0x16;
    public static final int TYPE_SERVICE_DATA32 = 0x20;
    public static final int TYPE_SERVICE_DATA128 = 0x21;

    public static final int TYPE_MANUFACTURER_SPECIFIC_DATA = 0xFF;

    public static final int BYTES_UUID16 = 2;
    public static final int BYTES_UUID32 = 4;
    public static final int BYTES_UUID128 = 16;
    public static final int BYTES_MANUFACTURER = 2;
   
    public static final Parcelable.Creator<AdvertisementData> CREATOR = new Parcelable.Creator<AdvertisementData>() {
        public AdvertisementData createFromParcel(final Parcel in) {
            return new AdvertisementData(in);
        }

        public AdvertisementData[] newArray(final int size) {
            return new AdvertisementData[size];
        }
    };
    
    private static final String PARCEL_RECORD_DATA = "record_data";
    private static final String PARCEL_RECORD_TYPE = "record_type";
    private static final String PARCEL_RECORD_LENGTH = "record_length";
    /* Model Object Definition */
    private final int mLength;
    private final int mType;
    private final byte[] mData;

    public AdvertisementData(final int length, final int type, final byte[] data) {
        mLength = length;
        mType = type;
        mData = data;
    }

    public AdvertisementData(final Parcel in) {
        final Bundle b = in.readBundle(getClass().getClassLoader());
        mLength = b.getInt(PARCEL_RECORD_LENGTH);
        mType = b.getInt(PARCEL_RECORD_TYPE);
        mData = b.getByteArray(PARCEL_RECORD_DATA);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public byte[] getData() {
        return mData;
    }

    public String getHumanReadableType() {
        return getHumanReadableAdType(mType);
    }

    public int getLength() {
        return mLength;
    }

    public int getType() {
        return mType;
    }

    @Override
    public String toString() {
        return "Ad [len=" + mLength + ", type=" + mType + " ("+getHumanReadableType()+"), data=" + Arrays.toString(mData) + "]";
    }

    @Override
    public void writeToParcel(final Parcel parcel, final int arg1) {
        final Bundle b = new Bundle(getClass().getClassLoader());

        b.putInt(PARCEL_RECORD_LENGTH, mLength);
        b.putInt(PARCEL_RECORD_TYPE, mType);
        b.putByteArray(PARCEL_RECORD_DATA, mData);

        parcel.writeBundle(b);
    }

    private static String getHumanReadableAdType(final int type) {
        switch (type) {
            case TYPE_CONNECTION_INTERVAL_RANGE:
                return "Slave Connection Interval Range";
            case TYPE_DEVICE_CLASS:
                return "Class of device";
            case TYPE_FLAGS:
                return "Flags";
            case TYPE_MANUFACTURER_SPECIFIC_DATA:
                return "Manufacturer Specific Data";
            case TYPE_LOCAL_NAME_COMPLETE:
                return "Name (Complete)";
            case TYPE_LOCAL_NAME_SHORT:
                return "Name (Short)";
            case TYPE_SECURITY_MANAGER_OOB_FLAGS:
                return "Security Manager OOB Flags";
            case TYPE_SERVICE_UUIDS_LIST_128BIT:
                return "Service UUIDs (128bit)";
            case TYPE_SERVICE_UUIDS_LIST_16BIT:
                return "Service UUIDs (16bit)";
            case TYPE_SERVICE_DATA16:
                return "Service Data - 16 bit uuid";
            case TYPE_SERVICE_DATA32:
                return "Service Data - 32 bit uuid";
            case TYPE_SERVICE_DATA128:
                return "Service Data - 128 bit uuid";
            case TYPE_SIMPLE_PAIRING_HASH_C:
                return "Simple Pairing Hash C";
            case TYPE_SIMPLE_PAIRING_RANDOMIZER_R:
                return "Simple Pairing Randomizer R";
            case TYPE_TK_VALUE:
                return "TK Value";
            case TYPE_TX_POWER_LEVEL:
                return "Transmission Power Level";
            case TYPE_UUID128:
                return "Complete list of 128-bit UUIDs available";
            case TYPE_UUID128_INC:
                return "More 128-bit UUIDs available";
            case TYPE_UUID16:
                return "Complete list of 16-bit UUIDs available";
            case TYPE_UUID16_INC:
                return "More 16-bit UUIDs available";
            case TYPE_UUID32:
                return "Complete list of 32-bit UUIDs available";
            case TYPE_UUID32_INC:
                return "More 32-bit UUIDs available";
            default:
                return "Unknown AdRecord Structure: " + type;
        }
    }
    public static int bytesForUuid(int type) {
        switch (type) {
            case AdvertisementData.TYPE_UUID16:
            case AdvertisementData.TYPE_UUID16_INC:
            case AdvertisementData.TYPE_SERVICE_DATA16:
                return AdvertisementData.BYTES_UUID16;
            case AdvertisementData.TYPE_UUID32:
            case AdvertisementData.TYPE_UUID32_INC:
            case AdvertisementData.TYPE_SERVICE_DATA32:
                return AdvertisementData.BYTES_UUID32;
            case AdvertisementData.TYPE_UUID128:
            case AdvertisementData.TYPE_UUID128_INC:
            case AdvertisementData.TYPE_SERVICE_DATA128:
                return AdvertisementData.BYTES_UUID128;
            case AdvertisementData.TYPE_MANUFACTURER_SPECIFIC_DATA:
                return AdvertisementData.BYTES_MANUFACTURER;
            default:
                return -1;
        }
    }
}