/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.gatt;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.polestar.naosdk.gatt.GattInterface;
import com.polestar.naosdk.gatt.INAOGattListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@RequiresApi(api=18)
public class GattManager
extends GattInterface {
    private static final String TAG = "GattManager";
    private Context a;
    private b a;
    private INAOGattListener a;
    private BluetoothAdapter a;
    private BluetoothManager a;
    private ConcurrentHashMap<String, BluetoothGatt> a;
    private ConcurrentHashMap<String, BluetoothGatt> b;
    private ConcurrentHashMap<String, HashMap<UUID, UUID>> c;
    private final BluetoothGattCallback mGattCallback;

    public GattManager(Context context, INAOGattListener iNAOGattListener) {
        new Handler(Looper.getMainLooper());
        this.mGattCallback = new BluetoothGattCallback(){

            public void onConnectionStateChange(final BluetoothGatt bluetoothGatt, final int n2, int n3) {
                Log.i((String)GattManager.TAG, (String)("OnConnectionStateChange: " + bluetoothGatt.getDevice().getAddress() + " newState: " + n3 + " Status: " + n2));
                if (n2 != 133 && n2 != 8) {
                    if (n2 != 19 && n2 != 128 && n2 != 257) {
                        if (n3 == 2 && n2 == 0) {
                            a a2 = this;
                            Log.d((String)GattManager.TAG, (String)("Device " + bluetoothGatt.getDevice().getAddress() + " connected!"));
                            a2.GattManager.this.a.put(bluetoothGatt.getDevice().getAddress(), bluetoothGatt);
                            if (a2.GattManager.this.b.containsKey(bluetoothGatt.getDevice().getAddress())) {
                                GattManager.this.b.remove(bluetoothGatt.getDevice().getAddress());
                            }
                            if (Build.VERSION.SDK_INT >= 21) {
                                bluetoothGatt.requestConnectionPriority(1);
                            }
                            Log.d((String)GattManager.TAG, (String)("Connection size: " + GattManager.this.a.size()));
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        GattManager.this.a.onConnected(bluetoothGatt.getDevice().getAddress());
                                    }
                                    catch (Exception exception) {
                                        Log.e((String)GattManager.TAG, (String)("Device: " + bluetoothGatt.getDevice().getAddress() + " - error: " + exception.getMessage()));
                                        GattManager.this.disconnect(bluetoothGatt.getDevice().getAddress());
                                    }
                                }
                            }).start();
                        } else if (n3 == 0) {
                            a a3 = this;
                            Log.d((String)GattManager.TAG, (String)("Disconnected: " + bluetoothGatt.getDevice().getAddress()));
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        GattManager.this.a.onDisconnected(bluetoothGatt.getDevice().getAddress());
                                    }
                                    catch (Exception exception) {
                                        Log.e((String)GattManager.TAG, (String)exception.getMessage());
                                    }
                                }
                            }).start();
                            a3.GattManager.this.checkPendingGattConnection(bluetoothGatt.getDevice().getAddress());
                            a3.GattManager.this.a(bluetoothGatt.getDevice().getAddress());
                            if (bluetoothGatt != null) {
                                Log.e((String)GattManager.TAG, (String)(bluetoothGatt.getDevice().getAddress() + " BluetoothGatt connection should be closed - closing gatt"));
                                bluetoothGatt.close();
                            }
                        } else if (n3 == 1) {
                            Log.d((String)GattManager.TAG, (String)("Connecting: " + bluetoothGatt.getDevice().getAddress()));
                        } else {
                            if (GattManager.this.a.containsKey(bluetoothGatt.getDevice().getAddress())) {
                                Log.e((String)GattManager.TAG, (String)"onGattError");
                                new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        INAOGattListener iNAOGattListener = GattManager.this.a;
                                        g g2 = this;
                                        g g3 = g2;
                                        String string2 = g2.bluetoothGatt.getDevice().getAddress();
                                        try {
                                            iNAOGattListener.onGattError(string2, g3.n2);
                                        }
                                        catch (Exception exception) {
                                            Log.e((String)GattManager.TAG, (String)("Device: " + bluetoothGatt.getDevice().getAddress() + " - error: " + exception.getMessage()));
                                            GattManager.this.disconnect(bluetoothGatt.getDevice().getAddress());
                                        }
                                    }
                                }).start();
                                GattManager.this.a(bluetoothGatt.getDevice().getAddress());
                            }
                            GattManager.this.checkPendingGattConnection(bluetoothGatt.getDevice().getAddress());
                            if (bluetoothGatt != null) {
                                Log.e((String)GattManager.TAG, (String)(bluetoothGatt.getDevice().getAddress() + " BluetoothGatt connection should be closed - closing gatt"));
                                bluetoothGatt.close();
                            }
                        }
                        return;
                    }
                    if (GattManager.this.a.containsKey(bluetoothGatt.getDevice().getAddress())) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    GattManager.this.a.onDisconnected(bluetoothGatt.getDevice().getAddress());
                                }
                                catch (Exception exception) {
                                    Log.e((String)GattManager.TAG, (String)exception.getMessage());
                                }
                            }
                        }).start();
                        if (GattManager.this.a.get(bluetoothGatt.getDevice().getAddress()) != null) {
                            ((BluetoothGatt)GattManager.this.a.get(bluetoothGatt.getDevice().getAddress())).disconnect();
                        }
                        GattManager.this.a(bluetoothGatt.getDevice().getAddress());
                    } else {
                        GattManager.this.checkPendingGattConnection(bluetoothGatt.getDevice().getAddress());
                        if (bluetoothGatt != null) {
                            Log.e((String)GattManager.TAG, (String)(bluetoothGatt.getDevice().getAddress() + " BluetoothGatt connection not in myGattConnections but closing gatt anyway"));
                            bluetoothGatt.close();
                        }
                    }
                    return;
                }
                if (GattManager.this.a.containsKey(bluetoothGatt.getDevice().getAddress())) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            INAOGattListener iNAOGattListener = string2.GattManager.this.a;
                            c c2 = string2;
                            c c3 = c2;
                            String string2 = c2.bluetoothGatt.getDevice().getAddress();
                            try {
                                iNAOGattListener.onGattError(string2, c3.n2);
                            }
                            catch (Exception exception) {
                                Log.e((String)GattManager.TAG, (String)exception.getMessage());
                            }
                        }
                    }).start();
                    GattManager.this.a(bluetoothGatt.getDevice().getAddress());
                } else {
                    GattManager.this.checkPendingGattConnection(bluetoothGatt.getDevice().getAddress());
                    if (bluetoothGatt != null) {
                        Log.e((String)GattManager.TAG, (String)(bluetoothGatt.getDevice().getAddress() + " BluetoothGatt connection not in myGattConnections but closing gatt anyway"));
                        bluetoothGatt.close();
                    }
                }
            }

            public void onServicesDiscovered(final BluetoothGatt bluetoothGatt, final int n2) {
                Log.d((String)GattManager.TAG, (String)("onService discovered status: " + n2));
                if (n2 == 0) {
                    HashMap<UUID, UUID> hashMap;
                    HashSet<String> hashSet;
                    Log.i((String)GattManager.TAG, (String)(bluetoothGatt.getServices().size() + " services discovered"));
                    final HashSet<String> hashSet2 = hashSet;
                    hashSet = new HashSet<String>();
                    HashMap<UUID, UUID> hashMap2 = hashMap;
                    hashMap = new HashMap<UUID, UUID>();
                    for (BluetoothGattService bluetoothGattService : bluetoothGatt.getServices()) {
                        for (BluetoothGattCharacteristic bluetoothGattCharacteristic : bluetoothGattService.getCharacteristics()) {
                            UUID uUID = bluetoothGattCharacteristic.getUuid();
                            hashMap2.put(uUID, bluetoothGattService.getUuid());
                            hashSet2.add(bluetoothGattCharacteristic.getUuid().toString().toUpperCase());
                        }
                    }
                    GattManager.this.c.put(bluetoothGatt.getDevice().getAddress(), hashMap2);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            INAOGattListener iNAOGattListener = GattManager.this.a;
                            h h2 = this;
                            h h3 = h2;
                            String string2 = h2.bluetoothGatt.getDevice().getAddress();
                            try {
                                iNAOGattListener.onServicesDiscovered(string2, h3.hashSet2);
                            }
                            catch (Exception exception) {
                                Log.e((String)GattManager.TAG, (String)("Device: " + bluetoothGatt.getDevice().getAddress() + " - error: " + exception.getMessage()));
                                GattManager.this.disconnect(bluetoothGatt.getDevice().getAddress());
                            }
                        }
                    }).start();
                } else {
                    Log.w((String)GattManager.TAG, (String)("onServicesDiscovered received: " + n2));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            INAOGattListener iNAOGattListener = GattManager.this.a;
                            i i2 = this;
                            i i3 = i2;
                            String string2 = i2.bluetoothGatt.getDevice().getAddress();
                            try {
                                iNAOGattListener.onGattError(string2, i3.n2);
                            }
                            catch (Exception exception) {
                                Log.e((String)GattManager.TAG, (String)("Device: " + bluetoothGatt.getDevice().getAddress() + " - error: " + exception.getMessage()));
                                GattManager.this.disconnect(bluetoothGatt.getDevice().getAddress());
                            }
                        }
                    }).start();
                }
            }

            public void onCharacteristicRead(final BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic object, final int n2) {
                Log.d((String)GattManager.TAG, (String)("onCharacteristicRead: " + n2));
                if (n2 == 0 && object.getValue() != null) {
                    Runnable runnable;
                    Runnable runnable2 = runnable;
                    runnable = new Runnable((BluetoothGattCharacteristic)object){
                        final /* synthetic */ BluetoothGattCharacteristic a;
                        {
                            this.a = bluetoothGattCharacteristic;
                        }

                        @Override
                        public void run() {
                            INAOGattListener iNAOGattListener = GattManager.this.a;
                            String string2 = bluetoothGatt.getDevice().getAddress();
                            j j2 = this;
                            j j3 = j2;
                            String string3 = j2.a.getUuid().toString().toUpperCase();
                            try {
                                iNAOGattListener.onReadAttribute(string2, string3, j3.a.getValue());
                            }
                            catch (Exception exception) {
                                Log.e((String)GattManager.TAG, (String)("Device: " + bluetoothGatt.getDevice().getAddress() + " - error: " + exception.getMessage()));
                                GattManager.this.disconnect(bluetoothGatt.getDevice().getAddress());
                            }
                        }
                    };
                    new Thread(runnable2).start();
                } else {
                    Runnable runnable;
                    object = runnable;
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            INAOGattListener iNAOGattListener = GattManager.this.a;
                            k k2 = this;
                            k k3 = k2;
                            String string2 = k2.bluetoothGatt.getDevice().getAddress();
                            try {
                                iNAOGattListener.onGattError(string2, k3.n2);
                            }
                            catch (Exception exception) {
                                Log.e((String)GattManager.TAG, (String)("Device: " + bluetoothGatt.getDevice().getAddress() + " - error: " + exception.getMessage()));
                                GattManager.this.disconnect(bluetoothGatt.getDevice().getAddress());
                            }
                        }
                    };
                    new Thread((Runnable)object).start();
                }
            }

            public void onCharacteristicWrite(final BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic object, final int n2) {
                Log.d((String)GattManager.TAG, (String)("on device: " + bluetoothGatt.getDevice().getAddress() + " onCharacteristicWrite: " + n2));
                if (n2 == 0) {
                    Runnable runnable;
                    Runnable runnable2 = runnable;
                    runnable = new Runnable((BluetoothGattCharacteristic)object){
                        final /* synthetic */ BluetoothGattCharacteristic a;
                        {
                            this.a = bluetoothGattCharacteristic;
                        }

                        @Override
                        public void run() {
                            try {
                                GattManager.this.a.onWriteAttribute(bluetoothGatt.getDevice().getAddress(), this.a.getUuid().toString().toUpperCase());
                            }
                            catch (Exception exception) {
                                Log.e((String)GattManager.TAG, (String)("Device: " + bluetoothGatt.getDevice().getAddress() + " - error: " + exception.getMessage()));
                                GattManager.this.disconnect(bluetoothGatt.getDevice().getAddress());
                            }
                        }
                    };
                    new Thread(runnable2).start();
                } else {
                    Runnable runnable;
                    object = runnable;
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            INAOGattListener iNAOGattListener = GattManager.this.a;
                            b b2 = this;
                            b b3 = b2;
                            String string2 = b2.bluetoothGatt.getDevice().getAddress();
                            try {
                                iNAOGattListener.onGattError(string2, b3.n2);
                            }
                            catch (Exception exception) {
                                GattManager.this.disconnect(bluetoothGatt.getDevice().getAddress());
                                Log.e((String)GattManager.TAG, (String)exception.getMessage());
                            }
                        }
                    };
                    new Thread((Runnable)object).start();
                }
            }

            public void onCharacteristicChanged(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                super.onCharacteristicChanged(bluetoothGatt, bluetoothGattCharacteristic);
            }

            public void onDescriptorRead(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n2) {
                super.onDescriptorRead(bluetoothGatt, bluetoothGattDescriptor, n2);
            }

            public void onDescriptorWrite(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n2) {
                super.onDescriptorWrite(bluetoothGatt, bluetoothGattDescriptor, n2);
            }

            public void onReliableWriteCompleted(BluetoothGatt bluetoothGatt, int n2) {
                super.onReliableWriteCompleted(bluetoothGatt, n2);
            }

            public void onReadRemoteRssi(BluetoothGatt bluetoothGatt, int n2, int n3) {
                super.onReadRemoteRssi(bluetoothGatt, n2, n3);
            }

            public void onMtuChanged(BluetoothGatt bluetoothGatt, int n2, int n3) {
                super.onMtuChanged(bluetoothGatt, n2, n3);
            }
        };
        this.a = context;
        this.a = iNAOGattListener;
        this.a = new ConcurrentHashMap();
        this.b = new ConcurrentHashMap();
        this.c = new ConcurrentHashMap();
        this.initBluetoothAdapter();
        this.a = new b(this, context);
    }

    @RequiresApi(api=18)
    private void a(String string2) {
        if (this.a.containsKey(string2)) {
            GattManager gattManager = this;
            ((BluetoothGatt)gattManager.a.get(string2)).close();
            gattManager.a.remove(string2);
        }
    }

    @RequiresApi(api=18)
    public void initBluetoothAdapter() {
        if (this.a == null && (this.a = (BluetoothManager)this.a.getSystemService("bluetooth")) == null) {
            Log.e((String)TAG, (String)"Unable to initialize BluetoothManager.");
            return;
        }
        Log.d((String)TAG, (String)"Setting a new BluetoothAdapter.");
        this.a = Build.VERSION.SDK_INT >= 18 ? this.a.getAdapter() : BluetoothAdapter.getDefaultAdapter();
        if (this.a == null) {
            Log.e((String)TAG, (String)"Unable to obtain a BluetoothAdapter.");
            return;
        }
    }

    @Override
    @RequiresApi(api=18)
    public boolean connect(String string2, boolean bl) {
        Log.i((String)TAG, (String)("call connect on: " + string2));
        if (this.a.containsKey(string2) && this.a.get(string2) != null) {
            Log.e((String)TAG, (String)(string2 + " already connected !"));
            return false;
        }
        if (this.b.containsKey(string2)) {
            if (this.b.get(string2) != null) {
                Log.d((String)TAG, (String)(string2 + " already pending connection!"));
                return false;
            }
            Log.e((String)TAG, (String)(string2 + " removing gatt from pending connections !"));
            this.b.remove(string2);
        }
        BluetoothDevice bluetoothDevice = this.a.getConnectedDevices(7).iterator();
        while (bluetoothDevice.hasNext()) {
            if (((BluetoothDevice)bluetoothDevice.next()).getAddress() != string2) continue;
            Log.e((String)TAG, (String)(string2 + " already connected but can't be used !"));
            return false;
        }
        GattManager gattManager = this;
        bluetoothDevice = gattManager.a.getRemoteDevice(string2);
        BluetoothGatt bluetoothGatt = gattManager.a.a(bluetoothDevice, bl, this.mGattCallback);
        if (bluetoothGatt != null) {
            this.b.put(string2, bluetoothGatt);
            return true;
        }
        return false;
    }

    public void checkPendingGattConnection(String string2) {
        if (this.b.containsKey(string2)) {
            if (this.b.get(string2) != null) {
                this.b.get(string2).close();
            }
            Log.d((String)TAG, (String)("Remove Device " + string2 + " from pending connections!"));
            this.b.remove(string2);
        }
    }

    @Override
    @RequiresApi(api=18)
    public void disconnect(String string2) {
        GattManager gattManager = this;
        Log.i((String)TAG, (String)("call disconnect on: " + string2));
        gattManager.checkPendingGattConnection(string2);
        if (!gattManager.a.containsKey(string2)) {
            Log.e((String)TAG, (String)(string2 + " already disconnected !"));
            return;
        }
        ((BluetoothGatt)this.a.get(string2)).disconnect();
    }

    @Override
    public boolean discoverServices(String string2) {
        if ((BluetoothGatt)this.a.get(string2) == null) {
            Log.e((String)TAG, (String)"discoverServices Gatt null");
            return false;
        }
        boolean bl = ((BluetoothGatt)this.a.get(string2)).discoverServices();
        Log.d((String)TAG, (String)("discover services: " + bl));
        return bl;
    }

    @Override
    public boolean read(String string2, String string3, String string4) {
        Log.d((String)TAG, (String)("on device: " + string2 + " read on characteristic: " + string4));
        string3 = (BluetoothGatt)((GattManager)((Object)uUID)).a.get(string2);
        if (string3 == null) {
            return false;
        }
        String string5 = string3;
        GattManager gattManager = uUID;
        UUID uUID = UUID.fromString(string4);
        return string5.readCharacteristic(string5.getService(gattManager.c.get(string2).get(uUID)).getCharacteristic(uUID));
    }

    @Override
    public boolean write(String string2, String string3, String string4, byte[] byArray) {
        Log.d((String)TAG, (String)("on device: " + string2 + " write on characteristic:" + string4));
        string3 = (BluetoothGatt)this.a.get(string2);
        if (string3 == null) {
            return false;
        }
        String string5 = string3;
        BluetoothGattCharacteristic bluetoothGattCharacteristic = string5.getService(this.c.get(string2).get(UUID.fromString(string4))).getCharacteristic(UUID.fromString(string4));
        bluetoothGattCharacteristic.setValue(byArray);
        return string5.writeCharacteristic(bluetoothGattCharacteristic);
    }

    @Override
    public void clearGatt() {
        Iterator<Object> iterator = this.a.values().iterator();
        while (iterator.hasNext()) {
            this.a(((BluetoothGatt)iterator.next()).getDevice().getAddress());
        }
        GattManager gattManager = this;
        gattManager.a.clear();
        iterator = gattManager.b.values().iterator();
        while (iterator.hasNext()) {
            this.checkPendingGattConnection(((BluetoothGatt)iterator.next()).getDevice().getAddress());
        }
        this.b.clear();
    }

    private class b {
        private final Context a;

        public b(GattManager gattManager, Context context) {
            this.a = context;
        }

        private BluetoothGatt a(BluetoothGattCallback bluetoothGattCallback, BluetoothDevice bluetoothDevice, boolean bl) {
            Log.v((String)GattManager.TAG, (String)"Connecting without reflection");
            if (Build.VERSION.SDK_INT >= 23) {
                return bluetoothDevice.connectGatt(this.a, bl, bluetoothGattCallback, 2);
            }
            return bluetoothDevice.connectGatt(this.a, bl, bluetoothGattCallback);
        }

        private boolean a(BluetoothGatt bluetoothGatt, BluetoothGattCallback bluetoothGattCallback, boolean bl) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
            Log.v((String)GattManager.TAG, (String)"Connecting using reflection");
            objectArray.a(bluetoothGatt, bl);
            Class[] classArray = new Class[2];
            Object[] objectArray = classArray;
            classArray[0] = Boolean.class;
            classArray[1] = BluetoothGattCallback.class;
            Method method = bluetoothGatt.getClass().getDeclaredMethod("connect", (Class<?>[])objectArray);
            method.setAccessible(true);
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = Boolean.TRUE;
            objectArray2[1] = bluetoothGattCallback;
            return (Boolean)method.invoke((Object)bluetoothGatt, objectArray);
        }

        @TargetApi(value=23)
        private BluetoothGatt a(Object object, BluetoothDevice bluetoothDevice) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            Constructor<?> constructor = BluetoothGatt.class.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            Log.v((String)GattManager.TAG, (String)("Found constructor with args count = " + constructor.getParameterTypes().length));
            if (constructor.getParameterTypes().length == 4) {
                return (BluetoothGatt)constructor.newInstance(this.a, object, bluetoothDevice, 2);
            }
            return (BluetoothGatt)constructor.newInstance(this.a, object, bluetoothDevice);
        }

        private Object a(Object object) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            if (object == null) {
                return null;
            }
            return this.a(object.getClass(), "getBluetoothGatt").invoke(object, new Object[0]);
        }

        private Object a() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter == null) {
                return null;
            }
            return this.a(bluetoothAdapter.getClass(), "getBluetoothManager").invoke((Object)bluetoothAdapter, new Object[0]);
        }

        private Method a(Class<?> clazz, String string2) throws NoSuchMethodException {
            Method method = clazz.getDeclaredMethod(string2, new Class[0]);
            method.setAccessible(true);
            return method;
        }

        private void a(BluetoothGatt bluetoothGatt, boolean bl) throws NoSuchFieldException, IllegalAccessException {
            Field field = bluetoothGatt.getClass().getDeclaredField("mAutoConnect");
            field.setAccessible(true);
            field.setBoolean(bluetoothGatt, bl);
        }

        /*
         * Unable to fully structure code
         */
        public BluetoothGatt a(BluetoothDevice var1_1, boolean var2_2, BluetoothGattCallback var3_11) {
            block17: {
                block16: {
                    block15: {
                        if (var1_1 == null) {
                            return null;
                        }
                        if (Build.VERSION.SDK_INT >= 23 || !var2_2) break block17;
                        v0 = this;
                        v1 = v0;
                        v2 = v0;
                        Log.v((String)"GattManager", (String)"Trying to connectGatt using reflection.");
                        var2_3 = v2.a(v1.a());
                        if (var2_3 != null) ** GOTO lbl21
                        v3 = this;
                        v4 = var3_11;
                        v5 = var1_1;
                        Log.w((String)"GattManager", (String)"Couldn't get iBluetoothGatt object");
                        return v3.a(v4, v5, true);
lbl21:
                        // 1 sources

                        if ((var2_3 = this.a(var2_3, var1_1)) != null) ** GOTO lbl30
                        v6 = this;
                        v7 = var3_11;
                        v8 = var1_1;
                        Log.w((String)"GattManager", (String)"Couldn't create BluetoothGatt object");
                        return v6.a(v7, v8, true);
lbl30:
                        // 1 sources

                        if (this.a((BluetoothGatt)var2_3, var3_11, true)) break block15;
                        v9 = var2_3;
                        Log.w((String)"GattManager", (String)"Connection using reflection failed, closing gatt");
                        try {
                            v9.close();
                        }
                        catch (NoSuchFieldException var2_4) {
                            break block16;
                        }
                        catch (InstantiationException var2_5) {
                            break block16;
                        }
                        catch (InvocationTargetException var2_6) {
                            break block16;
                        }
                        catch (IllegalArgumentException var2_7) {
                            break block16;
                        }
                        catch (IllegalAccessException var2_8) {
                            break block16;
                        }
                        catch (NoSuchMethodException var2_9) {
                            // empty catch block
                        }
                    }
                    return var2_3;
                }
                Log.w((String)"GattManager", (String)("Error during reflection" + var2_10));
                return this.a(var3_11, var1_1, true);
            }
            return this.a(var3_11, var1_1, var2_2);
        }
    }
}

