/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.controllers;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import androidx.annotation.Nullable;
import com.polestar.R;
import com.polestar.helpers.Log;
import com.polestar.helpers.PrefHelper;
import com.polestar.helpers.i;
import com.polestar.naosdk.api.IOSLocationRequestListener;
import com.polestar.naosdk.api.LocationFix;
import com.polestar.naosdk.api.external.NAOWakeUpNotifier;
import com.polestar.naosdk.controllers.AndroidCoverageService;
import com.polestar.naosdk.controllers.a;
import com.polestar.naosdk.controllers.b;
import com.polestar.naosdk.controllers.c;
import com.polestar.naosdk.managers.NaoServiceManager;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AndroidGeofencingService
extends Service {
    private String a;
    private Notification a;
    private Context a;

    public AndroidGeofencingService() {
        AndroidGeofencingService androidGeofencingService = this;
        androidGeofencingService.a = ((Object)((Object)androidGeofencingService)).getClass().getSimpleName();
    }

    public static boolean isInsideOSGeofence(Context context) {
        Log.restricted("AndroidGeofencingService", ">> isInsideOSGeofence: " + PrefHelper.get(context, "inside_geofence_area", false));
        return PrefHelper.get(context, "inside_geofence_area", false);
    }

    private void a() {
        String string2 = PrefHelper.get(object.getApplicationContext(), "[logger]service_name", null);
        Log.restricted(object.a, " >> createNaoContext ");
        if (string2 != null) {
            AndroidGeofencingService androidGeofencingService = object;
            Object object = Class.forName(string2);
            try {
                NaoServiceManager.startService(androidGeofencingService.a, object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
    }

    public void onCreate() {
        AndroidGeofencingService androidGeofencingService = object;
        super.onCreate();
        androidGeofencingService.a = androidGeofencingService.getApplicationContext();
        NAOWakeUpNotifier nAOWakeUpNotifier = com.polestar.naosdk.controllers.a.a(androidGeofencingService.getApplicationContext());
        if (Build.VERSION.SDK_INT >= 26) {
            if (nAOWakeUpNotifier != null) {
                object.a = nAOWakeUpNotifier.wakeUpNotification();
            }
            if ((nAOWakeUpNotifier = object.a) != null) {
                object.startForeground(1000, (Notification)nAOWakeUpNotifier);
            } else {
                AndroidGeofencingService androidGeofencingService2 = object;
                Context context = androidGeofencingService2.a;
                AndroidGeofencingService androidGeofencingService3 = object;
                Object object = androidGeofencingService3.a.getString(R.string.pst_notification_name);
                nAOWakeUpNotifier = com.polestar.helpers.l.a.a(androidGeofencingService3.a);
                androidGeofencingService2.startForeground(1000, com.polestar.helpers.l.a.a(context, context.getString(R.string.pst_notification_name), (String)object, 17301659, (NotificationChannel)nAOWakeUpNotifier, false, false, false, null, null));
            }
        }
    }

    public int onStartCommand(Intent object, int n2, int n3) {
        String string2;
        if (object.hasExtra("event") && (string2 = object.getStringExtra("event")) != null) {
            object = object.getStringArrayListExtra("geofences");
            if (string2.equalsIgnoreCase("enter")) {
                this.a((ArrayList<String>)object);
            } else if (string2.equalsIgnoreCase("exit")) {
                this.b((ArrayList<String>)object);
            }
        }
        return 2;
    }

    public void onDestroy() {
        AndroidGeofencingService androidGeofencingService = this;
        super.onDestroy();
        Log.restricted(androidGeofencingService.a, " >> onDestroy");
    }

    protected void a(ArrayList<String> object) {
        boolean bl = AndroidGeofencingService.isInsideOSGeofence(this.a);
        Log.restricted(this.a, " >> handleEnterGeofences, geofences: " + object + " isInsideOSGeofence: " + bl);
        if (!bl) {
            AndroidGeofencingService androidGeofencingService = this;
            PrefHelper.put(androidGeofencingService.a, "inside_geofence_area", true);
            Object object2 = com.polestar.naosdk.controllers.a.a(androidGeofencingService.a);
            if (object2 != null) {
                object = ((ArrayList)object).get(0);
                ((NAOWakeUpNotifier)object2).onEnterGPSArea();
                if (Build.VERSION.SDK_INT < 26) {
                    int n2 = new b(this.a).a((String)object);
                    object2 = ((Object)((Object)this)).getClass().getSimpleName();
                    StringBuilder stringBuilder = new StringBuilder().append("handleEnterGeofences >> startAndroidCoverageService -> location timeout: ");
                    int n3 = n2 != -1 ? n2 : 3600000;
                    Log.restricted((String)object2, stringBuilder.append(n3).toString());
                    object2 = this.getApplicationContext();
                    boolean bl2 = false;
                    if (n2 == -1) {
                        n2 = 3600000;
                    }
                    com.polestar.naosdk.controllers.a.a((Context)object2, bl2, n2);
                }
            }
        }
        if (Build.VERSION.SDK_INT >= 26) {
            a a2;
            a a3 = a2;
            if (new a(this.a).a()) {
                a3.a((com.polestar.models.a)null);
            }
        }
        this.stopSelf();
    }

    protected void b(ArrayList<String> object) {
        ArrayList<String> arrayList = object;
        AndroidGeofencingService androidGeofencingService = this;
        boolean bl = AndroidGeofencingService.isInsideOSGeofence(androidGeofencingService.a);
        Log.writeToLog(androidGeofencingService.a, " >> handleExitGeofences, geofences: " + object + " isInsideOSGeofence: " + bl);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        if (Arrays.asList(stringArray).contains("sites_metacircle") || Arrays.asList(stringArray).contains("pdbs_metacircle")) {
            ArrayList<String> arrayList2 = object;
            this.a(stringArray);
            arrayList2.remove("sites_metacircle");
            arrayList2.remove("pdbs_metacircle");
            if (arrayList2.isEmpty()) {
                this.stopSelf();
                return;
            }
        }
        if (bl) {
            AndroidGeofencingService androidGeofencingService2 = this;
            PrefHelper.put(androidGeofencingService2.a, "inside_geofence_area", false);
            object = com.polestar.naosdk.controllers.a.a(androidGeofencingService2.a);
            if (object != null) {
                ((NAOWakeUpNotifier)object).onExitGPSArea();
                if (Build.VERSION.SDK_INT < 26) {
                    if (AndroidCoverageService.a()) {
                        AndroidGeofencingService androidGeofencingService3 = this;
                        Log.restricted(((Object)((Object)androidGeofencingService3)).getClass().getSimpleName(), "handleExitGeofences >> startAndroidCoverageService -> checkExit");
                        com.polestar.naosdk.controllers.a.a(androidGeofencingService3.getApplicationContext(), true);
                    } else {
                        ((NAOWakeUpNotifier)object).onExitCoverage();
                        com.polestar.naosdk.controllers.a.a(this.getApplicationContext());
                    }
                }
            }
        }
        this.stopSelf();
    }

    protected void a(final String[] stringArray) {
        Runnable runnable;
        final Context context = this.a;
        if (NaoServiceManager.getService() == null) {
            this.a();
        }
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                new c(context).requestLocation(new IOSLocationRequestListener(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void onLocationResponse(LocationFix locationFix, String string2) {
                        try {
                            if (i.a()) {
                                if (Arrays.asList(stringArray).contains("sites_metacircle")) {
                                    Log.writeToLog(AndroidGeofencingService.this.a, "handleMetaCircleExit >> SITES_METACIRCLE_ID");
                                    NaoServiceManager.getService().getNaoContext().a.getGeofencingOSManager().onLocationResponse(locationFix, PrefHelper.get(context, "[logger]logs_app_key", null));
                                }
                                if (!Arrays.asList(stringArray).contains("pdbs_metacircle")) return;
                                Context context = context;
                                string2 = "auto_pdbs_synchro";
                                if (!PrefHelper.get(context, string2, PrefHelper.get(context, "[logger]logs_app_key", null), false)) return;
                                Log.writeToLog(AndroidGeofencingService.this.a, "handleMetaCircleExit >> PDBS_METACIRCLE_ID");
                                NaoServiceManager.getService().getNaoContext().a.getPdbsManager().onLocationResponse(locationFix, PrefHelper.get(context, "[logger]logs_app_key", null));
                                return;
                            }
                            Log.alwaysError(AndroidGeofencingService.this.a, "handleMetaCircleExit >> NAOERRORCODE.GENERIC_ERROR, Can't instantiate NaoContext");
                            return;
                        }
                        catch (Exception exception) {
                            Log.alwaysError(AndroidGeofencingService.this.a, "handleMetaCircleExit >> Exception :" + exception);
                        }
                    }
                });
            }
        };
        new Thread(runnable2).start();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }
}

