/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.api.external;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.polestar.helpers.Log;
import com.polestar.helpers.PrefHelper;
import com.polestar.helpers.e;
import com.polestar.helpers.h;
import com.polestar.helpers.i;
import com.polestar.naosdk.api.ICallback;
import com.polestar.naosdk.api.LocationFix;
import com.polestar.naosdk.api.TSENSORTYPE;
import com.polestar.naosdk.api.external.NAOException;
import com.polestar.naosdk.api.external.NAOWakeUpNotifier;
import com.polestar.naosdk.api.external.NAOWakeUpRegistrationListener;
import com.polestar.naosdk.api.external.TPOWERMODE;
import com.polestar.naosdk.controllers.a;
import com.polestar.naosdk.managers.NaoContext;
import com.polestar.naosdk.managers.NaoServiceManager;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class NAOServicesConfig {
    private static final long CONST_MAX_LOG_FILE_SIZE = 64000L;
    private static ExecutorService a = Executors.newSingleThreadExecutor();
    public static final String[] BASIC_PERMISSIONS = new String[]{"android.permission.ACCESS_FINE_LOCATION"};

    public static void setRootURL(String string2) {
        NaoContext.a = string2;
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            NaoServiceManager.getService().getNaoContext().setRootURL(string2);
        }
    }

    public static void setProxy(String string2, int n2, String string3, String string4) {
        NaoContext.a = new NaoContext.b(string2, n2, string3, string4);
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            NaoServiceManager.getService().getNaoContext().setProxy(string2, n2, string3, string4);
        }
    }

    public static String getRootURL() {
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            return NaoServiceManager.getService().getNaoContext().a.getRootURL();
        }
        return NaoContext.getRootURL();
    }

    public static TPOWERMODE getPowerMode() {
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            return NaoServiceManager.getService().getNaoContext().getPowerMode();
        }
        return TPOWERMODE.LOW;
    }

    public static String getSoftwareVersion() {
        return NaoContext.getSoftwareVersion();
    }

    public static void enableOnSiteWakeUp(@NonNull Context context, @NonNull String string2, @NonNull Class<? extends NAOWakeUpNotifier> clazz, NAOWakeUpRegistrationListener nAOWakeUpRegistrationListener) {
        PrefHelper.put(context, "[logger]wake_up_notifier", clazz.getName());
        if (Build.VERSION.SDK_INT < 26) {
            com.polestar.naosdk.controllers.b b2 = new com.polestar.naosdk.controllers.b(context);
            b2.a(nAOWakeUpRegistrationListener);
            b2.e(string2);
        } else {
            new a(context).a(string2, nAOWakeUpRegistrationListener);
        }
    }

    public static void disableOnSiteWakeUp(@NonNull Context context, @NonNull String string2, NAOWakeUpRegistrationListener nAOWakeUpRegistrationListener) {
        Context context2 = context;
        PrefHelper.put(context2, "[logger]wake_up_notifier", null);
        PrefHelper.put(context2, "inside_geofence_area", false);
        new a(context).b();
        com.polestar.naosdk.controllers.b b2 = new com.polestar.naosdk.controllers.b(context);
        b2.a(nAOWakeUpRegistrationListener);
        b2.a();
    }

    public static boolean isWakeUpNotifierRegistered(Context context) {
        return PrefHelper.get(context, "[logger]wake_up_notifier", null) != null;
    }

    public static boolean setIdentifier(Context context, final String string2, Boolean bl) throws NAOException {
        if (string2 != null && !string2.isEmpty() && bl.booleanValue()) {
            if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
                NAOServicesConfig.getNaoContextOrThrow().a.setInstanceID(string2);
                return true;
            }
            try {
                NAOServicesConfig.a(context);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (i.a()) {
                            a.execute(new Runnable(){

                                @Override
                                public void run() {
                                    NaoServiceManager.getService().getNaoContext().a.setInstanceID(string2);
                                }
                            });
                        }
                    }
                }).start();
            }
            catch (NAOException nAOException) {
                nAOException.printStackTrace();
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getNAOLog(Context var0) {
        var1_1 = v0;
        v0 = new h(var0 /* !! */ );
        var0 /* !! */  = "";
        if (e.b(v0.b()) == false) return var0 /* !! */ ;
        var2_3 = NAOServicesConfig.CONST_MAX_LOG_FILE_SIZE;
        if (new File(var1_1.b()).length() > var2_3) {
        }
        ** GOTO lbl21
        {
            catch (Throwable v1) {
                return var0 /* !! */ ;
            }
            catch (IOException var1_2) {}
            {
                var1_2.printStackTrace();
                Log.alwaysWarn("NAOServicesConfig", "error while reading naolog file. " + var1_2.getMessage());
                return var0 /* !! */ ;
            }
        }
        var4_4 = v2;
        {
            var4_4(var1_1.b());
            v3 = e.a(v2, -Math.toIntExact(var2_3), " ");
            return v3;
lbl21:
            // 1 sources

            v3 = e.b(var1_1.b());
            return v3;
        }
    }

    public static void uploadNAOLogInfo(String string2) throws NAOException {
        if (string2 == null) {
            String string3;
            string2 = string3;
            string3 = new String("");
        }
        NAOServicesConfig.getNaoContextOrThrow().a.uploadNAOLogInfo(string2);
    }

    public static void uploadNAOLogInfo(Context context, final String string2, final String string3, final ICallback iCallback) {
        if (PrefHelper.get(context.getApplicationContext(), "[logger]logs_app_key", null) == null) {
            iCallback.onFailure("NaoContext instance is not initialized");
            return;
        }
        if (string3 == null) {
            String string4;
            string3 = string4;
            string4 = new String("");
        }
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            NaoServiceManager.getService().getNaoContext().a.uploadNAOLogDirectory(string2, string3, iCallback);
        } else {
            try {
                NAOServicesConfig.a(context);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (i.a()) {
                            a.execute(new Runnable(){

                                @Override
                                public void run() {
                                    b b2 = string2.this;
                                    String string2 = b2.string2;
                                    String string3 = b2.string3;
                                    ICallback iCallback = b2.iCallback;
                                    NaoServiceManager.getService().getNaoContext().a.uploadNAOLogDirectory(string2, string3, iCallback);
                                }
                            });
                        } else {
                            iCallback.onFailure("Cannot create NaoContext");
                        }
                    }
                }).start();
            }
            catch (NAOException nAOException) {
                iCallback.onFailure("UploadNAOLogInfo failed: cannot create NaoContext instance");
                nAOException.printStackTrace();
            }
        }
    }

    public static void startLoggingMeasurements() throws NAOException {
        NAOServicesConfig.getNaoContextOrThrow().a.getMeasureLogger().startLoggingMeasurements("", true);
    }

    public static void stopLoggingMeasurements() throws NAOException {
        NAOServicesConfig.getNaoContextOrThrow().a.getMeasureLogger().stopLoggingMeasurements();
    }

    public static void setSensorBypass(String string2, boolean bl) throws NAOException {
        NAOServicesConfig.getNaoContextOrThrow().a.setSensorBypass(TSENSORTYPE.valueOf(string2), bl);
    }

    public static NaoContext getNaoContextOrThrow() throws NAOException {
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            return NaoServiceManager.getService().getNaoContext();
        }
        throw new NAOException("No NaoContext instance: you must first instantiate a service handle.");
    }

    public static Location getLastKnownLocation() {
        LocationFix locationFix;
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null && ((locationFix = NaoServiceManager.getService().getNaoContext().a.getLastKnownLocation()) != null || locationFix.getIsIndoor() || locationFix.getIsOnGraph() || locationFix.getX() != 0.0 || locationFix.getY() != 0.0 || locationFix.getZ() != 0.0 || locationFix.getTime() != 0L || locationFix.getHeading() != 0.0 || locationFix.getHrzAccuracy() != 0.0)) {
            return NAOServicesConfig.a(locationFix);
        }
        return null;
    }

    private static Location a(LocationFix locationFix) {
        Bundle bundle;
        float f2;
        double d2;
        Location location;
        Location location2 = location;
        location2("NAOSDK");
        location.setTime(locationFix.getTime());
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 17) {
            location2.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
        }
        location2.setLongitude(locationFix.getX());
        location2.setLatitude(locationFix.getY());
        location2.setAltitude(locationFix.getZ());
        float f3 = 0.0f;
        if (!locationFix.getIsIndoor()) {
            if (locationFix.getIsOnGraph() ^ true) {
                location2.removeAltitude();
                f3 = -1000.0f;
            } else {
                f3 = -500.0f;
            }
        }
        double d3 = locationFix.getHrzAccuracy();
        if (d2 > 0.0) {
            if (d3 > 1000.0) {
                d3 = (float)(d3 - 1000.0);
            }
            location2.setAccuracy((float)d3);
        }
        float f4 = (float)locationFix.getHeading();
        if (f2 >= 0.0f && f4 < 360.0f) {
            location2.setBearing(f4);
        } else if (f4 < 0.0f && f4 >= -360.0f) {
            location2.setBearing(f4 + 360.0f);
        } else if (f4 < -360.0f && f4 >= -720.0f) {
            location2.setBearing(f4 + 720.0f);
        } else if (f4 < 720.0f && f4 >= 360.0f) {
            location2.setBearing(f4 - 360.0f);
        }
        Bundle bundle2 = bundle;
        new Bundle().putFloat("heading_accuracy", f4);
        location2.setExtras(bundle2);
        if (n2 >= 26) {
            location2.setVerticalAccuracyMeters(f3);
        }
        Location location3 = location2;
        Bundle bundle3 = bundle2;
        bundle3.putFloat("vertical_accuracy", f3);
        bundle3.putString("site_code", NAOServicesConfig.getCurrentSiteId());
        location3.setExtras(bundle2);
        return location3;
    }

    public static String getCurrentSiteId() {
        if (NaoServiceManager.getService().getNaoContext() != null) {
            return NaoServiceManager.getService().getNaoContext().a.getCurrentSiteId();
        }
        return "";
    }

    private static void a(Context context) throws NAOException {
        Object object = PrefHelper.get(context, "[logger]service_name", null);
        Log.restricted("NAOServicesConfig", "createNaoServiceManager >> " + (String)object);
        if (object != null) {
            block5: {
                object = Class.forName((String)object);
                if (NaoServiceManager.getService() != null) break block5;
                try {
                    NaoServiceManager.startService(context, object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return;
        }
        throw new NAOException("NaoContext instance has not been initialized");
    }
}

