/*
 * Decompiled with CFR 0.152.
 */
package com.alanapi.navigation.behaviour;

import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.view.View;
import android.view.animation.Interpolator;
import com.alanapi.navigation.BottomNavigationBar;
import java.util.List;

public class BottomNavBarFabBehaviour
extends CoordinatorLayout.Behavior<FloatingActionButton> {
    ViewPropertyAnimatorCompat mFabTranslationYAnimator;
    static final Interpolator FAST_OUT_SLOW_IN_INTERPOLATOR = new FastOutSlowInInterpolator();

    public boolean layoutDependsOn(CoordinatorLayout parent, FloatingActionButton child, View dependency) {
        return this.isDependent(dependency) || super.layoutDependsOn(parent, (View)child, dependency);
    }

    public boolean onLayoutChild(CoordinatorLayout parent, FloatingActionButton child, int layoutDirection) {
        parent.onLayoutChild((View)child, layoutDirection);
        this.updateFabTranslationForBottomNavigationBar(parent, child, null);
        return super.onLayoutChild(parent, (View)child, layoutDirection);
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, FloatingActionButton child, View dependency) {
        if (this.isDependent(dependency)) {
            this.updateFabTranslationForBottomNavigationBar(parent, child, dependency);
            return false;
        }
        return super.onDependentViewChanged(parent, (View)child, dependency);
    }

    public void onDependentViewRemoved(CoordinatorLayout parent, FloatingActionButton child, View dependency) {
        if (this.isDependent(dependency)) {
            this.updateFabTranslationForBottomNavigationBar(parent, child, dependency);
        }
    }

    private boolean isDependent(View dependency) {
        return dependency instanceof BottomNavigationBar || dependency instanceof Snackbar.SnackbarLayout;
    }

    private void updateFabTranslationForBottomNavigationBar(CoordinatorLayout parent, FloatingActionButton fab, View dependency) {
        float snackBarTranslation = this.getFabTranslationYForSnackBar(parent, fab);
        float[] bottomBarParameters = this.getFabTranslationYForBottomNavigationBar(parent, fab);
        float bottomBarTranslation = bottomBarParameters[0];
        float bottomBarHeight = bottomBarParameters[1];
        float targetTransY = 0.0f;
        targetTransY = snackBarTranslation >= bottomBarTranslation ? bottomBarTranslation : snackBarTranslation;
        float currentTransY = ViewCompat.getTranslationY((View)fab);
        this.ensureOrCancelAnimator(fab);
        if (fab.isShown() && Math.abs(currentTransY - targetTransY) > (float)fab.getHeight() * 0.667f) {
            this.mFabTranslationYAnimator.translationY(targetTransY).start();
        } else {
            ViewCompat.setTranslationY((View)fab, (float)targetTransY);
        }
    }

    private float[] getFabTranslationYForBottomNavigationBar(CoordinatorLayout parent, FloatingActionButton fab) {
        float minOffset = 0.0f;
        float viewHeight = 0.0f;
        List dependencies = parent.getDependencies((View)fab);
        int z = dependencies.size();
        for (int i = 0; i < z; ++i) {
            View view = (View)dependencies.get(i);
            if (!(view instanceof BottomNavigationBar)) continue;
            viewHeight = view.getHeight();
            minOffset = Math.min(minOffset, ViewCompat.getTranslationY((View)view) - viewHeight);
        }
        float[] returnValues = new float[]{minOffset, viewHeight};
        return returnValues;
    }

    private float getFabTranslationYForSnackBar(CoordinatorLayout parent, FloatingActionButton fab) {
        float minOffset = 0.0f;
        List dependencies = parent.getDependencies((View)fab);
        int z = dependencies.size();
        for (int i = 0; i < z; ++i) {
            View view = (View)dependencies.get(i);
            if (!(view instanceof Snackbar.SnackbarLayout) || !parent.doViewsOverlap((View)fab, view)) continue;
            minOffset = Math.min(minOffset, ViewCompat.getTranslationY((View)view) - (float)view.getHeight());
        }
        return minOffset;
    }

    private void ensureOrCancelAnimator(FloatingActionButton fab) {
        if (this.mFabTranslationYAnimator == null) {
            this.mFabTranslationYAnimator = ViewCompat.animate((View)fab);
            this.mFabTranslationYAnimator.setDuration(400L);
            this.mFabTranslationYAnimator.setInterpolator(FAST_OUT_SLOW_IN_INTERPOLATOR);
        } else {
            this.mFabTranslationYAnimator.cancel();
        }
    }
}

