/*
 * Decompiled with CFR 0.152.
 */
package com.alanapi.navigation;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.alanapi.navigation.BadgeItem;

class BottomNavigationTab
extends FrameLayout {
    protected int paddingTopActive;
    protected int paddingTopInActive;
    protected int mPosition;
    protected int mActiveColor;
    protected int mInActiveColor;
    protected int mBackgroundColor;
    protected int mActiveWidth;
    protected int mInActiveWidth;
    protected Drawable mCompactIcon;
    protected Drawable mCompactInActiveIcon;
    protected boolean isInActiveIconSet = false;
    protected String mLabel;
    protected BadgeItem badgeItem;
    boolean isActive = false;
    View containerView;
    TextView labelView;
    ImageView iconView;
    TextView badgeView;

    public BottomNavigationTab(Context context) {
        super(context);
        this.init();
    }

    public BottomNavigationTab(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public BottomNavigationTab(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public BottomNavigationTab(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    void init() {
        this.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
    }

    public void setActiveWidth(int activeWidth) {
        this.mActiveWidth = activeWidth;
    }

    public void setInactiveWidth(int inactiveWidth) {
        this.mInActiveWidth = inactiveWidth;
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.width = this.mInActiveWidth;
        this.setLayoutParams(params);
    }

    public void setIcon(Drawable icon) {
        this.mCompactIcon = DrawableCompat.wrap((Drawable)icon);
    }

    public void setInactiveIcon(Drawable icon) {
        this.mCompactInActiveIcon = DrawableCompat.wrap((Drawable)icon);
        this.isInActiveIconSet = true;
    }

    public void setLabel(String label) {
        this.mLabel = label;
        this.labelView.setText((CharSequence)label);
    }

    public void setActiveColor(int activeColor) {
        this.mActiveColor = activeColor;
    }

    public int getActiveColor() {
        return this.mActiveColor;
    }

    public void setInactiveColor(int inActiveColor) {
        this.mInActiveColor = inActiveColor;
        this.labelView.setTextColor(inActiveColor);
    }

    public void setItemBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
    }

    public void setPosition(int position) {
        this.mPosition = position;
    }

    public void setBadgeItem(BadgeItem badgeItem) {
        this.badgeItem = badgeItem;
    }

    public int getPosition() {
        return this.mPosition;
    }

    public void select(boolean setActiveColor, int animationDuration) {
        this.isActive = true;
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.containerView.getPaddingTop(), this.paddingTopActive});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                BottomNavigationTab.this.containerView.setPadding(BottomNavigationTab.this.containerView.getPaddingLeft(), ((Integer)valueAnimator.getAnimatedValue()).intValue(), BottomNavigationTab.this.containerView.getPaddingRight(), BottomNavigationTab.this.containerView.getPaddingBottom());
            }
        });
        animator.setDuration((long)animationDuration);
        animator.start();
        this.iconView.setSelected(true);
        if (setActiveColor) {
            this.labelView.setTextColor(this.mActiveColor);
        } else {
            this.labelView.setTextColor(this.mBackgroundColor);
        }
        if (this.badgeItem != null) {
            this.badgeItem.select();
        }
    }

    public void unSelect(boolean setActiveColor, int animationDuration) {
        this.isActive = false;
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.containerView.getPaddingTop(), this.paddingTopInActive});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                BottomNavigationTab.this.containerView.setPadding(BottomNavigationTab.this.containerView.getPaddingLeft(), ((Integer)valueAnimator.getAnimatedValue()).intValue(), BottomNavigationTab.this.containerView.getPaddingRight(), BottomNavigationTab.this.containerView.getPaddingBottom());
            }
        });
        animator.setDuration((long)animationDuration);
        animator.start();
        this.labelView.setTextColor(this.mInActiveColor);
        this.iconView.setSelected(false);
        if (this.badgeItem != null) {
            this.badgeItem.unSelect();
        }
    }

    public void initialise(boolean setActiveColor) {
        this.iconView.setSelected(false);
        if (this.isInActiveIconSet) {
            StateListDrawable states = new StateListDrawable();
            states.addState(new int[]{0x10100A1}, this.mCompactIcon);
            states.addState(new int[]{-16842913}, this.mCompactInActiveIcon);
            states.addState(new int[0], this.mCompactInActiveIcon);
            this.iconView.setImageDrawable((Drawable)states);
        } else {
            if (setActiveColor) {
                DrawableCompat.setTintList((Drawable)this.mCompactIcon, (ColorStateList)new ColorStateList((int[][])new int[][]{{0x10100A1}, {-16842913}, new int[0]}, new int[]{this.mActiveColor, this.mInActiveColor, this.mInActiveColor}));
            } else {
                DrawableCompat.setTintList((Drawable)this.mCompactIcon, (ColorStateList)new ColorStateList((int[][])new int[][]{{0x10100A1}, {-16842913}, new int[0]}, new int[]{this.mBackgroundColor, this.mInActiveColor, this.mInActiveColor}));
            }
            this.iconView.setImageDrawable(this.mCompactIcon);
        }
    }
}

