/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.unparser;

import com.akiban.sql.TestBase;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.SQLParser;
import com.akiban.sql.unparser.NodeToString;
import com.akiban.sql.unparser.NodeToStringTest;
import java.io.File;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParseMultipleTest
extends TestBase
implements TestBase.GenerateAndCheckResult {
    public static final File RESOURCE_DIR = new File(NodeToStringTest.RESOURCE_DIR, "multiple");
    protected SQLParser parser;
    protected NodeToString unparser;

    @Before
    public void before() throws Exception {
        this.parser = new SQLParser();
        this.unparser = new NodeToString();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> statements() throws Exception {
        return ParseMultipleTest.sqlAndExpected(RESOURCE_DIR);
    }

    public ParseMultipleTest(String caseName, String sql, String expected, String error) {
        super(caseName, sql, expected, error);
    }

    @Test
    public void testParseMultiple() throws Exception {
        this.generateAndCheckResult();
    }

    @Override
    public String generateResult() throws Exception {
        List stmts = this.parser.parseStatements(this.sql);
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < stmts.size(); ++i) {
            if (i > 0) {
                str.append("\n");
            }
            str.append("[" + i + "]: ");
            str.append(this.unparser.toString((QueryTreeNode)stmts.get(i)));
            str.append(";");
        }
        return str.toString();
    }

    @Override
    public void checkResult(String result) {
        Assert.assertEquals((String)this.caseName, (String)this.expected, (String)result);
    }
}

