/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.TestBase;
import com.akiban.sql.parser.SQLParser;
import com.akiban.sql.parser.SQLParserFeature;
import com.akiban.sql.parser.StatementNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SQLParserTest
extends TestBase
implements TestBase.GenerateAndCheckResult {
    public static final File RESOURCE_DIR = new File("src/test/resources/" + SQLParserTest.class.getPackage().getName().replace('.', '/'));
    protected SQLParser parser;
    protected File featuresFile;

    @Before
    public void before() throws Exception {
        this.parser = new SQLParser();
        if (this.featuresFile != null) {
            this.parseFeatures(this.featuresFile, this.parser.getFeatures());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFeatures(File file, Set<SQLParserFeature> features) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                boolean add;
                switch (line.charAt(0)) {
                    case '+': {
                        add = true;
                        break;
                    }
                    case '-': {
                        add = false;
                        break;
                    }
                    default: {
                        throw new IOException("Malformed features line: should start with + or - " + line);
                    }
                }
                SQLParserFeature feature = SQLParserFeature.valueOf((String)line.substring(1));
                if (add) {
                    features.add(feature);
                    continue;
                }
                features.remove(feature);
            }
        }
        finally {
            reader.close();
        }
    }

    protected String getTree(StatementNode stmt) throws IOException {
        StringWriter str = new StringWriter();
        stmt.treePrint((Writer)str);
        return str.toString().trim();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> queries() throws Exception {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Object[] args : SQLParserTest.sqlAndExpected(RESOURCE_DIR)) {
            File featuresFile = new File(RESOURCE_DIR, args[0] + ".features");
            if (!featuresFile.exists()) {
                featuresFile = null;
            }
            Object[] nargs = new Object[args.length + 1];
            nargs[0] = args[0];
            nargs[1] = featuresFile;
            System.arraycopy(args, 1, nargs, 2, args.length - 1);
            result.add(nargs);
        }
        return result;
    }

    public SQLParserTest(String caseName, File featuresFile, String sql, String expected, String error) {
        super(caseName, sql, expected, error);
        this.featuresFile = featuresFile;
    }

    @Test
    public void testParser() throws Exception {
        this.generateAndCheckResult();
    }

    @Override
    public String generateResult() throws Exception {
        StatementNode stmt = this.parser.parseStatement(this.sql);
        return this.getTree(stmt);
    }

    @Override
    public void checkResult(String result) throws IOException {
        SQLParserTest.assertEqualsWithoutHashes(this.caseName, this.expected, result);
    }
}

