/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.TestBase;
import com.akiban.sql.compiler.ASTTransformTestBase;
import com.akiban.sql.compiler.BooleanNormalizer;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.SQLParserContext;
import com.akiban.sql.parser.StatementNode;
import java.io.File;
import java.util.Collection;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BooleanNormalizerTest
extends ASTTransformTestBase
implements TestBase.GenerateAndCheckResult {
    public static final File RESOURCE_DIR = new File(ASTTransformTestBase.RESOURCE_DIR, "normalize");
    protected BooleanNormalizer booleanNormalizer;

    @Before
    public void makeNormalizer() throws Exception {
        this.booleanNormalizer = new BooleanNormalizer((SQLParserContext)this.parser);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> statements() throws Exception {
        return BooleanNormalizerTest.sqlAndExpected(RESOURCE_DIR);
    }

    public BooleanNormalizerTest(String caseName, String sql, String expected, String error) {
        super(caseName, sql, expected, error);
    }

    @Test
    public void testNormalizer() throws Exception {
        this.generateAndCheckResult();
    }

    @Override
    public String generateResult() throws Exception {
        StatementNode stmt = this.parser.parseStatement(this.sql);
        stmt = this.booleanNormalizer.normalize(stmt);
        return this.unparser.toString((QueryTreeNode)stmt);
    }

    @Override
    public void checkResult(String result) {
        Assert.assertEquals((String)this.caseName, (String)this.expected, (String)result);
    }
}

