/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql;

import com.akiban.sql.CompareWithoutHashes;
import com.akiban.sql.RegexFilenameFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import junit.framework.Assert;
import org.junit.ComparisonFailure;
import org.junit.Ignore;

@Ignore
public class TestBase {
    protected String caseName;
    protected String sql;
    protected String expected;
    protected String error;
    static final boolean RUN_FAILING_TESTS = Boolean.getBoolean("akiban.sql.test.runFailing");

    protected TestBase() {
    }

    protected TestBase(String caseName, String sql, String expected, String error) {
        this.caseName = caseName;
        this.sql = sql;
        this.expected = expected;
        this.error = error;
    }

    public static File[] listSQLFiles(File dir) {
        File[] result = dir.listFiles(new RegexFilenameFilter(".*\\.sql"));
        Arrays.sort(result, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        return result;
    }

    public static File changeSuffix(File sqlFile, String suffix) {
        return new File(sqlFile.getParentFile(), sqlFile.getName().replace(".sql", suffix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileContents(File file) throws IOException {
        FileReader reader = null;
        try {
            int nc;
            reader = new FileReader(file);
            StringBuilder str = new StringBuilder();
            char[] buf = new char[128];
            while ((nc = reader.read(buf)) >= 0) {
                str.append(buf, 0, nc);
            }
            String string = str.toString();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] fileContentsArray(File file) throws IOException {
        FileReader reader = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            reader = new FileReader(file);
            BufferedReader buffered = new BufferedReader(reader);
            while ((line = buffered.readLine()) != null) {
                result.add(line);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static Collection<Object[]> sqlAndExpected(File dir) throws IOException {
        return TestBase.sqlAndExpected(dir, false);
    }

    public static Collection<Object[]> sqlAndExpectedAndParams(File dir) throws IOException {
        return TestBase.sqlAndExpected(dir, true);
    }

    public static Collection<Object[]> sqlAndExpected(File dir, boolean andParams) throws IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (File sqlFile : TestBase.listSQLFiles(dir)) {
            String caseName = sqlFile.getName().replace(".sql", "");
            if (TestBase.changeSuffix(sqlFile, ".fail").exists() && !RUN_FAILING_TESTS) continue;
            String sql = TestBase.fileContents(sqlFile);
            File expectedFile = TestBase.changeSuffix(sqlFile, ".expected");
            String expected = expectedFile.exists() ? TestBase.fileContents(expectedFile) : null;
            File errorFile = TestBase.changeSuffix(sqlFile, ".error");
            String error = errorFile.exists() ? TestBase.fileContents(errorFile) : null;
            if (andParams) {
                String[] params = null;
                File paramsFile = TestBase.changeSuffix(sqlFile, ".params");
                if (paramsFile.exists()) {
                    params = TestBase.fileContentsArray(paramsFile);
                }
                result.add(new Object[]{caseName, sql, expected, error, params});
                continue;
            }
            result.add(new Object[]{caseName, sql, expected, error});
        }
        return result;
    }

    public static void generateAndCheckResult(GenerateAndCheckResult handler, String caseName, String expected, String error) throws Exception {
        if (expected != null && error != null) {
            Assert.fail((String)(caseName + ": both expected result and expected error specified."));
        }
        String result = null;
        Exception errorResult = null;
        try {
            result = handler.generateResult();
        }
        catch (Exception ex) {
            errorResult = ex;
        }
        if (error != null) {
            if (errorResult == null) {
                Assert.fail((String)(caseName + ": error expected but none thrown"));
            } else {
                Assert.assertEquals((String)caseName, (String)error, (String)errorResult.toString());
            }
        } else {
            if (errorResult != null) {
                throw errorResult;
            }
            if (expected == null) {
                Assert.fail((String)(caseName + " no expected result given. actual='" + result + "'"));
            } else {
                handler.checkResult(result);
            }
        }
    }

    protected void generateAndCheckResult() throws Exception {
        TestBase.generateAndCheckResult((GenerateAndCheckResult)((Object)this), this.caseName, this.expected, this.error);
    }

    public static void assertEqualsWithoutHashes(String caseName, String expected, String actual) throws IOException {
        TestBase.assertEqualsWithoutPattern(caseName, expected, actual, "[\\p{Alnum}]*\\@[\\p{XDigit}]+");
    }

    public static void assertEqualsWithoutPattern(String caseName, String expected, String actual, String regex) throws IOException {
        CompareWithoutHashes comparer = new CompareWithoutHashes(regex);
        if (!comparer.match(new StringReader(expected), new StringReader(actual))) {
            throw new ComparisonFailure(caseName, comparer.converter(expected, actual), actual);
        }
    }

    public static interface GenerateAndCheckResult {
        public String generateResult() throws Exception;

        public void checkResult(String var1) throws IOException;
    }
}

