/*
 * Decompiled with CFR 0.152.
 */
package com.akhgupta.easylocation;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.location.LocationManager;
import android.os.Parcelable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import com.akhgupta.easylocation.EasyLocationListener;
import com.akhgupta.easylocation.EasyLocationRequest;
import com.akhgupta.easylocation.LocationBgService;
import com.akhgupta.easylocation.LocationBroadcastReceiver;
import com.akhgupta.easylocation.PreferenceUtil;
import com.akhgupta.easylocation.R;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.location.LocationRequest;

class EasyLocationDelegate {
    private static final int PERMISSIONS_REQUEST = 100;
    private static final int ENABLE_LOCATION_SERVICES_REQUEST = 101;
    private static final int GOOGLE_PLAY_SERVICES_ERROR_DIALOG = 102;
    private final Activity activity;
    private final EasyLocationListener easyLocationListener;
    private final LocationBroadcastReceiver locationReceiver;
    private LocationManager mLocationManager;
    private int mLocationFetchMode;
    private LocationRequest mLocationRequest;
    private GoogleApiAvailability googleApiAvailability;
    private EasyLocationRequest easyLocationRequest;

    EasyLocationDelegate(Activity activity, EasyLocationListener easyLocationListener) {
        this.activity = activity;
        this.easyLocationListener = easyLocationListener;
        this.locationReceiver = new LocationBroadcastReceiver(easyLocationListener);
    }

    private boolean isLocationEnabled() {
        return this.isGPSLocationEnabled() || this.isNetworkLocationEnabled();
    }

    private boolean isGPSLocationEnabled() {
        return this.mLocationManager.isProviderEnabled("gps");
    }

    private boolean isNetworkLocationEnabled() {
        return this.mLocationManager.isProviderEnabled("network");
    }

    private void openLocationSettings() {
        Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
        this.activity.startActivityForResult(intent, 101);
    }

    private void stopLocationUpdates() {
        Intent intent = new Intent((Context)this.activity, LocationBgService.class);
        intent.setAction("location.fetch.stop");
        this.activity.startService(intent);
    }

    private void isProperRequest(EasyLocationRequest easyLocationRequest) {
        if (easyLocationRequest == null) {
            throw new IllegalStateException("easyLocationRequest can't be null");
        }
        if (easyLocationRequest.locationRequest == null) {
            throw new IllegalStateException("locationRequest can't be null");
        }
        this.easyLocationRequest = easyLocationRequest;
    }

    private void startLocationBGService(LocationRequest locationRequest) {
        if (!this.isLocationEnabled()) {
            this.showLocationServicesRequireDialog();
        } else {
            Intent intent = new Intent((Context)this.activity, LocationBgService.class);
            intent.setAction("location.fetch.start");
            intent.putExtra("location_request", (Parcelable)locationRequest);
            intent.putExtra("location_fetch_mode", this.mLocationFetchMode);
            this.activity.startService(intent);
        }
    }

    private boolean hasLocationPermission() {
        return ContextCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    private void showPermissionRequireDialog() {
        String title = TextUtils.isEmpty((CharSequence)this.easyLocationRequest.locationPermissionDialogTitle) ? this.activity.getString(R.string.location_permission_dialog_title) : this.easyLocationRequest.locationPermissionDialogTitle;
        String message = TextUtils.isEmpty((CharSequence)this.easyLocationRequest.locationPermissionDialogMessage) ? this.activity.getString(R.string.location_permission_dialog_message) : this.easyLocationRequest.locationPermissionDialogMessage;
        String negativeButtonTitle = TextUtils.isEmpty((CharSequence)this.easyLocationRequest.locationPermissionDialogNegativeButtonText) ? this.activity.getString(0x1040000) : this.easyLocationRequest.locationPermissionDialogNegativeButtonText;
        String positiveButtonTitle = TextUtils.isEmpty((CharSequence)this.easyLocationRequest.locationPermissionDialogPositiveButtonText) ? this.activity.getString(17039370) : this.easyLocationRequest.locationPermissionDialogPositiveButtonText;
        new AlertDialog.Builder((Context)this.activity).setCancelable(true).setTitle((CharSequence)title).setMessage((CharSequence)message).setNegativeButton((CharSequence)negativeButtonTitle, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                EasyLocationDelegate.this.easyLocationListener.onLocationPermissionDenied();
            }
        }).setPositiveButton((CharSequence)positiveButtonTitle, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                EasyLocationDelegate.this.requestPermission();
            }
        }).create().show();
    }

    private void showLocationServicesRequireDialog() {
        String title = TextUtils.isEmpty((CharSequence)this.easyLocationRequest.locationSettingsDialogTitle) ? this.activity.getString(R.string.location_services_off) : this.easyLocationRequest.locationSettingsDialogTitle;
        String message = TextUtils.isEmpty((CharSequence)this.easyLocationRequest.locationSettingsDialogMessage) ? this.activity.getString(R.string.open_location_settings) : this.easyLocationRequest.locationSettingsDialogMessage;
        String negativeButtonText = TextUtils.isEmpty((CharSequence)this.easyLocationRequest.locationSettingsDialogNegativeButtonText) ? this.activity.getString(0x1040000) : this.easyLocationRequest.locationSettingsDialogNegativeButtonText;
        String positiveButtonText = TextUtils.isEmpty((CharSequence)this.easyLocationRequest.locationSettingsDialogPositiveButtonText) ? this.activity.getString(17039370) : this.easyLocationRequest.locationSettingsDialogPositiveButtonText;
        new AlertDialog.Builder((Context)this.activity).setCancelable(true).setTitle((CharSequence)title).setMessage((CharSequence)message).setNegativeButton((CharSequence)negativeButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                EasyLocationDelegate.this.easyLocationListener.onLocationProviderDisabled();
            }
        }).setPositiveButton((CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                EasyLocationDelegate.this.openLocationSettings();
            }
        }).create().show();
    }

    private void requestPermission() {
        ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)100);
    }

    private void requestLocation(LocationRequest locationRequest, int locationMode) {
        if (this.isGoogleServiceAvailable()) {
            this.mLocationFetchMode = locationMode;
            this.mLocationRequest = locationRequest;
            this.checkForPermissionAndRequestLocation(locationRequest);
        } else {
            this.showGooglePlayServicesErrorDialog();
        }
    }

    private void checkForPermissionAndRequestLocation(LocationRequest locationRequest) {
        if (!this.hasLocationPermission()) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION")) {
                this.showPermissionRequireDialog();
            } else {
                this.requestPermission();
            }
        } else {
            this.startLocationBGService(locationRequest);
        }
    }

    private void unregisterLocationBroadcastReceiver() {
        LocalBroadcastManager.getInstance((Context)this.activity).unregisterReceiver((BroadcastReceiver)this.locationReceiver);
    }

    private void registerLocationBroadcastReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("intent.location.received");
        LocalBroadcastManager.getInstance((Context)this.activity).registerReceiver((BroadcastReceiver)this.locationReceiver, intentFilter);
    }

    private boolean isGoogleServiceAvailable() {
        return this.googleApiAvailability.isGooglePlayServicesAvailable((Context)this.activity) == 0;
    }

    private void showGooglePlayServicesErrorDialog() {
        int errorCode = this.googleApiAvailability.isGooglePlayServicesAvailable((Context)this.activity);
        if (this.googleApiAvailability.isUserResolvableError(errorCode)) {
            this.googleApiAvailability.getErrorDialog(this.activity, errorCode, 102).show();
        }
    }

    void onCreate() {
        this.mLocationManager = (LocationManager)this.activity.getSystemService("location");
        this.googleApiAvailability = GoogleApiAvailability.getInstance();
        this.registerLocationBroadcastReceiver();
    }

    void onActivityResult(int requestCode) {
        switch (requestCode) {
            case 101: {
                if (this.isLocationEnabled()) {
                    this.requestLocation(this.mLocationRequest, this.mLocationFetchMode);
                    this.easyLocationListener.onLocationProviderEnabled();
                    break;
                }
                this.easyLocationListener.onLocationProviderDisabled();
            }
        }
    }

    void onRequestPermissionsResult(int requestCode, int[] grantResults) {
        switch (requestCode) {
            case 100: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.requestLocation(this.mLocationRequest, this.mLocationFetchMode);
                    this.easyLocationListener.onLocationPermissionGranted();
                    break;
                }
                this.easyLocationListener.onLocationPermissionDenied();
            }
        }
    }

    void onDestroy() {
        this.stopLocationUpdates();
        this.unregisterLocationBroadcastReceiver();
    }

    Location getLastKnownLocation() {
        return PreferenceUtil.getInstance((Context)this.activity).getLastKnownLocation();
    }

    void requestLocationUpdates(EasyLocationRequest easyLocationRequest) {
        this.isProperRequest(easyLocationRequest);
        this.requestLocation(easyLocationRequest.locationRequest, 2);
    }

    void requestSingleLocationFix(EasyLocationRequest easyLocationRequest) {
        this.isProperRequest(easyLocationRequest);
        this.requestLocation(easyLocationRequest.locationRequest, 1);
    }
}

