/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.roundcornerprogressbar.common;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.customview.view.AbsSavedState;
import com.akexorcist.roundcornerprogressbar.R;
import com.akexorcist.roundcornerprogressbar.common.BaseRoundCornerProgressBar;

public abstract class AnimatedRoundCornerProgressBar
extends BaseRoundCornerProgressBar {
    public static final long DEFAULT_DURATION = 500L;
    private boolean isProgressAnimating = false;
    private boolean isSecondaryProgressAnimating = false;
    private float lastProgress;
    private float lastSecondaryProgress;
    private float animationSpeedScale;
    private boolean isAnimationEnabled;
    private ValueAnimator progressAnimator;
    private ValueAnimator secondaryProgressAnimator;
    private ValueAnimator.AnimatorUpdateListener progressAnimationUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            AnimatedRoundCornerProgressBar.this.onUpdateProgressByAnimation(((Float)animation.getAnimatedValue()).floatValue());
        }
    };
    private AnimatorListenerAdapter progressAnimationAdapterListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            AnimatedRoundCornerProgressBar.this.isProgressAnimating = false;
            AnimatedRoundCornerProgressBar.this.onProgressAnimationEnd();
        }

        public void onAnimationCancel(Animator animation) {
            AnimatedRoundCornerProgressBar.this.isProgressAnimating = false;
        }
    };
    private ValueAnimator.AnimatorUpdateListener secondaryProgressAnimationUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            AnimatedRoundCornerProgressBar.this.onUpdateSecondaryProgressByAnimation(((Float)animation.getAnimatedValue()).floatValue());
        }
    };
    private AnimatorListenerAdapter secondaryProgressAnimationAdapterListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            AnimatedRoundCornerProgressBar.this.isSecondaryProgressAnimating = false;
            AnimatedRoundCornerProgressBar.this.onSecondaryProgressAnimationEnd();
        }

        public void onAnimationCancel(Animator animation) {
            AnimatedRoundCornerProgressBar.this.isSecondaryProgressAnimating = false;
        }
    };

    public AnimatedRoundCornerProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AnimatedRoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(value=21)
    public AnimatedRoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public void setupStyleable(@NonNull Context context, @NonNull AttributeSet attrs) {
        super.setupStyleable(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AnimatedRoundCornerProgressBar);
        this.isAnimationEnabled = typedArray.getBoolean(R.styleable.AnimatedRoundCornerProgressBar_rcAnimationEnable, false);
        this.animationSpeedScale = typedArray.getFloat(R.styleable.AnimatedRoundCornerProgressBar_rcAnimationSpeedScale, 1.0f);
        typedArray.recycle();
        this.lastProgress = super.getProgress();
        this.lastSecondaryProgress = super.getSecondaryProgress();
    }

    @Override
    public float getProgress() {
        if (!this.isAnimationEnabled && !this.isProgressAnimating) {
            return super.getProgress();
        }
        return this.lastProgress;
    }

    @Override
    public void setProgress(int progress) {
        this.setProgress((float)progress);
    }

    @Override
    public void setProgress(float progress) {
        progress = progress < 0.0f ? 0.0f : Math.min(progress, this.max);
        this.clearProgressAnimation();
        this.lastProgress = progress;
        if (this.isAnimationEnabled) {
            this.startProgressAnimation(super.getProgress(), progress);
        } else {
            super.setProgress(progress);
        }
    }

    @Override
    public float getSecondaryProgress() {
        if (!this.isAnimationEnabled && !this.isSecondaryProgressAnimating) {
            return super.getSecondaryProgress();
        }
        return this.lastSecondaryProgress;
    }

    @Override
    public void setSecondaryProgress(int progress) {
        this.setSecondaryProgress((float)progress);
    }

    @Override
    public void setSecondaryProgress(float progress) {
        progress = progress < 0.0f ? 0.0f : Math.min(progress, this.max);
        this.clearSecondaryProgressAnimation();
        this.lastSecondaryProgress = progress;
        if (this.isAnimationEnabled) {
            this.startSecondaryProgressAnimation(super.getSecondaryProgress(), progress);
        } else {
            super.setSecondaryProgress(progress);
        }
    }

    @FloatRange(from=0.20000000298023224, to=5.0)
    public float getAnimationSpeedScale() {
        return this.animationSpeedScale;
    }

    public void enableAnimation() {
        this.isAnimationEnabled = true;
    }

    public void disableAnimation() {
        this.isAnimationEnabled = false;
    }

    public void setAnimationSpeedScale(@FloatRange(from=0.20000000298023224, to=5.0) float scale) {
        scale = Math.min(scale, 5.0f);
        this.animationSpeedScale = scale = Math.max(scale, 0.2f);
    }

    public boolean isProgressAnimating() {
        return this.isProgressAnimating;
    }

    public boolean isSecondaryProgressAnimating() {
        return this.isSecondaryProgressAnimating;
    }

    protected void onProgressChangeAnimationUpdate(LinearLayout layout2, float current, float to) {
    }

    protected void onProgressChangeAnimationEnd(LinearLayout layout2) {
    }

    protected void stopProgressAnimationImmediately() {
        this.clearProgressAnimation();
        this.clearSecondaryProgressAnimation();
        if (this.isAnimationEnabled && this.isProgressAnimating) {
            this.disableAnimation();
            if (this.isProgressAnimating) {
                super.setProgress(this.lastProgress);
            }
            if (this.isSecondaryProgressAnimating) {
                super.setSecondaryProgress(this.lastProgress);
            }
            this.enableAnimation();
        }
    }

    private long getAnimationDuration(float from, float to, float max, float scale) {
        float diff = Math.abs(from - to);
        return (long)(diff * 500.0f / max * scale);
    }

    private void startProgressAnimation(float from, float to) {
        this.isProgressAnimating = true;
        if (this.progressAnimator != null) {
            this.progressAnimator.removeUpdateListener(this.progressAnimationUpdateListener);
            this.progressAnimator.removeListener((Animator.AnimatorListener)this.progressAnimationAdapterListener);
            this.progressAnimator.cancel();
            this.progressAnimator = null;
        }
        this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        this.progressAnimator.setDuration(this.getAnimationDuration(from, to, this.max, this.animationSpeedScale));
        this.progressAnimator.addUpdateListener(this.progressAnimationUpdateListener);
        this.progressAnimator.addListener((Animator.AnimatorListener)this.progressAnimationAdapterListener);
        this.progressAnimator.start();
    }

    private void onUpdateProgressByAnimation(float progress) {
        super.setProgress(progress);
        this.onProgressChangeAnimationUpdate(this.layoutProgress, progress, this.lastProgress);
    }

    private void onProgressAnimationEnd() {
        this.onProgressChangeAnimationEnd(this.layoutProgress);
    }

    private void restoreProgressAnimationState() {
        if (this.isProgressAnimating) {
            this.startProgressAnimation(super.getProgress(), this.lastProgress);
        }
    }

    private void clearProgressAnimation() {
        if (this.progressAnimator != null && this.progressAnimator.isRunning()) {
            this.progressAnimator.cancel();
        }
    }

    private void startSecondaryProgressAnimation(float from, float to) {
        this.isSecondaryProgressAnimating = true;
        if (this.secondaryProgressAnimator != null) {
            this.secondaryProgressAnimator.removeUpdateListener(this.secondaryProgressAnimationUpdateListener);
            this.secondaryProgressAnimator.removeListener((Animator.AnimatorListener)this.secondaryProgressAnimationAdapterListener);
            this.secondaryProgressAnimator.cancel();
            this.secondaryProgressAnimator = null;
        }
        this.secondaryProgressAnimator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        this.secondaryProgressAnimator.setDuration(this.getAnimationDuration(from, to, this.max, this.animationSpeedScale));
        this.secondaryProgressAnimator.addUpdateListener(this.secondaryProgressAnimationUpdateListener);
        this.secondaryProgressAnimator.addListener((Animator.AnimatorListener)this.secondaryProgressAnimationAdapterListener);
        this.secondaryProgressAnimator.start();
    }

    private void onUpdateSecondaryProgressByAnimation(float progress) {
        super.setSecondaryProgress(progress);
        this.onProgressChangeAnimationUpdate(this.layoutSecondaryProgress, progress, this.lastProgress);
    }

    private void onSecondaryProgressAnimationEnd() {
        this.onProgressChangeAnimationEnd(this.layoutSecondaryProgress);
    }

    private void restoreSecondaryProgressAnimationState() {
        if (this.isSecondaryProgressAnimating) {
            this.startSecondaryProgressAnimation(super.getSecondaryProgress(), this.lastSecondaryProgress);
        }
    }

    private void clearSecondaryProgressAnimation() {
        if (this.secondaryProgressAnimator != null && this.secondaryProgressAnimator.isRunning()) {
            this.secondaryProgressAnimator.cancel();
        }
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.isProgressAnimating = this.isProgressAnimating;
        ss.isSecondaryProgressAnimating = this.isSecondaryProgressAnimating;
        ss.lastProgress = this.lastProgress;
        ss.lastSecondaryProgress = this.lastSecondaryProgress;
        ss.animationSpeedScale = this.animationSpeedScale;
        ss.isAnimationEnabled = this.isAnimationEnabled;
        return ss;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.isProgressAnimating = ss.isProgressAnimating;
        this.isSecondaryProgressAnimating = ss.isSecondaryProgressAnimating;
        this.lastProgress = ss.lastProgress;
        this.lastSecondaryProgress = ss.lastSecondaryProgress;
        this.animationSpeedScale = ss.animationSpeedScale;
        this.isAnimationEnabled = ss.isAnimationEnabled;
        this.restoreProgressAnimationState();
        this.restoreSecondaryProgressAnimationState();
    }

    protected static class SavedState
    extends AbsSavedState {
        boolean isProgressAnimating;
        boolean isSecondaryProgressAnimating;
        float lastProgress;
        float lastSecondaryProgress;
        float animationSpeedScale;
        boolean isAnimationEnabled;
        public static final Parcelable.ClassLoaderCreator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(Parcel in) {
            this(in, null);
        }

        SavedState(Parcel in, ClassLoader loader) {
            super(in, loader);
            this.isProgressAnimating = in.readByte() != 0;
            this.isSecondaryProgressAnimating = in.readByte() != 0;
            this.lastProgress = in.readFloat();
            this.lastSecondaryProgress = in.readFloat();
            this.animationSpeedScale = in.readFloat();
            this.isAnimationEnabled = in.readByte() != 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeByte((byte)(this.isProgressAnimating ? 1 : 0));
            out.writeByte((byte)(this.isSecondaryProgressAnimating ? 1 : 0));
            out.writeFloat(this.lastProgress);
            out.writeFloat(this.lastSecondaryProgress);
            out.writeFloat(this.animationSpeedScale);
            out.writeByte((byte)(this.isAnimationEnabled ? 1 : 0));
        }
    }
}

