/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.roundcornerprogressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.customview.view.AbsSavedState;
import com.akexorcist.roundcornerprogressbar.R;
import com.akexorcist.roundcornerprogressbar.common.AnimatedRoundCornerProgressBar;

@Keep
public class IconRoundCornerProgressBar
extends AnimatedRoundCornerProgressBar {
    protected static final int DEFAULT_ICON_SIZE = 20;
    protected static final int DEFAULT_ICON_PADDING_LEFT = 0;
    protected static final int DEFAULT_ICON_PADDING_RIGHT = 0;
    protected static final int DEFAULT_ICON_PADDING_TOP = 0;
    protected static final int DEFAULT_ICON_PADDING_BOTTOM = 0;
    private ImageView ivProgressIcon;
    private int iconResource;
    private int iconSize;
    private int iconWidth;
    private int iconHeight;
    private int iconPadding;
    private int iconPaddingLeft;
    private int iconPaddingRight;
    private int iconPaddingTop;
    private int iconPaddingBottom;
    private int colorIconBackground;
    private Bitmap iconBitmap;
    private Drawable iconDrawable;
    private OnIconClickListener iconClickListener;

    public IconRoundCornerProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public IconRoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(value=21)
    public IconRoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public int initLayout() {
        return R.layout.layout_icon_round_corner_progress_bar;
    }

    @Override
    protected void initStyleable(@NonNull Context context, @NonNull AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.IconRoundCornerProgressBar);
        this.iconResource = typedArray.getResourceId(R.styleable.IconRoundCornerProgressBar_rcIconSrc, -1);
        this.iconSize = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgressBar_rcIconSize, -1.0f);
        this.iconWidth = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgressBar_rcIconWidth, this.dp2px(20.0f));
        this.iconHeight = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgressBar_rcIconHeight, this.dp2px(20.0f));
        this.iconPadding = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgressBar_rcIconPadding, -1.0f);
        this.iconPaddingLeft = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgressBar_rcIconPaddingLeft, this.dp2px(0.0f));
        this.iconPaddingRight = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgressBar_rcIconPaddingRight, this.dp2px(0.0f));
        this.iconPaddingTop = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgressBar_rcIconPaddingTop, this.dp2px(0.0f));
        this.iconPaddingBottom = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgressBar_rcIconPaddingBottom, this.dp2px(0.0f));
        int defaultIconBackgroundColor = context.getResources().getColor(R.color.round_corner_progress_bar_background_default);
        this.colorIconBackground = typedArray.getColor(R.styleable.IconRoundCornerProgressBar_rcIconBackgroundColor, defaultIconBackgroundColor);
        typedArray.recycle();
    }

    @Override
    protected void initView() {
        this.ivProgressIcon = (ImageView)this.findViewById(R.id.iv_progress_icon);
        this.ivProgressIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (IconRoundCornerProgressBar.this.iconClickListener != null) {
                    IconRoundCornerProgressBar.this.iconClickListener.onIconClick();
                }
            }
        });
    }

    public void setOnIconClickListener(@Nullable OnIconClickListener listener) {
        this.iconClickListener = listener;
    }

    @Override
    protected void drawProgress(@NonNull LinearLayout layoutProgress, @NonNull GradientDrawable progressDrawable, float max, float progress, float totalWidth, int radius, int padding, boolean isReverse) {
        int newRadius = radius - padding / 2;
        if (isReverse && progress != max) {
            progressDrawable.setCornerRadii(new float[]{newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius});
        } else {
            progressDrawable.setCornerRadii(new float[]{0.0f, 0.0f, newRadius, newRadius, newRadius, newRadius, 0.0f, 0.0f});
        }
        layoutProgress.setBackground((Drawable)progressDrawable);
        float ratio = max / progress;
        int progressWidth = (int)((totalWidth - (float)(padding * 2 + this.ivProgressIcon.getWidth())) / ratio);
        ViewGroup.MarginLayoutParams progressParams = (ViewGroup.MarginLayoutParams)layoutProgress.getLayoutParams();
        if (isReverse) {
            if (padding + progressWidth / 2 < radius) {
                int margin;
                progressParams.topMargin = margin = Math.max(radius - padding, 0) - progressWidth / 2;
                progressParams.bottomMargin = margin;
            } else {
                progressParams.topMargin = 0;
                progressParams.bottomMargin = 0;
            }
        }
        progressParams.width = progressWidth;
        layoutProgress.setLayoutParams((ViewGroup.LayoutParams)progressParams);
    }

    @Override
    protected void onViewDraw() {
        this.drawImageIcon();
        this.drawImageIconSize();
        this.drawImageIconPadding();
        this.drawIconBackgroundColor();
    }

    private void drawImageIcon() {
        if (this.iconResource != -1) {
            this.ivProgressIcon.setImageResource(this.iconResource);
        } else if (this.iconBitmap != null) {
            this.ivProgressIcon.setImageBitmap(this.iconBitmap);
        } else if (this.iconDrawable != null) {
            this.ivProgressIcon.setImageDrawable(this.iconDrawable);
        }
    }

    private void drawImageIconSize() {
        if (this.iconSize == -1) {
            this.ivProgressIcon.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.iconWidth, this.iconHeight));
        } else {
            this.ivProgressIcon.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.iconSize, this.iconSize));
        }
    }

    private void drawImageIconPadding() {
        if (this.iconPadding == -1 || this.iconPadding == 0) {
            this.ivProgressIcon.setPadding(this.iconPaddingLeft, this.iconPaddingTop, this.iconPaddingRight, this.iconPaddingBottom);
        } else {
            this.ivProgressIcon.setPadding(this.iconPadding, this.iconPadding, this.iconPadding, this.iconPadding);
        }
        this.ivProgressIcon.invalidate();
    }

    private void drawIconBackgroundColor() {
        GradientDrawable iconBackgroundDrawable = this.createGradientDrawable(this.colorIconBackground);
        int radius = this.getRadius() - this.getPadding() / 2;
        iconBackgroundDrawable.setCornerRadii(new float[]{radius, radius, 0.0f, 0.0f, 0.0f, 0.0f, radius, radius});
        this.ivProgressIcon.setBackground((Drawable)iconBackgroundDrawable);
    }

    public int getIconImageResource() {
        return this.iconResource;
    }

    public void setIconImageResource(int resId) {
        this.iconResource = resId;
        this.iconBitmap = null;
        this.iconDrawable = null;
        this.drawImageIcon();
    }

    public Bitmap getIconImageBitmap() {
        return this.iconBitmap;
    }

    public void setIconImageBitmap(Bitmap bitmap) {
        this.iconResource = -1;
        this.iconBitmap = bitmap;
        this.iconDrawable = null;
        this.drawImageIcon();
    }

    public Drawable getIconImageDrawable() {
        return this.iconDrawable;
    }

    public void setIconImageDrawable(Drawable drawable) {
        this.iconResource = -1;
        this.iconBitmap = null;
        this.iconDrawable = drawable;
        this.drawImageIcon();
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int size) {
        if (size >= 0) {
            this.iconSize = size;
        }
        this.drawImageIconSize();
    }

    public int getIconPadding() {
        return this.iconPadding;
    }

    public void setIconPadding(int padding) {
        if (padding >= 0) {
            this.iconPadding = padding;
        }
        this.drawImageIconPadding();
    }

    public int getIconPaddingLeft() {
        return this.iconPaddingLeft;
    }

    public void setIconPaddingLeft(int padding) {
        if (padding > 0) {
            this.iconPaddingLeft = padding;
        }
        this.drawImageIconPadding();
    }

    public int getIconPaddingRight() {
        return this.iconPaddingRight;
    }

    public void setIconPaddingRight(int padding) {
        if (padding > 0) {
            this.iconPaddingRight = padding;
        }
        this.drawImageIconPadding();
    }

    public int getIconPaddingTop() {
        return this.iconPaddingTop;
    }

    public void setIconPaddingTop(int padding) {
        if (padding > 0) {
            this.iconPaddingTop = padding;
        }
        this.drawImageIconPadding();
    }

    public int getIconPaddingBottom() {
        return this.iconPaddingBottom;
    }

    public void setIconPaddingBottom(int padding) {
        if (padding > 0) {
            this.iconPaddingBottom = padding;
        }
        this.drawImageIconPadding();
    }

    public int getColorIconBackground() {
        return this.colorIconBackground;
    }

    public void setIconBackgroundColor(int color2) {
        this.colorIconBackground = color2;
        this.drawIconBackgroundColor();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.iconResource = this.iconResource;
        ss.iconSize = this.iconSize;
        ss.iconWidth = this.iconWidth;
        ss.iconHeight = this.iconHeight;
        ss.iconPadding = this.iconPadding;
        ss.iconPaddingLeft = this.iconPaddingLeft;
        ss.iconPaddingRight = this.iconPaddingRight;
        ss.iconPaddingTop = this.iconPaddingTop;
        ss.iconPaddingBottom = this.iconPaddingBottom;
        ss.colorIconBackground = this.colorIconBackground;
        return ss;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.iconResource = ss.iconResource;
        this.iconSize = ss.iconSize;
        this.iconWidth = ss.iconWidth;
        this.iconHeight = ss.iconHeight;
        this.iconPadding = ss.iconPadding;
        this.iconPaddingLeft = ss.iconPaddingLeft;
        this.iconPaddingRight = ss.iconPaddingRight;
        this.iconPaddingTop = ss.iconPaddingTop;
        this.iconPaddingBottom = ss.iconPaddingBottom;
        this.colorIconBackground = ss.colorIconBackground;
    }

    protected static class SavedState
    extends AbsSavedState {
        int iconResource;
        int iconSize;
        int iconWidth;
        int iconHeight;
        int iconPadding;
        int iconPaddingLeft;
        int iconPaddingRight;
        int iconPaddingTop;
        int iconPaddingBottom;
        int colorIconBackground;
        public static final Parcelable.ClassLoaderCreator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(Parcel in) {
            this(in, null);
        }

        SavedState(Parcel in, ClassLoader loader) {
            super(in, loader);
            this.iconResource = in.readInt();
            this.iconSize = in.readInt();
            this.iconWidth = in.readInt();
            this.iconHeight = in.readInt();
            this.iconPadding = in.readInt();
            this.iconPaddingLeft = in.readInt();
            this.iconPaddingRight = in.readInt();
            this.iconPaddingTop = in.readInt();
            this.iconPaddingBottom = in.readInt();
            this.colorIconBackground = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.iconResource);
            out.writeInt(this.iconSize);
            out.writeInt(this.iconWidth);
            out.writeInt(this.iconHeight);
            out.writeInt(this.iconPadding);
            out.writeInt(this.iconPaddingLeft);
            out.writeInt(this.iconPaddingRight);
            out.writeInt(this.iconPaddingTop);
            out.writeInt(this.iconPaddingBottom);
            out.writeInt(this.colorIconBackground);
        }
    }

    public static interface OnIconClickListener {
        public void onIconClick();
    }
}

