/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.localizationactivity.core;

import android.app.Service;
import android.content.Context;
import android.content.res.Resources;
import com.akexorcist.localizationactivity.core.LanguageSetting;
import com.akexorcist.localizationactivity.core.LocalizationUtility;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/akexorcist/localizationactivity/core/LocalizationServiceDelegate;", "", "service", "Landroid/app/Service;", "(Landroid/app/Service;)V", "getApplicationContext", "Landroid/content/Context;", "applicationContext", "getBaseContext", "baseContext", "getLanguage", "Ljava/util/Locale;", "getResources", "Landroid/content/res/Resources;", "resources", "localization_release"})
public class LocalizationServiceDelegate {
    @NotNull
    private final Service service;

    public LocalizationServiceDelegate(@NotNull Service service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
    }

    @NotNull
    public final Resources getResources(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        return LocalizationUtility.INSTANCE.getLocalizedResources((Context)this.service, resources);
    }

    @NotNull
    public final Locale getLanguage() {
        Locale defaultLocale = LanguageSetting.getDefaultLanguage((Context)this.service);
        return LanguageSetting.INSTANCE.getLanguageWithDefault((Context)this.service, defaultLocale);
    }

    @NotNull
    public final Context getBaseContext(@NotNull Context baseContext) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        return LocalizationUtility.INSTANCE.getLocalizedContext(baseContext);
    }

    @NotNull
    public final Context getApplicationContext(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return LocalizationUtility.INSTANCE.getLocalizedContext(applicationContext);
    }
}

