/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.localizationactivity.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.BadParcelableException;
import android.os.Handler;
import android.os.Looper;
import com.akexorcist.localizationactivity.core.LanguageSetting;
import com.akexorcist.localizationactivity.core.LocalizationUtility;
import com.akexorcist.localizationactivity.core.OnLocaleChangedListener;
import java.util.ArrayList;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 /2\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\b\u0010 \u001a\u00020\u000fH\u0002J\u0006\u0010!\u001a\u00020\u000fJ\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010$\u001a\u00020\u000fH\u0002J\b\u0010%\u001a\u00020\u000fH\u0002J\u0016\u0010&\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\bJ\u0016\u0010&\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(J\u001e\u0010&\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(J\u0016\u0010*\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\bJ\u0016\u0010*\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(J\u001e\u0010*\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(J\b\u0010,\u001a\u00020\u000fH\u0002J\u000e\u0010-\u001a\u00020.2\u0006\u0010\u0013\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/akexorcist/localizationactivity/core/LocalizationActivityDelegate;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "currentLanguage", "Ljava/util/Locale;", "isLocalizationChanged", "", "localeChangedListeners", "Ljava/util/ArrayList;", "Lcom/akexorcist/localizationactivity/core/OnLocaleChangedListener;", "addOnLocaleChangedListener", "", "onLocaleChangedListener", "attachBaseContext", "Landroid/content/Context;", "context", "checkAfterLocaleChanging", "checkBeforeLocaleChanging", "checkLocaleChange", "getApplicationContext", "applicationContext", "getLanguage", "getResources", "Landroid/content/res/Resources;", "resources", "isCurrentLanguageSetting", "newLocale", "currentLocale", "notifyLanguageChanged", "onCreate", "onResume", "removeOnLocaleChangedListener", "sendOnAfterLocaleChangedEvent", "sendOnBeforeLocaleChangedEvent", "setLanguage", "newLanguage", "", "newCountry", "setLanguageWithoutNotification", "baseLocale", "setupLanguage", "updateConfigurationLocale", "Landroid/content/res/Configuration;", "Companion", "localization_release"})
public class LocalizationActivityDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity activity;
    private Locale currentLanguage;
    private boolean isLocalizationChanged;
    @NotNull
    private final ArrayList<OnLocaleChangedListener> localeChangedListeners;
    @NotNull
    private static final String KEY_ACTIVITY_LOCALE_CHANGED = "activity_locale_changed";

    public LocalizationActivityDelegate(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
        this.localeChangedListeners = new ArrayList();
    }

    @NotNull
    public final Activity getActivity() {
        return this.activity;
    }

    public final void addOnLocaleChangedListener(@NotNull OnLocaleChangedListener onLocaleChangedListener) {
        Intrinsics.checkNotNullParameter((Object)onLocaleChangedListener, (String)"onLocaleChangedListener");
        this.localeChangedListeners.add(onLocaleChangedListener);
    }

    public final void removeOnLocaleChangedListener(@NotNull OnLocaleChangedListener onLocaleChangedListener) {
        Intrinsics.checkNotNullParameter((Object)onLocaleChangedListener, (String)"onLocaleChangedListener");
        this.localeChangedListeners.remove(onLocaleChangedListener);
    }

    public final void onCreate() {
        this.setupLanguage();
        this.checkBeforeLocaleChanging();
    }

    public final void onResume(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        new Handler(Looper.getMainLooper()).post(() -> LocalizationActivityDelegate.onResume$lambda-0(this, context));
    }

    @NotNull
    public final Context attachBaseContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return LocalizationUtility.INSTANCE.getLocalizedContext(context);
    }

    @NotNull
    public final Configuration updateConfigurationLocale(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Configuration configuration = context.getResources().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"context.resources.configuration");
        return (Configuration)LocalizationUtility.INSTANCE.getLocalizedConfiguration(context, configuration).getFirst();
    }

    @NotNull
    public final Context getApplicationContext(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        return LocalizationUtility.INSTANCE.getLocalizedContext(applicationContext);
    }

    @NotNull
    public final Resources getResources(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        return LocalizationUtility.INSTANCE.getLocalizedResources((Context)this.activity, resources);
    }

    public final void setLanguage(@NotNull Context context, @NotNull String newLanguage) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)newLanguage, (String)"newLanguage");
        Locale locale = new Locale(newLanguage);
        this.setLanguage(context, locale);
    }

    public final void setLanguage(@NotNull Context context, @NotNull String newLanguage, @NotNull String newCountry) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)newLanguage, (String)"newLanguage");
        Intrinsics.checkNotNullParameter((Object)newCountry, (String)"newCountry");
        Locale locale = new Locale(newLanguage, newCountry);
        this.setLanguage(context, locale);
    }

    public final void setLanguage(@NotNull Context context, @NotNull Locale newLocale) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)newLocale, (String)"newLocale");
        Locale defaultLocale = LanguageSetting.getDefaultLanguage(context);
        Locale oldLocale = LanguageSetting.INSTANCE.getLanguageWithDefault(context, defaultLocale);
        if (!this.isCurrentLanguageSetting(newLocale, oldLocale)) {
            LanguageSetting.setLanguage((Context)this.activity, newLocale);
            this.notifyLanguageChanged();
        }
    }

    public final void setLanguageWithoutNotification(@NotNull Context context, @NotNull String newLanguage) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)newLanguage, (String)"newLanguage");
        Locale locale = new Locale(newLanguage);
        this.setLanguageWithoutNotification(context, locale);
    }

    public final void setLanguageWithoutNotification(@NotNull Context context, @NotNull String newLanguage, @NotNull String newCountry) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)newLanguage, (String)"newLanguage");
        Intrinsics.checkNotNullParameter((Object)newCountry, (String)"newCountry");
        Locale locale = new Locale(newLanguage, newCountry);
        this.setLanguageWithoutNotification(context, locale);
    }

    public final void setLanguageWithoutNotification(@NotNull Context context, @NotNull Locale baseLocale) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)baseLocale, (String)"baseLocale");
        Locale defaultLocale = LanguageSetting.getDefaultLanguage(context);
        Locale currentLocale = LanguageSetting.INSTANCE.getLanguageWithDefault(context, defaultLocale);
        if (!this.isCurrentLanguageSetting(baseLocale, currentLocale)) {
            LanguageSetting.setLanguage((Context)this.activity, baseLocale);
        }
    }

    @NotNull
    public final Locale getLanguage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Locale defaultLocale = LanguageSetting.getDefaultLanguage(context);
        return LanguageSetting.INSTANCE.getLanguageWithDefault(context, defaultLocale);
    }

    private final void checkBeforeLocaleChanging() {
        try {
            boolean bl;
            boolean isLocalizationChanged;
            Intent intent = this.activity.getIntent();
            boolean bl2 = isLocalizationChanged = intent == null ? false : (bl = intent.getBooleanExtra(KEY_ACTIVITY_LOCALE_CHANGED, false));
            if (isLocalizationChanged) {
                this.isLocalizationChanged = true;
                Intent intent2 = this.activity.getIntent();
                if (intent2 != null) {
                    intent2.removeExtra(KEY_ACTIVITY_LOCALE_CHANGED);
                }
            }
        }
        catch (BadParcelableException e) {
            e.printStackTrace();
        }
    }

    private final void setupLanguage() {
        block2: {
            Unit unit;
            Unit unit2;
            Locale locale = LanguageSetting.getLanguage((Context)this.activity);
            if (locale == null) {
                unit2 = null;
            } else {
                Locale locale2 = locale;
                boolean bl = false;
                this.currentLanguage = locale2;
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit != null) break block2;
            LocalizationActivityDelegate $this$setupLanguage_u24lambda_u2d2 = this;
            boolean bl = false;
            $this$setupLanguage_u24lambda_u2d2.checkLocaleChange((Context)$this$setupLanguage_u24lambda_u2d2.getActivity());
        }
    }

    private final boolean isCurrentLanguageSetting(Locale newLocale, Locale currentLocale) {
        return Intrinsics.areEqual((Object)newLocale.toString(), (Object)currentLocale.toString());
    }

    private final void notifyLanguageChanged() {
        this.sendOnBeforeLocaleChangedEvent();
        if (this.activity.getIntent() == null) {
            this.activity.setIntent(new Intent());
        }
        this.activity.getIntent().putExtra(KEY_ACTIVITY_LOCALE_CHANGED, true);
        this.activity.recreate();
    }

    private final void checkLocaleChange(Context context) {
        Locale defaultLocale = LanguageSetting.getDefaultLanguage(context);
        Locale currentLocale = LanguageSetting.INSTANCE.getLanguageWithDefault(context, defaultLocale);
        Locale locale = this.currentLanguage;
        if (locale == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentLanguage");
            locale = null;
        }
        if (!this.isCurrentLanguageSetting(locale, currentLocale)) {
            this.isLocalizationChanged = true;
            this.notifyLanguageChanged();
        }
    }

    private final void checkAfterLocaleChanging() {
        if (this.isLocalizationChanged) {
            this.sendOnAfterLocaleChangedEvent();
            this.isLocalizationChanged = false;
        }
    }

    private final void sendOnBeforeLocaleChangedEvent() {
        for (OnLocaleChangedListener changedListener : this.localeChangedListeners) {
            changedListener.onBeforeLocaleChanged();
        }
    }

    private final void sendOnAfterLocaleChangedEvent() {
        for (OnLocaleChangedListener listener : this.localeChangedListeners) {
            listener.onAfterLocaleChanged();
        }
    }

    private static final void onResume$lambda-0(LocalizationActivityDelegate this$0, Context $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        this$0.checkLocaleChange($context);
        this$0.checkAfterLocaleChanging();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/akexorcist/localizationactivity/core/LocalizationActivityDelegate$Companion;", "", "()V", "KEY_ACTIVITY_LOCALE_CHANGED", "", "localization_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

