/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.googledirection.request;

import com.akexorcist.googledirection.DirectionCallback;
import com.akexorcist.googledirection.model.Direction;
import com.akexorcist.googledirection.network.DirectionConnection;
import com.akexorcist.googledirection.request.DirectionRequestParam;
import com.google.android.gms.maps.model.LatLng;
import com.google.gson.Gson;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class DirectionRequest {
    protected DirectionRequestParam param;

    public DirectionRequest(String apiKey, LatLng origin, LatLng destination) {
        this.param = new DirectionRequestParam().setApiKey(apiKey).setOrigin(origin).setDestination(destination);
    }

    public DirectionRequest transportMode(String transportMode) {
        this.param.setTransportMode(transportMode);
        return this;
    }

    public DirectionRequest language(String language) {
        this.param.setLanguage(language);
        return this;
    }

    public DirectionRequest unit(String unit) {
        this.param.setUnit(unit);
        return this;
    }

    public DirectionRequest avoid(String avoid) {
        String oldAvoid = this.param.getAvoid();
        oldAvoid = oldAvoid != null && !oldAvoid.isEmpty() ? oldAvoid + "|" : "";
        oldAvoid = oldAvoid + avoid;
        this.param.setAvoid(oldAvoid);
        return this;
    }

    public DirectionRequest transitMode(String transitMode) {
        String oldTransitMode = this.param.getTransitMode();
        oldTransitMode = oldTransitMode != null && !oldTransitMode.isEmpty() ? oldTransitMode + "|" : "";
        oldTransitMode = oldTransitMode + transitMode;
        this.param.setTransitMode(oldTransitMode);
        return this;
    }

    public DirectionRequest alternativeRoute(boolean alternative) {
        this.param.setAlternatives(alternative);
        return this;
    }

    public DirectionRequest departureTime(String time) {
        this.param.setDepartureTime(time);
        return this;
    }

    public DirectionRequest waypoints(List<LatLng> waypoints) {
        this.param.setWaypoints(waypoints);
        return this;
    }

    public DirectionRequest optimizeWaypoints(boolean optimize) {
        this.param.setOptimizeWaypoints(optimize);
        return this;
    }

    public void execute(final DirectionCallback callback) {
        Call<Direction> direction = DirectionConnection.getInstance().createService().getDirection(this.param.getOrigin().latitude + "," + this.param.getOrigin().longitude, this.param.getDestination().latitude + "," + this.param.getDestination().longitude, this.waypointsToString(this.param.getWaypoints()), this.param.getTransportMode(), this.param.getDepartureTime(), this.param.getLanguage(), this.param.getUnit(), this.param.getAvoid(), this.param.getTransitMode(), this.param.isAlternatives(), this.param.getApiKey());
        direction.enqueue((Callback)new Callback<Direction>(){

            public void onResponse(Call<Direction> call, Response<Direction> response) {
                if (callback != null) {
                    callback.onDirectionSuccess((Direction)response.body(), new Gson().toJson(response.body()));
                }
            }

            public void onFailure(Call<Direction> call, Throwable t) {
                callback.onDirectionFailure(t);
            }
        });
    }

    private String waypointsToString(List<LatLng> waypoints) {
        if (waypoints != null && !waypoints.isEmpty()) {
            String string = this.param.isOptimizeWaypoints() ? "optimize:true|" : "";
            string = string + waypoints.get((int)0).latitude + "," + waypoints.get((int)0).longitude;
            for (int i = 1; i < waypoints.size(); ++i) {
                string = string + "|" + waypoints.get((int)i).latitude + "," + waypoints.get((int)i).longitude;
            }
            return string;
        }
        return null;
    }
}

