/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.googledirection.network;

import com.akexorcist.googledirection.config.GoogleDirectionConfiguration;
import com.akexorcist.googledirection.network.DirectionService;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class DirectionConnection {
    private static DirectionConnection connection;
    private DirectionService service;

    public static DirectionConnection getInstance() {
        if (connection == null) {
            connection = new DirectionConnection();
        }
        return connection;
    }

    public DirectionService createService() {
        if (this.service == null) {
            Retrofit retrofit = new Retrofit.Builder().client(this.getClient()).baseUrl("https://maps.googleapis.com/maps/api/").addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
            this.service = (DirectionService)retrofit.create(DirectionService.class);
        }
        return this.service;
    }

    private OkHttpClient getClient() {
        OkHttpClient client = GoogleDirectionConfiguration.getInstance().getCustomClient();
        if (client != null) {
            return client;
        }
        return this.createDefaultClient();
    }

    private OkHttpClient createDefaultClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (GoogleDirectionConfiguration.getInstance().isLogEnabled()) {
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
            interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            builder.addInterceptor((Interceptor)interceptor);
        }
        return builder.build();
    }
}

