/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.roundcornerprogressbar.common;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.akexorcist.roundcornerprogressbar.R;

public abstract class BaseRoundCornerProgressBar
extends LinearLayout {
    protected static final int DEFAULT_MAX_PROGRESS = 100;
    protected static final int DEFAULT_PROGRESS = 0;
    protected static final int DEFAULT_SECONDARY_PROGRESS = 0;
    protected static final int DEFAULT_PROGRESS_RADIUS = 30;
    protected static final int DEFAULT_BACKGROUND_PADDING = 0;
    private LinearLayout layoutBackground;
    private LinearLayout layoutProgress;
    private LinearLayout layoutSecondaryProgress;
    private int radius;
    private int padding;
    private int totalWidth;
    private float max;
    private float progress;
    private float secondaryProgress;
    private int colorBackground;
    private int colorProgress;
    private int colorSecondaryProgress;
    private boolean isReverse;
    private OnProgressChangedListener progressChangedListener;

    public BaseRoundCornerProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            this.previewLayout(context);
        } else {
            this.setup(context, attrs);
        }
    }

    @TargetApi(value=11)
    public BaseRoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            this.previewLayout(context);
        } else {
            this.setup(context, attrs);
        }
    }

    private void previewLayout(Context context) {
        this.setGravity(17);
        TextView tv = new TextView(context);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        tv.setLayoutParams(params);
        tv.setGravity(17);
        tv.setText((CharSequence)((Object)((Object)this)).getClass().getSimpleName());
        tv.setTextColor(-1);
        tv.setBackgroundColor(-7829368);
        this.addView((View)tv);
    }

    protected abstract int initLayout();

    protected abstract void initStyleable(Context var1, AttributeSet var2);

    protected abstract void initView();

    protected abstract void drawProgress(LinearLayout var1, float var2, float var3, float var4, int var5, int var6, int var7, boolean var8);

    protected abstract void onViewDraw();

    public void setup(Context context, AttributeSet attrs) {
        this.setupStyleable(context, attrs);
        this.removeAllViews();
        LayoutInflater.from((Context)context).inflate(this.initLayout(), (ViewGroup)this);
        this.layoutBackground = (LinearLayout)this.findViewById(R.id.layout_background);
        this.layoutProgress = (LinearLayout)this.findViewById(R.id.layout_progress);
        this.layoutSecondaryProgress = (LinearLayout)this.findViewById(R.id.layout_secondary_progress);
        this.initView();
    }

    public void setupStyleable(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RoundCornerProgress);
        this.radius = (int)typedArray.getDimension(R.styleable.RoundCornerProgress_rcRadius, this.dp2px(30.0f));
        this.padding = (int)typedArray.getDimension(R.styleable.RoundCornerProgress_rcBackgroundPadding, this.dp2px(0.0f));
        this.isReverse = typedArray.getBoolean(R.styleable.RoundCornerProgress_rcReverse, false);
        this.max = typedArray.getFloat(R.styleable.RoundCornerProgress_rcMax, 100.0f);
        this.progress = typedArray.getFloat(R.styleable.RoundCornerProgress_rcProgress, 0.0f);
        this.secondaryProgress = typedArray.getFloat(R.styleable.RoundCornerProgress_rcSecondaryProgress, 0.0f);
        int colorBackgroundDefault = context.getResources().getColor(R.color.round_corner_progress_bar_background_default);
        this.colorBackground = typedArray.getColor(R.styleable.RoundCornerProgress_rcBackgroundColor, colorBackgroundDefault);
        int colorProgressDefault = context.getResources().getColor(R.color.round_corner_progress_bar_progress_default);
        this.colorProgress = typedArray.getColor(R.styleable.RoundCornerProgress_rcProgressColor, colorProgressDefault);
        int colorSecondaryProgressDefault = context.getResources().getColor(R.color.round_corner_progress_bar_secondary_progress_default);
        this.colorSecondaryProgress = typedArray.getColor(R.styleable.RoundCornerProgress_rcSecondaryProgressColor, colorSecondaryProgressDefault);
        typedArray.recycle();
        this.initStyleable(context, attrs);
    }

    protected void onSizeChanged(int newWidth, int newHeight, int oldWidth, int oldHeight) {
        super.onSizeChanged(newWidth, newHeight, oldWidth, oldHeight);
        if (!this.isInEditMode()) {
            this.totalWidth = newWidth;
            this.drawAll();
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BaseRoundCornerProgressBar.this.drawPrimaryProgress();
                    BaseRoundCornerProgressBar.this.drawSecondaryProgress();
                }
            }, 5L);
        }
    }

    protected void drawAll() {
        this.drawBackgroundProgress();
        this.drawPadding();
        this.drawProgressReverse();
        this.drawPrimaryProgress();
        this.drawSecondaryProgress();
        this.onViewDraw();
    }

    private void drawBackgroundProgress() {
        GradientDrawable backgroundDrawable = this.createGradientDrawable(this.colorBackground);
        int newRadius = this.radius - this.padding / 2;
        backgroundDrawable.setCornerRadii(new float[]{newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius});
        if (Build.VERSION.SDK_INT >= 16) {
            this.layoutBackground.setBackground((Drawable)backgroundDrawable);
        } else {
            this.layoutBackground.setBackgroundDrawable((Drawable)backgroundDrawable);
        }
    }

    protected GradientDrawable createGradientDrawable(int color2) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(0);
        gradientDrawable.setColor(color2);
        return gradientDrawable;
    }

    private void drawPrimaryProgress() {
        this.drawProgress(this.layoutProgress, this.max, this.progress, this.totalWidth, this.radius, this.padding, this.colorProgress, this.isReverse);
    }

    private void drawSecondaryProgress() {
        this.drawProgress(this.layoutSecondaryProgress, this.max, this.secondaryProgress, this.totalWidth, this.radius, this.padding, this.colorSecondaryProgress, this.isReverse);
    }

    private void drawProgressReverse() {
        this.setupReverse(this.layoutProgress);
        this.setupReverse(this.layoutSecondaryProgress);
    }

    private void setupReverse(LinearLayout layoutProgress) {
        RelativeLayout.LayoutParams progressParams = (RelativeLayout.LayoutParams)layoutProgress.getLayoutParams();
        this.removeLayoutParamsRule(progressParams);
        if (this.isReverse) {
            progressParams.addRule(11);
            if (Build.VERSION.SDK_INT >= 17) {
                progressParams.addRule(21);
            }
        } else {
            progressParams.addRule(9);
            if (Build.VERSION.SDK_INT >= 17) {
                progressParams.addRule(20);
            }
        }
        layoutProgress.setLayoutParams((ViewGroup.LayoutParams)progressParams);
    }

    private void drawPadding() {
        this.layoutBackground.setPadding(this.padding, this.padding, this.padding, this.padding);
    }

    private void removeLayoutParamsRule(RelativeLayout.LayoutParams layoutParams) {
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.removeRule(11);
            layoutParams.removeRule(21);
            layoutParams.removeRule(9);
            layoutParams.removeRule(20);
        } else {
            layoutParams.addRule(11, 0);
            layoutParams.addRule(9, 0);
        }
    }

    @SuppressLint(value={"NewApi"})
    protected float dp2px(float dp) {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        return Math.round(dp * (float)(displayMetrics.densityDpi / 160));
    }

    public boolean isReverse() {
        return this.isReverse;
    }

    public void setReverse(boolean isReverse) {
        this.isReverse = isReverse;
        this.drawProgressReverse();
        this.drawPrimaryProgress();
        this.drawSecondaryProgress();
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        if (radius >= 0) {
            this.radius = radius;
        }
        this.drawBackgroundProgress();
        this.drawPrimaryProgress();
        this.drawSecondaryProgress();
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        if (padding >= 0) {
            this.padding = padding;
        }
        this.drawPadding();
        this.drawPrimaryProgress();
        this.drawSecondaryProgress();
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        if (max >= 0.0f) {
            this.max = max;
        }
        if (this.progress > max) {
            this.progress = max;
        }
        this.drawPrimaryProgress();
        this.drawSecondaryProgress();
    }

    public float getLayoutWidth() {
        return this.totalWidth;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress < 0.0f ? 0.0f : (progress > this.max ? this.max : progress);
        this.drawPrimaryProgress();
        if (this.progressChangedListener != null) {
            this.progressChangedListener.onProgressChanged(this.getId(), this.progress, true, false);
        }
    }

    public float getSecondaryProgressWidth() {
        if (this.layoutSecondaryProgress != null) {
            return this.layoutSecondaryProgress.getWidth();
        }
        return 0.0f;
    }

    public float getSecondaryProgress() {
        return this.secondaryProgress;
    }

    public void setSecondaryProgress(float secondaryProgress) {
        this.secondaryProgress = secondaryProgress < 0.0f ? 0.0f : (secondaryProgress > this.max ? this.max : secondaryProgress);
        this.drawSecondaryProgress();
        if (this.progressChangedListener != null) {
            this.progressChangedListener.onProgressChanged(this.getId(), this.secondaryProgress, false, true);
        }
    }

    public int getProgressBackgroundColor() {
        return this.colorBackground;
    }

    public void setProgressBackgroundColor(int colorBackground) {
        this.colorBackground = colorBackground;
        this.drawBackgroundProgress();
    }

    public int getProgressColor() {
        return this.colorProgress;
    }

    public void setProgressColor(int colorProgress) {
        this.colorProgress = colorProgress;
        this.drawPrimaryProgress();
    }

    public int getSecondaryProgressColor() {
        return this.colorSecondaryProgress;
    }

    public void setSecondaryProgressColor(int colorSecondaryProgress) {
        this.colorSecondaryProgress = colorSecondaryProgress;
        this.drawSecondaryProgress();
    }

    public void setOnProgressChangedListener(OnProgressChangedListener listener) {
        this.progressChangedListener = listener;
    }

    public void invalidate() {
        super.invalidate();
        this.drawAll();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.radius = this.radius;
        ss.padding = this.padding;
        ss.colorBackground = this.colorBackground;
        ss.colorProgress = this.colorProgress;
        ss.colorSecondaryProgress = this.colorSecondaryProgress;
        ss.max = this.max;
        ss.progress = this.progress;
        ss.secondaryProgress = this.secondaryProgress;
        ss.isReverse = this.isReverse;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.radius = ss.radius;
        this.padding = ss.padding;
        this.colorBackground = ss.colorBackground;
        this.colorProgress = ss.colorProgress;
        this.colorSecondaryProgress = ss.colorSecondaryProgress;
        this.max = ss.max;
        this.progress = ss.progress;
        this.secondaryProgress = ss.secondaryProgress;
        this.isReverse = ss.isReverse;
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(int var1, float var2, boolean var3, boolean var4);
    }

    private static class SavedState
    extends View.BaseSavedState {
        float max;
        float progress;
        float secondaryProgress;
        int radius;
        int padding;
        int colorBackground;
        int colorProgress;
        int colorSecondaryProgress;
        boolean isReverse;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.max = in.readFloat();
            this.progress = in.readFloat();
            this.secondaryProgress = in.readFloat();
            this.radius = in.readInt();
            this.padding = in.readInt();
            this.colorBackground = in.readInt();
            this.colorProgress = in.readInt();
            this.colorSecondaryProgress = in.readInt();
            this.isReverse = in.readByte() != 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeFloat(this.max);
            out.writeFloat(this.progress);
            out.writeFloat(this.secondaryProgress);
            out.writeInt(this.radius);
            out.writeInt(this.padding);
            out.writeInt(this.colorBackground);
            out.writeInt(this.colorProgress);
            out.writeInt(this.colorSecondaryProgress);
            out.writeByte((byte)(this.isReverse ? 1 : 0));
        }
    }
}

