/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.roundcornerprogressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.akexorcist.roundcornerprogressbar.R;
import com.akexorcist.roundcornerprogressbar.common.BaseRoundCornerProgressBar;

public class IconRoundCornerProgressBar
extends BaseRoundCornerProgressBar
implements View.OnClickListener {
    protected static final int DEFAULT_ICON_SIZE = 20;
    protected static final int DEFAULT_ICON_PADDING_LEFT = 0;
    protected static final int DEFAULT_ICON_PADDING_RIGHT = 0;
    protected static final int DEFAULT_ICON_PADDING_TOP = 0;
    protected static final int DEFAULT_ICON_PADDING_BOTTOM = 0;
    private ImageView ivProgressIcon;
    private int iconResource;
    private int iconSize;
    private int iconWidth;
    private int iconHeight;
    private int iconPadding;
    private int iconPaddingLeft;
    private int iconPaddingRight;
    private int iconPaddingTop;
    private int iconPaddingBottom;
    private int colorIconBackground;
    private OnIconClickListener iconClickListener;

    public IconRoundCornerProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public IconRoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public int initLayout() {
        return R.layout.layout_icon_round_corner_progress_bar;
    }

    @Override
    protected void initStyleable(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.IconRoundCornerProgress);
        this.iconResource = typedArray.getResourceId(R.styleable.IconRoundCornerProgress_rcIconSrc, R.mipmap.round_corner_progress_icon);
        this.iconSize = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgress_rcIconSize, -1.0f);
        this.iconWidth = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgress_rcIconWidth, this.dp2px(20.0f));
        this.iconHeight = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgress_rcIconHeight, this.dp2px(20.0f));
        this.iconPadding = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgress_rcIconPadding, -1.0f);
        this.iconPaddingLeft = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgress_rcIconPaddingLeft, this.dp2px(0.0f));
        this.iconPaddingRight = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgress_rcIconPaddingRight, this.dp2px(0.0f));
        this.iconPaddingTop = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgress_rcIconPaddingTop, this.dp2px(0.0f));
        this.iconPaddingBottom = (int)typedArray.getDimension(R.styleable.IconRoundCornerProgress_rcIconPaddingBottom, this.dp2px(0.0f));
        int colorIconBackgroundDefault = context.getResources().getColor(R.color.round_corner_progress_bar_background_default);
        this.colorIconBackground = typedArray.getColor(R.styleable.IconRoundCornerProgress_rcIconBackgroundColor, colorIconBackgroundDefault);
        typedArray.recycle();
    }

    @Override
    protected void initView() {
        this.ivProgressIcon = (ImageView)this.findViewById(R.id.iv_progress_icon);
        this.ivProgressIcon.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.iv_progress_icon && this.iconClickListener != null) {
            this.iconClickListener.onIconClick();
        }
    }

    public void setOnIconClickListener(OnIconClickListener listener) {
        this.iconClickListener = listener;
    }

    @Override
    protected void drawProgress(LinearLayout layoutProgress, float max, float progress, float totalWidth, int radius, int padding, int colorProgress, boolean isReverse) {
        GradientDrawable backgroundDrawable = this.createGradientDrawable(colorProgress);
        int newRadius = radius - padding / 2;
        if (isReverse && progress != max) {
            backgroundDrawable.setCornerRadii(new float[]{newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius});
        } else {
            backgroundDrawable.setCornerRadii(new float[]{0.0f, 0.0f, newRadius, newRadius, newRadius, newRadius, 0.0f, 0.0f});
        }
        if (Build.VERSION.SDK_INT >= 16) {
            layoutProgress.setBackground((Drawable)backgroundDrawable);
        } else {
            layoutProgress.setBackgroundDrawable((Drawable)backgroundDrawable);
        }
        float ratio = max / progress;
        int progressWidth = (int)((totalWidth - (float)(padding * 2 + this.ivProgressIcon.getWidth())) / ratio);
        ViewGroup.LayoutParams progressParams = layoutProgress.getLayoutParams();
        progressParams.width = progressWidth;
        layoutProgress.setLayoutParams(progressParams);
    }

    @Override
    protected void onViewDraw() {
        this.drawImageIcon();
        this.drawImageIconSize();
        this.drawImageIconPadding();
        this.drawIconBackgroundColor();
    }

    private void drawImageIcon() {
        this.ivProgressIcon.setImageResource(this.iconResource);
    }

    private void drawImageIconSize() {
        if (this.iconSize == -1) {
            this.ivProgressIcon.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.iconWidth, this.iconHeight));
        } else {
            this.ivProgressIcon.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.iconSize, this.iconSize));
        }
    }

    private void drawImageIconPadding() {
        if (this.iconPadding == -1 || this.iconPadding == 0) {
            this.ivProgressIcon.setPadding(this.iconPaddingLeft, this.iconPaddingTop, this.iconPaddingRight, this.iconPaddingBottom);
        } else {
            this.ivProgressIcon.setPadding(this.iconPadding, this.iconPadding, this.iconPadding, this.iconPadding);
        }
        this.ivProgressIcon.invalidate();
    }

    private void drawIconBackgroundColor() {
        GradientDrawable iconBackgroundDrawable = this.createGradientDrawable(this.colorIconBackground);
        int radius = this.getRadius() - this.getPadding() / 2;
        iconBackgroundDrawable.setCornerRadii(new float[]{radius, radius, 0.0f, 0.0f, 0.0f, 0.0f, radius, radius});
        if (Build.VERSION.SDK_INT >= 16) {
            this.ivProgressIcon.setBackground((Drawable)iconBackgroundDrawable);
        } else {
            this.ivProgressIcon.setBackgroundDrawable((Drawable)iconBackgroundDrawable);
        }
    }

    public int getIconImageResource() {
        return this.iconResource;
    }

    public void setIconImageResource(int resId) {
        this.iconResource = resId;
        this.drawImageIcon();
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int size) {
        if (size >= 0) {
            this.iconSize = size;
        }
        this.drawImageIconSize();
    }

    public int getIconPadding() {
        return this.iconPadding;
    }

    public void setIconPadding(int padding) {
        if (padding >= 0) {
            this.iconPadding = padding;
        }
        this.drawImageIconPadding();
    }

    public int getIconPaddingLeft() {
        return this.iconPaddingLeft;
    }

    public void setIconPaddingLeft(int padding) {
        if (padding > 0) {
            this.iconPaddingLeft = padding;
        }
        this.drawImageIconPadding();
    }

    public int getIconPaddingRight() {
        return this.iconPaddingRight;
    }

    public void setIconPaddingRight(int padding) {
        if (padding > 0) {
            this.iconPaddingRight = padding;
        }
        this.drawImageIconPadding();
    }

    public int getIconPaddingTop() {
        return this.iconPaddingTop;
    }

    public void setIconPaddingTop(int padding) {
        if (padding > 0) {
            this.iconPaddingTop = padding;
        }
        this.drawImageIconPadding();
    }

    public int getIconPaddingBottom() {
        return this.iconPaddingBottom;
    }

    public void setIconPaddingBottom(int padding) {
        if (padding > 0) {
            this.iconPaddingBottom = padding;
        }
        this.drawImageIconPadding();
    }

    public int getColorIconBackground() {
        return this.colorIconBackground;
    }

    public void setIconBackgroundColor(int color2) {
        this.colorIconBackground = color2;
        this.drawIconBackgroundColor();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.iconResource = this.iconResource;
        ss.iconSize = this.iconSize;
        ss.iconWidth = this.iconWidth;
        ss.iconHeight = this.iconHeight;
        ss.iconPadding = this.iconPadding;
        ss.iconPaddingLeft = this.iconPaddingLeft;
        ss.iconPaddingRight = this.iconPaddingRight;
        ss.iconPaddingTop = this.iconPaddingTop;
        ss.iconPaddingBottom = this.iconPaddingBottom;
        ss.colorIconBackground = this.colorIconBackground;
        return ss;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.iconResource = ss.iconResource;
        this.iconSize = ss.iconSize;
        this.iconWidth = ss.iconWidth;
        this.iconHeight = ss.iconHeight;
        this.iconPadding = ss.iconPadding;
        this.iconPaddingLeft = ss.iconPaddingLeft;
        this.iconPaddingRight = ss.iconPaddingRight;
        this.iconPaddingTop = ss.iconPaddingTop;
        this.iconPaddingBottom = ss.iconPaddingBottom;
        this.colorIconBackground = ss.colorIconBackground;
    }

    public static interface OnIconClickListener {
        public void onIconClick();
    }

    private static class SavedState
    extends View.BaseSavedState {
        int iconResource;
        int iconSize;
        int iconWidth;
        int iconHeight;
        int iconPadding;
        int iconPaddingLeft;
        int iconPaddingRight;
        int iconPaddingTop;
        int iconPaddingBottom;
        int colorIconBackground;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.iconResource = in.readInt();
            this.iconSize = in.readInt();
            this.iconWidth = in.readInt();
            this.iconHeight = in.readInt();
            this.iconPadding = in.readInt();
            this.iconPaddingLeft = in.readInt();
            this.iconPaddingRight = in.readInt();
            this.iconPaddingTop = in.readInt();
            this.iconPaddingBottom = in.readInt();
            this.colorIconBackground = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.iconResource);
            out.writeInt(this.iconSize);
            out.writeInt(this.iconWidth);
            out.writeInt(this.iconHeight);
            out.writeInt(this.iconPadding);
            out.writeInt(this.iconPaddingLeft);
            out.writeInt(this.iconPaddingRight);
            out.writeInt(this.iconPaddingTop);
            out.writeInt(this.iconPaddingBottom);
            out.writeInt(this.colorIconBackground);
        }
    }
}

