/*
 * Decompiled with CFR 0.152.
 */
package com.akbolatss.workshop.slidingpanel.utils;

import android.view.View;
import android.view.ViewGroup;
import com.akbolatss.workshop.slidingpanel.Side;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lcom/akbolatss/workshop/slidingpanel/utils/ViewUtils;", "", "()V", "setMargin", "", "view", "Landroid/view/View;", "offset", "", "side", "Lcom/akbolatss/workshop/slidingpanel/Side;", "setPadding", "sliding-panel-layout_release"})
public final class ViewUtils {
    public static final ViewUtils INSTANCE;

    public final void setMargin(@NotNull View view, int offset, @NotNull Side side) {
        ViewGroup.LayoutParams layoutParams;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)((Object)side), (String)"side");
        ViewGroup.LayoutParams layoutParams2 = layoutParams = view.getLayoutParams();
        if (layoutParams2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
        }
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams2;
        int leftMargin = marginLayoutParams.leftMargin + (side == Side.LEFT ? 1 : 0) * offset;
        int topMargin = marginLayoutParams.topMargin + (side == Side.TOP ? 1 : 0) * offset;
        int rightMargin = marginLayoutParams.rightMargin + (side == Side.RIGHT ? 1 : 0) * offset;
        int bottomMargin = marginLayoutParams.bottomMargin + (side == Side.BOTTOM ? 1 : 0) * offset;
        ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(leftMargin, topMargin, rightMargin, bottomMargin);
        view.setLayoutParams(layoutParams);
    }

    public final void setPadding(@NotNull View view, int offset, @NotNull Side side) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)((Object)side), (String)"side");
        int paddingLeft = view.getPaddingLeft() + (side == Side.LEFT ? 1 : 0) * offset;
        int paddingTop = view.getPaddingTop() + (side == Side.TOP ? 1 : 0) * offset;
        int paddingRight = view.getPaddingRight() + (side == Side.RIGHT ? 1 : 0) * offset;
        int paddingBottom = view.getPaddingBottom() + (side == Side.BOTTOM ? 1 : 0) * offset;
        view.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    private ViewUtils() {
    }

    static {
        ViewUtils viewUtils;
        INSTANCE = viewUtils = new ViewUtils();
    }
}

