/*
 * Decompiled with CFR 0.152.
 */
package com.akbolatss.workshop.slidingpanel;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import androidx.annotation.IdRes;
import androidx.core.content.ContextCompat;
import com.akbolatss.workshop.slidingpanel.Orientation;
import com.akbolatss.workshop.slidingpanel.PanelState;
import com.akbolatss.workshop.slidingpanel.R;
import com.akbolatss.workshop.slidingpanel.Side;
import com.akbolatss.workshop.slidingpanel.SlidingDirection;
import com.akbolatss.workshop.slidingpanel.SlidingPanelLayout$WhenMappings;
import com.akbolatss.workshop.slidingpanel.utils.Extensions;
import com.akbolatss.workshop.slidingpanel.utils.Utils;
import com.akbolatss.workshop.slidingpanel.utils.ViewUtils;
import java.util.HashMap;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 j2\u00020\u0001:\u0002jkB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006JS\u0010:\u001a\u00020;2K\u0010<\u001aG\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b>\u0012\b\b?\u0012\u0004\b\b(@\u0012\u0013\u0012\u00110*\u00a2\u0006\f\b>\u0012\b\b?\u0012\u0004\b\b(4\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b>\u0012\b\b?\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020;0=J\u000e\u0010:\u001a\u00020;2\u0006\u0010A\u001a\u00020\u001eJ\b\u0010B\u001a\u00020;H\u0002J\u001a\u0010C\u001a\u00020;2\u0006\u0010\t\u001a\u00020\b2\b\u0010D\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010E\u001a\u00020\u001b2\u0006\u0010F\u001a\u00020\b2\u0006\u0010G\u001a\u00020\bH\u0002J\u0010\u0010H\u001a\u00020;2\u0006\u0010I\u001a\u00020JH\u0016J \u0010K\u001a\u00020\u00142\u0006\u0010I\u001a\u00020J2\u0006\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020.H\u0014J\u0010\u0010N\u001a\u00020;2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010O\u001a\u00020;2\u0006\u0010I\u001a\u00020JH\u0002J\b\u0010P\u001a\u00020;H\u0002J\u0010\u0010Q\u001a\u00020;2\u0006\u0010\t\u001a\u00020\bH\u0002J\b\u0010R\u001a\u00020;H\u0014J\u0010\u0010S\u001a\u00020\u00142\u0006\u0010T\u001a\u00020UH\u0016J0\u0010V\u001a\u00020;2\u0006\u0010W\u001a\u00020\u00142\u0006\u0010X\u001a\u00020\r2\u0006\u0010Y\u001a\u00020\r2\u0006\u0010Z\u001a\u00020\r2\u0006\u0010[\u001a\u00020\rH\u0014J\u0018\u0010\\\u001a\u00020;2\u0006\u0010]\u001a\u00020\r2\u0006\u0010^\u001a\u00020\rH\u0014J\u0010\u0010_\u001a\u00020\u00142\u0006\u0010`\u001a\u00020UH\u0017J\b\u0010a\u001a\u00020\u0014H\u0016J\u000e\u0010b\u001a\u00020;2\u0006\u0010A\u001a\u00020\u001eJ\b\u0010c\u001a\u00020;H\u0002J\u000e\u0010d\u001a\u00020;2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010e\u001a\u00020;2\u0006\u00104\u001a\u00020*J\u0010\u0010e\u001a\u00020;2\u0006\u0010f\u001a\u00020\bH\u0002J\u0006\u0010g\u001a\u00020;J\u0010\u0010h\u001a\u00020;2\u0006\u0010i\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00104\u001a\u00020*2\u0006\u00103\u001a\u00020*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/akbolatss/workshop/slidingpanel/SlidingPanelLayout;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "coordOfFirstTouch", "", "currentSlide", "dragView", "Landroid/view/View;", "dragViewId", "", "drawChildChildTempRect", "Landroid/graphics/Rect;", "elevationShadow180Deg", "Landroid/graphics/drawable/Drawable;", "elevationShadow90Deg", "fitScreenApplied", "", "fittingView", "fittingViewId", "isInitialStateSet", "isSliding", "isTouchGoneOutside", "lastDirection", "Lcom/akbolatss/workshop/slidingpanel/SlidingDirection;", "listeners", "Ljava/util/HashSet;", "Lcom/akbolatss/workshop/slidingpanel/SlidingPanelLayout$OnSlideListener;", "maxSlide", "minSlide", "nonSlidingView", "nonSlidingViewId", "onLayoutChildRect", "onLayoutContainerRect", "orientation", "Lcom/akbolatss/workshop/slidingpanel/Orientation;", "getOrientation$sliding_panel_layout_release", "()Lcom/akbolatss/workshop/slidingpanel/Orientation;", "previousState", "Lcom/akbolatss/workshop/slidingpanel/PanelState;", "shadePaint", "Landroid/graphics/Paint;", "slideDuration", "", "slidingPanelShadowLengthPixels", "slidingView", "slidingViewId", "slidingViewPosAtFirstTouch", "<set-?>", "state", "getState", "()Lcom/akbolatss/workshop/slidingpanel/PanelState;", "touchSlop", "velocityTracker", "Landroid/view/VelocityTracker;", "addSlideListener", "", "callback", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "slidingPanel", "listener", "applyFitToScreenOnce", "completeSlide", "direction", "computeDirection", "xVelocity", "yVelocity", "draw", "canvas", "Landroid/graphics/Canvas;", "drawChild", "child", "drawingTime", "drawElevationShadow180", "drawElevationShadow90", "initInitialState", "notifyListeners", "onAttachedToWindow", "onInterceptTouchEvent", "currentTouchEvent", "Landroid/view/MotionEvent;", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTouchEvent", "touchEvent", "performClick", "removeListener", "resetVelocityTracker", "setDragView", "slideTo", "positionNormalized", "toggle", "updateState", "newSlideRatio", "Companion", "OnSlideListener", "sliding-panel-layout_release"})
public final class SlidingPanelLayout
extends FrameLayout {
    private final int touchSlop;
    private View slidingView;
    private View nonSlidingView;
    private View dragView;
    private View fittingView;
    @NotNull
    private final Orientation orientation;
    @NotNull
    private PanelState state;
    private boolean isInitialStateSet;
    private PanelState previousState;
    private float currentSlide;
    private float maxSlide;
    private float minSlide;
    private float slidingViewPosAtFirstTouch;
    private float coordOfFirstTouch;
    private VelocityTracker velocityTracker;
    private SlidingDirection lastDirection;
    private boolean isTouchGoneOutside;
    private boolean isSliding;
    private final Drawable elevationShadow90Deg;
    private final Drawable elevationShadow180Deg;
    @IdRes
    private final int slidingViewId;
    @IdRes
    private final int nonSlidingViewId;
    @IdRes
    private final int fittingViewId;
    @IdRes
    private int dragViewId;
    private boolean fitScreenApplied;
    private final HashSet<OnSlideListener> listeners;
    private long slideDuration;
    private int slidingPanelShadowLengthPixels;
    private final Rect onLayoutContainerRect;
    private final Rect onLayoutChildRect;
    private final Rect drawChildChildTempRect;
    private final Paint shadePaint;
    public static final long SLIDE_DURATION_SHORT = 300L;
    public static final long SLIDE_DURATION_LONG = 600L;
    private static final int SHADE_COLOR_WITH_ALPHA = -1728053248;
    private static final int SHADE_COLOR_MAX_ALPHA = 153;
    private static final int SHADE_COLOR = 0;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @NotNull
    public final Orientation getOrientation$sliding_panel_layout_release() {
        return this.orientation;
    }

    @NotNull
    public final PanelState getState() {
        return this.state;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getChildCount() != 2) {
            throw (Throwable)new IllegalStateException("SlidingPanelLayout must have exactly 2 children. But has " + this.getChildCount());
        }
        View view = this.findViewById(this.slidingViewId);
        if (view == null) {
            throw (Throwable)new RuntimeException("SlidingPanelLayout, slidingView is null.");
        }
        this.slidingView = view;
        View view2 = this.findViewById(this.nonSlidingViewId);
        if (view2 == null) {
            throw (Throwable)new RuntimeException("SlidingPanelLayout, nonSlidingView is null.");
        }
        this.nonSlidingView = view2;
        View view3 = this.findViewById(this.dragViewId);
        if (view3 == null) {
            if (this.dragViewId != -1) {
                throw (Throwable)new RuntimeException("SlidingPanelLayout, can't find dragView.");
            }
            view3 = this.slidingView;
            if (view3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
            }
        }
        this.dragView = view3;
        View view4 = this.findViewById(this.fittingViewId);
        if (view4 == null) {
            if (this.fittingViewId != -1) {
                throw (Throwable)new RuntimeException("SlidingPanelLayout, can't find fittingView.");
            }
            view4 = null;
        }
        this.fittingView = view4;
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent currentTouchEvent) {
        Intrinsics.checkParameterIsNotNull((Object)currentTouchEvent, (String)"currentTouchEvent");
        View view = this.dragView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dragView");
        }
        if (!Extensions.INSTANCE.isMotionEventWithinBounds(view, currentTouchEvent)) {
            this.isSliding = false;
            return false;
        }
        switch (currentTouchEvent.getAction()) {
            case 0: {
                float f;
                float f2 = this.coordOfFirstTouch = Extensions.INSTANCE.isOrientationVertical(this) ? currentTouchEvent.getY() : currentTouchEvent.getX();
                if (Extensions.INSTANCE.isOrientationVertical(this)) {
                    View view2 = this.slidingView;
                    if (view2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
                    }
                    f = view2.getY();
                } else {
                    View view3 = this.slidingView;
                    if (view3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
                    }
                    f = view3.getX();
                }
                this.slidingViewPosAtFirstTouch = f;
                this.isTouchGoneOutside = false;
                return false;
            }
            case 2: {
                float currentTouch = Extensions.INSTANCE.isOrientationVertical(this) ? currentTouchEvent.getY() : currentTouchEvent.getX();
                float f = currentTouch - this.coordOfFirstTouch;
                boolean bl = false;
                float diff = Math.abs(f);
                this.isSliding = diff > (float)(this.touchSlop / 4);
                return this.isSliding;
            }
        }
        this.isSliding = false;
        return false;
    }

    @SuppressLint(value={"ClickableViewAccessibility", "Recycle"})
    public boolean onTouchEvent(@NotNull MotionEvent touchEvent) {
        Intrinsics.checkParameterIsNotNull((Object)touchEvent, (String)"touchEvent");
        if (this.isTouchGoneOutside) {
            return false;
        }
        float currentTouchEvent = Extensions.INSTANCE.isOrientationVertical(this) ? touchEvent.getY() : touchEvent.getX();
        switch (touchEvent.getAction()) {
            case 0: {
                VelocityTracker velocityTracker;
                VelocityTracker velocityTracker2 = this.velocityTracker;
                if (velocityTracker2 != null) {
                    velocityTracker2.clear();
                }
                if ((velocityTracker = this.velocityTracker) == null) {
                    velocityTracker = VelocityTracker.obtain();
                }
                VelocityTracker velocityTracker3 = this.velocityTracker = velocityTracker;
                if (velocityTracker3 != null) {
                    velocityTracker3.addMovement(touchEvent);
                }
                break;
            }
            case 2: {
                boolean isTouchGoneOutside;
                VelocityTracker velocityTracker = this.velocityTracker;
                if (velocityTracker != null) {
                    VelocityTracker velocityTracker4 = velocityTracker;
                    boolean bl = false;
                    boolean bl2 = false;
                    VelocityTracker $this$run = velocityTracker4;
                    boolean bl3 = false;
                    int pointerId = touchEvent.getPointerId(touchEvent.getActionIndex());
                    $this$run.addMovement(touchEvent);
                    $this$run.computeCurrentVelocity(1000);
                    float xVelocity = $this$run.getXVelocity(pointerId);
                    float yVelocity = $this$run.getYVelocity(pointerId);
                    this.lastDirection = this.computeDirection(xVelocity, yVelocity);
                }
                View view = this.dragView;
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dragView");
                }
                boolean bl = isTouchGoneOutside = !Extensions.INSTANCE.isMotionEventWithinBounds(view, touchEvent);
                if (!this.isSliding && isTouchGoneOutside) {
                    if (isTouchGoneOutside) {
                        MotionEvent motionEvent = MotionEvent.obtain((MotionEvent)touchEvent);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        MotionEvent $this$apply = motionEvent;
                        boolean bl6 = false;
                        $this$apply.setAction(4);
                        MotionEvent preventiveTouch = motionEvent;
                        return this.dispatchTouchEvent(preventiveTouch);
                    }
                    return false;
                }
                float touchOffset = this.coordOfFirstTouch - currentTouchEvent;
                float finalPosition = this.slidingViewPosAtFirstTouch - touchOffset;
                finalPosition = Utils.INSTANCE.clamp(finalPosition, this.minSlide, this.maxSlide);
                this.updateState(Utils.INSTANCE.normalizeScreenCoordinate(finalPosition, this.maxSlide));
                break;
            }
            case 1: {
                if (this.state == PanelState.SLIDING) {
                    this.completeSlide(this.currentSlide, this.lastDirection);
                }
                this.resetVelocityTracker();
                break;
            }
            case 3: {
                this.completeSlide(this.currentSlide, this.lastDirection);
                break;
            }
            case 4: {
                this.isTouchGoneOutside = true;
                this.completeSlide(this.currentSlide, this.lastDirection);
                break;
            }
        }
        return true;
    }

    private final SlidingDirection computeDirection(float xVelocity, float yVelocity) {
        boolean bl = false;
        float f = Math.abs(xVelocity);
        bl = false;
        float f2 = Math.abs(yVelocity);
        return f > f2 ? (xVelocity > 0.0f ? SlidingDirection.DOWN_OR_RIGHT : SlidingDirection.UP_OR_LEFT) : (yVelocity > 0.0f ? SlidingDirection.DOWN_OR_RIGHT : SlidingDirection.UP_OR_LEFT);
    }

    private final void resetVelocityTracker() {
        VelocityTracker velocityTracker = this.velocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
        }
        this.velocityTracker = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void completeSlide(float currentSlide, SlidingDirection direction) {
        float f;
        SlidingDirection slidingDirection = direction;
        if (slidingDirection == null) return;
        switch (SlidingPanelLayout$WhenMappings.$EnumSwitchMapping$0[slidingDirection.ordinal()]) {
            case 1: {
                if ((double)currentSlide > 0.1) {
                    f = this.minSlide;
                    break;
                }
                f = this.maxSlide;
                break;
            }
            case 2: {
                if ((double)currentSlide < 0.9) {
                    f = this.maxSlide;
                    break;
                }
                f = this.minSlide;
                break;
            }
            default: {
                return;
            }
        }
        float targetSlide = f;
        this.slideTo(Utils.INSTANCE.normalizeScreenCoordinate(targetSlide, this.maxSlide));
    }

    public boolean performClick() {
        super.performClick();
        this.toggle();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int slidingPanelHeight = 0;
        int slidingPanelWidth = 0;
        int childrenCombinedMeasuredStates = 0;
        int n = 0;
        int n2 = this.getChildCount();
        while (n < n2) {
            View child;
            void i;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.getChildAt((int)i), (String)"getChildAt(i)");
            if (child.getVisibility() != 8) {
                this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
                ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                if (layoutParams == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
                slidingPanelWidth = RangesKt.coerceAtLeast((int)slidingPanelWidth, (int)(child.getMeasuredWidth() + layoutParams2.leftMargin + layoutParams2.rightMargin));
                slidingPanelHeight = RangesKt.coerceAtLeast((int)slidingPanelHeight, (int)(child.getMeasuredHeight() + layoutParams2.topMargin + layoutParams2.bottomMargin));
                childrenCombinedMeasuredStates = View.combineMeasuredStates((int)childrenCombinedMeasuredStates, (int)child.getMeasuredState());
            }
            ++i;
        }
        slidingPanelHeight = RangesKt.coerceAtLeast((int)slidingPanelHeight, (int)this.getSuggestedMinimumHeight());
        slidingPanelWidth = RangesKt.coerceAtLeast((int)slidingPanelWidth, (int)this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(View.resolveSizeAndState((int)slidingPanelWidth, (int)widthMeasureSpec, (int)childrenCombinedMeasuredStates), View.resolveSizeAndState((int)slidingPanelHeight, (int)heightMeasureSpec, (int)childrenCombinedMeasuredStates));
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int currentTop = this.getPaddingTop();
        int currentLeft = this.getPaddingLeft();
        int n = 0;
        int n2 = this.getChildCount();
        while (n < n2) {
            View child;
            void i;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.getChildAt((int)i), (String)"getChildAt(i)");
            if (child.getVisibility() != 8) {
                ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                if (layoutParams == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams childLayoutParams = (FrameLayout.LayoutParams)layoutParams;
                int childWidth = child.getMeasuredWidth();
                int childHeight = child.getMeasuredHeight();
                this.onLayoutContainerRect.left = currentLeft + childLayoutParams.leftMargin;
                this.onLayoutContainerRect.right = currentLeft + childWidth - childLayoutParams.rightMargin;
                this.onLayoutContainerRect.top = currentTop + childLayoutParams.topMargin;
                this.onLayoutContainerRect.bottom = currentTop + childHeight - childLayoutParams.bottomMargin;
                if (Extensions.INSTANCE.isOrientationVertical(this)) {
                    currentTop = this.onLayoutContainerRect.bottom;
                } else {
                    currentLeft = this.onLayoutContainerRect.right;
                }
                Gravity.apply((int)childLayoutParams.gravity, (int)childWidth, (int)childHeight, (Rect)this.onLayoutContainerRect, (Rect)this.onLayoutChildRect);
                child.layout(this.onLayoutChildRect.left, this.onLayoutChildRect.top, this.onLayoutChildRect.right, this.onLayoutChildRect.bottom);
            }
            ++i;
        }
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.draw(canvas);
        if (Extensions.INSTANCE.isOrientationVertical(this)) {
            this.drawElevationShadow90(canvas);
        } else {
            this.drawElevationShadow180(canvas);
        }
        if (!this.isInitialStateSet) {
            this.initInitialState();
        }
    }

    private final void drawElevationShadow90(Canvas canvas) {
        View view = this.slidingView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
        }
        int top = (int)(view.getY() - (float)this.slidingPanelShadowLengthPixels);
        View view2 = this.slidingView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
        }
        int bottom = (int)view2.getY();
        View view3 = this.slidingView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
        }
        int left = view3.getLeft();
        View view4 = this.slidingView;
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
        }
        int right = view4.getRight();
        this.elevationShadow90Deg.setBounds(left, top, right, bottom);
        this.elevationShadow90Deg.draw(canvas);
    }

    private final void drawElevationShadow180(Canvas canvas) {
        View view = this.slidingView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
        }
        int top = view.getTop();
        View view2 = this.slidingView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
        }
        int bottom = view2.getBottom();
        View view3 = this.slidingView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
        }
        int left = (int)(view3.getX() - (float)this.slidingPanelShadowLengthPixels);
        View view4 = this.slidingView;
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
        }
        int right = (int)view4.getX();
        this.elevationShadow180Deg.setBounds(left, top, right, bottom);
        this.elevationShadow180Deg.draw(canvas);
    }

    private final void initInitialState() {
        if (this.state == PanelState.SLIDING) {
            throw (Throwable)new RuntimeException("SLIDING state cannot be used as initial");
        }
        this.updateState(this.state.getValue());
        this.isInitialStateSet = true;
    }

    protected boolean drawChild(@NotNull Canvas canvas, @NotNull View child, long drawingTime) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        int save = canvas.save();
        boolean result = false;
        View view = child;
        View view2 = this.nonSlidingView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nonSlidingView");
        }
        if (Intrinsics.areEqual((Object)view, (Object)view2)) {
            float f;
            float f2;
            if (Extensions.INSTANCE.isOrientationVertical(this)) {
                View view3 = this.nonSlidingView;
                if (view3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"nonSlidingView");
                }
                f2 = view3.getHeight();
            } else {
                View view4 = this.nonSlidingView;
                if (view4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"nonSlidingView");
                }
                f2 = this.maxSlide = (float)view4.getWidth();
            }
            if (Extensions.INSTANCE.isOrientationVertical(this)) {
                View view5 = this.nonSlidingView;
                if (view5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"nonSlidingView");
                }
                f = view5.getTop();
            } else {
                View view6 = this.nonSlidingView;
                if (view6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"nonSlidingView");
                }
                f = view6.getLeft();
            }
            this.minSlide = f;
            canvas.getClipBounds(this.drawChildChildTempRect);
            result = super.drawChild(canvas, child, drawingTime);
            if (this.currentSlide > 0.0f) {
                int currentShadeAlpha = (int)((float)153 * this.currentSlide);
                int currentShadeColor = currentShadeAlpha << 24 | 0;
                this.shadePaint.setColor(currentShadeColor);
                canvas.drawRect(this.drawChildChildTempRect, this.shadePaint);
            }
        } else {
            View view7 = this.slidingView;
            if (view7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
            }
            if (Intrinsics.areEqual((Object)view, (Object)view7)) {
                this.applyFitToScreenOnce();
                result = super.drawChild(canvas, child, drawingTime);
            } else {
                result = super.drawChild(canvas, child, drawingTime);
            }
        }
        canvas.restoreToCount(save);
        return result;
    }

    private final void applyFitToScreenOnce() {
        Side side;
        if (this.fitScreenApplied) {
            return;
        }
        Side side2 = side = Extensions.INSTANCE.isOrientationVertical(this) ? Side.BOTTOM : Side.RIGHT;
        if (this.fittingView != null) {
            View view = this.fittingView;
            if (view == null) {
                Intrinsics.throwNpe();
            }
            ViewUtils.INSTANCE.setMargin(view, (int)this.maxSlide, side);
        }
        this.fitScreenApplied = true;
    }

    private final void slideTo(float positionNormalized) {
        ValueAnimator va;
        if (Float.isNaN(positionNormalized)) {
            throw (Throwable)new IllegalArgumentException("Bad value. Can't slide to NaN");
        }
        if (positionNormalized < 0.0f || positionNormalized > 1.0f) {
            throw (Throwable)new IllegalArgumentException("Bad value. Can't slide to " + positionNormalized + ". Value must be between 0 and 1");
        }
        ValueAnimator valueAnimator = va = ValueAnimator.ofFloat((float[])new float[]{this.currentSlide, positionNormalized});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"va");
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.5f));
        va.setDuration(this.slideDuration);
        va.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ SlidingPanelLayout this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                SlidingPanelLayout.access$updateState(this.this$0, ((Float)object).floatValue());
            }
            {
                this.this$0 = slidingPanelLayout;
            }
        });
        va.start();
    }

    private final void updateState(float newSlideRatio) {
        if (newSlideRatio < 0.0f || newSlideRatio > 1.0f) {
            throw (Throwable)new IllegalArgumentException("Slide value \"" + newSlideRatio + "\" should be normalized, between 0 and 1.");
        }
        this.currentSlide = newSlideRatio;
        float f = this.currentSlide;
        this.state = f == 1.0f ? PanelState.COLLAPSED : (f == 0.0f ? PanelState.EXPANDED : PanelState.SLIDING);
        float f2 = this.currentSlide * this.maxSlide - this.maxSlide;
        boolean bl = false;
        float currentSlideNonNormalized = Math.abs(f2);
        if (Extensions.INSTANCE.isOrientationVertical(this)) {
            View view = this.slidingView;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
            }
            view.setY(currentSlideNonNormalized);
        } else {
            View view = this.slidingView;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"slidingView");
            }
            view.setX(currentSlideNonNormalized);
        }
        this.invalidate();
        if (this.state != this.previousState || this.state == PanelState.SLIDING) {
            this.notifyListeners(this.currentSlide);
            this.previousState = this.state;
        }
    }

    public final void setDragView(@NotNull View dragView) {
        Intrinsics.checkParameterIsNotNull((Object)dragView, (String)"dragView");
        this.dragView = dragView;
        this.dragViewId = dragView.getId();
    }

    public final void slideTo(@NotNull PanelState state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        if (state == this.state) {
            return;
        }
        switch (SlidingPanelLayout$WhenMappings.$EnumSwitchMapping$1[state.ordinal()]) {
            case 1: {
                this.slideTo(1.0f);
                break;
            }
            case 2: {
                this.slideTo(0.0f);
                break;
            }
            case 3: {
                throw (Throwable)new IllegalArgumentException("You are not allowed to set the state to SLIDING. Please use EXPANDED or COLLAPSED");
            }
        }
    }

    public final void toggle() {
        if (this.state == PanelState.COLLAPSED) {
            this.slideTo(PanelState.EXPANDED);
        } else {
            this.slideTo(PanelState.COLLAPSED);
        }
    }

    public final void addSlideListener(@NotNull OnSlideListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public final void addSlideListener(@NotNull Function3<? super SlidingPanelLayout, ? super PanelState, ? super Float, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.addSlideListener(new OnSlideListener(callback){
            final /* synthetic */ Function3 $callback;

            public void onSlide(@NotNull SlidingPanelLayout slidingPanel, @NotNull PanelState state, float currentSlide) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)slidingPanel), (String)"slidingPanel");
                Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
                this.$callback.invoke((Object)((Object)slidingPanel), (Object)((Object)state), (Object)Float.valueOf(currentSlide));
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    public final void removeListener(@NotNull OnSlideListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listeners.remove(listener);
    }

    private final void notifyListeners(float currentSlide) {
        for (OnSlideListener listener : this.listeners) {
            listener.onSlide(this, this.state, currentSlide);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlidingPanelLayout(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"ViewConfiguration.get(getContext())");
        this.touchSlop = viewConfiguration.getScaledTouchSlop();
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.sp_elevation_shadow_90_deg);
        if (drawable2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"ContextCompat.getDrawabl\u2026levation_shadow_90_deg)!!");
        this.elevationShadow90Deg = drawable2;
        Drawable drawable3 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.sp_elevation_shadow_180_deg);
        if (drawable3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable3, (String)"ContextCompat.getDrawabl\u2026evation_shadow_180_deg)!!");
        this.elevationShadow180Deg = drawable3;
        this.listeners = new HashSet();
        this.slideDuration = 300L;
        this.setWillNotDraw(false);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SlidingPanelLayout, 0, 0);
        try {
            this.slidingViewId = typedArray.getResourceId(R.styleable.SlidingPanelLayout_slidingView, -1);
            this.nonSlidingViewId = typedArray.getResourceId(R.styleable.SlidingPanelLayout_nonSlidingView, -1);
            this.dragViewId = typedArray.getResourceId(R.styleable.SlidingPanelLayout_dragView, -1);
            this.fittingViewId = typedArray.getResourceId(R.styleable.SlidingPanelLayout_fitToScreenView, -1);
            this.slidingPanelShadowLengthPixels = typedArray.getDimensionPixelSize(R.styleable.SlidingPanelLayout_elevation, this.getResources().getDimensionPixelSize(R.dimen.sp_4dp));
            int orientationEnumPos = typedArray.getInt(R.styleable.SlidingPanelLayout_orientation, 0);
            this.orientation = Orientation.values()[orientationEnumPos];
            int initialStateId = typedArray.getInt(R.styleable.SlidingPanelLayout_slidingState, 0);
            this.state = PanelState.values()[initialStateId];
        }
        finally {
            typedArray.recycle();
        }
        if (this.slidingViewId == -1) {
            throw (Throwable)new RuntimeException("SlidingPanelLayout, app:slidingView attribute not set. You must set this attribute to the id of the view that you want to be sliding.");
        }
        if (this.nonSlidingViewId == -1) {
            throw (Throwable)new RuntimeException("SlidingPanelLayout, app:nonSlidingView attribute not set. You must set this attribute to the id of the view that you want to be static.");
        }
        this.onLayoutContainerRect = new Rect();
        this.onLayoutChildRect = new Rect();
        this.drawChildChildTempRect = new Rect();
        this.shadePaint = new Paint();
    }

    public /* synthetic */ SlidingPanelLayout(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public static final /* synthetic */ void access$updateState(SlidingPanelLayout $this, float newSlideRatio) {
        $this.updateState(newSlideRatio);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lcom/akbolatss/workshop/slidingpanel/SlidingPanelLayout$OnSlideListener;", "", "onSlide", "", "slidingPanel", "Lcom/akbolatss/workshop/slidingpanel/SlidingPanelLayout;", "state", "Lcom/akbolatss/workshop/slidingpanel/PanelState;", "currentSlide", "", "sliding-panel-layout_release"})
    public static interface OnSlideListener {
        public void onSlide(@NotNull SlidingPanelLayout var1, @NotNull PanelState var2, float var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/akbolatss/workshop/slidingpanel/SlidingPanelLayout$Companion;", "", "()V", "SHADE_COLOR", "", "SHADE_COLOR_MAX_ALPHA", "SHADE_COLOR_WITH_ALPHA", "SLIDE_DURATION_LONG", "", "SLIDE_DURATION_SHORT", "sliding-panel-layout_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

