/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j;

import com.akathist.maven.plugins.launch4j.ClassPath;
import com.akathist.maven.plugins.launch4j.Jre;
import com.akathist.maven.plugins.launch4j.MavenLog;
import com.akathist.maven.plugins.launch4j.Messages;
import com.akathist.maven.plugins.launch4j.SingleInstance;
import com.akathist.maven.plugins.launch4j.Splash;
import com.akathist.maven.plugins.launch4j.VersionInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.launch4j.Builder;
import net.sf.launch4j.BuilderException;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersister;
import net.sf.launch4j.config.ConfigPersisterException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;

@Mojo(name="launch4j", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class Launch4jMojo
extends AbstractMojo {
    private static final String LAUNCH4J_ARTIFACT_ID = "launch4j";
    private static final String LAUNCH4J_GROUP_ID = "net.sf.launch4j";
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.artifacts}", required=true, readonly=true)
    private Set<Artifact> dependencies;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.plugins}", required=true, readonly=true)
    private List<Artifact> plugins;
    @Component(role=RepositorySystem.class)
    private RepositorySystem factory;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Component(role=ArtifactResolver.class)
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    private File basedir;
    @Parameter
    private String headerType;
    @Parameter
    private File infile;
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}.exe")
    private File outfile;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.jar")
    private String jar;
    @Parameter(defaultValue="false")
    private boolean dontWrapJar;
    @Parameter
    private String errTitle;
    @Parameter
    private String downloadUrl;
    @Parameter
    private String supportUrl;
    @Parameter
    private String cmdLine;
    @Parameter
    private String chdir;
    @Parameter(defaultValue="normal")
    private String priority;
    @Parameter(defaultValue="false")
    private boolean stayAlive;
    @Parameter(defaultValue="false")
    private boolean restartOnCrash;
    @Parameter
    private File icon;
    @Parameter
    private List<String> objs;
    @Parameter
    private List<String> libs;
    @Parameter
    private List<String> vars;
    @Parameter
    private Jre jre;
    @Parameter
    private ClassPath classPath;
    @Parameter
    private SingleInstance singleInstance;
    @Parameter
    private Splash splash;
    @Parameter
    private VersionInfo versionInfo;
    @Parameter
    private Messages messages;
    @Parameter
    private File manifest;
    @Parameter(defaultValue="false")
    private boolean saveConfig = false;
    @Parameter(defaultValue="${project.build.directory}/launch4j-config.xml")
    private File configOutfile;
    @Parameter(defaultValue="false")
    private boolean parallelExecution = false;

    private File getJar() {
        return new File(this.jar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.parallelExecution) {
            Class<Launch4jMojo> clazz = Launch4jMojo.class;
            synchronized (Launch4jMojo.class) {
                this.doExecute();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            this.doExecute();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doExecute() throws MojoExecutionException {
        Config c;
        File workDir = this.setupBuildEnvironment();
        if (this.infile != null) {
            if (!this.infile.exists()) throw new MojoExecutionException("Launch4j native configuration file [" + this.infile.getAbsolutePath() + "] does not exist!");
            try {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Trying to load Launch4j native configuration using file=" + this.infile.getAbsolutePath()));
                }
                ConfigPersister.getInstance().load(this.infile);
                c = ConfigPersister.getInstance().getConfig();
                String jarDefaultValue = this.project.getBuild().getDirectory() + "/" + this.project.getBuild().getFinalName() + ".jar";
                if (this.jar != null && !this.jar.equals(jarDefaultValue)) {
                    this.getLog().debug((CharSequence)("Overwriting config file property 'jar' (='" + c.getJar().getAbsolutePath() + "') with local value '" + this.getJar().getAbsolutePath() + "'"));
                    c.setJar(this.getJar());
                }
                File outFileDefaultValue = new File(this.project.getBuild().getDirectory() + "/" + this.project.getArtifactId() + ".exe");
                if (this.outfile != null && !this.outfile.getAbsolutePath().equals(outFileDefaultValue.getAbsolutePath())) {
                    this.getLog().debug((CharSequence)("Overwriting config file property 'outfile' (='" + c.getOutfile().getAbsolutePath() + "') with local value '" + this.outfile.getAbsolutePath() + "'"));
                    c.setOutfile(this.outfile);
                }
                if (this.versionInfo != null) {
                    if (this.versionInfo.fileVersion != null) {
                        this.getLog().debug((CharSequence)("Overwriting config file property 'versionInfo.fileVersion' (='" + c.getVersionInfo().getFileVersion() + "') with local value '" + this.versionInfo.fileVersion + "'"));
                        c.getVersionInfo().setFileVersion(this.versionInfo.fileVersion);
                    }
                    if (this.versionInfo.txtFileVersion != null) {
                        this.getLog().debug((CharSequence)("Overwriting config file property 'versionInfo.txtFileVersion' (='" + c.getVersionInfo().getTxtFileVersion() + "') with local value '" + this.versionInfo.txtFileVersion + "'"));
                        c.getVersionInfo().setTxtFileVersion(this.versionInfo.txtFileVersion);
                    }
                    if (this.versionInfo.productVersion != null) {
                        this.getLog().debug((CharSequence)("Overwriting config file property 'versionInfo.productVersion' (='" + c.getVersionInfo().getProductVersion() + "') with local value '" + this.versionInfo.productVersion + "'"));
                        c.getVersionInfo().setProductVersion(this.versionInfo.productVersion);
                    }
                    if (this.versionInfo.txtProductVersion != null) {
                        this.getLog().debug((CharSequence)("Overwriting config file property 'versionInfo.txtProductVersion' (='" + c.getVersionInfo().getTxtProductVersion() + "') with local value '" + this.versionInfo.txtProductVersion + "'"));
                        c.getVersionInfo().setTxtProductVersion(this.versionInfo.txtProductVersion);
                    }
                }
                ConfigPersister.getInstance().setAntConfig(c, this.infile.getParentFile());
            }
            catch (ConfigPersisterException e) {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("Could not load Launch4j native configuration file", (Exception)((Object)e));
            }
        } else {
            c = new Config();
            c.setHeaderType(this.headerType);
            c.setOutfile(this.outfile);
            c.setJar(this.getJar());
            c.setDontWrapJar(this.dontWrapJar);
            c.setErrTitle(this.errTitle);
            c.setDownloadUrl(this.downloadUrl);
            c.setSupportUrl(this.supportUrl);
            c.setCmdLine(this.cmdLine);
            c.setChdir(this.chdir);
            c.setPriority(this.priority);
            c.setStayAlive(this.stayAlive);
            c.setRestartOnCrash(this.restartOnCrash);
            c.setManifest(this.manifest);
            c.setIcon(this.icon);
            c.setHeaderObjects(this.relativizeAndCopy(workDir, this.objs));
            c.setLibs(this.relativizeAndCopy(workDir, this.libs));
            c.setVariables(this.vars);
            if (this.classPath != null) {
                c.setClassPath(this.classPath.toL4j(this.dependencies));
            }
            if (this.jre != null) {
                c.setJre(this.jre.toL4j());
            }
            if (this.singleInstance != null) {
                c.setSingleInstance(this.singleInstance.toL4j());
            }
            if (this.splash != null) {
                c.setSplash(this.splash.toL4j());
            }
            if (this.versionInfo != null) {
                c.setVersionInfo(this.versionInfo.toL4j());
            }
            if (this.messages != null) {
                c.setMessages(this.messages.toL4j());
            }
            ConfigPersister.getInstance().setAntConfig(c, this.getBaseDir());
        }
        if (this.getLog().isDebugEnabled()) {
            this.printState();
        }
        Builder builder = new Builder((net.sf.launch4j.Log)new MavenLog(this.getLog()), workDir);
        try {
            builder.build();
        }
        catch (BuilderException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to build the executable; please verify your configuration.", (Exception)((Object)e));
        }
        if (!this.saveConfig) return;
        try {
            ConfigPersister.getInstance().save(this.configOutfile);
            return;
        }
        catch (ConfigPersisterException e) {
            throw new MojoExecutionException("Cannot save config into a XML file", (Exception)((Object)e));
        }
    }

    private File setupBuildEnvironment() throws MojoExecutionException {
        this.createParentFolder();
        Artifact binaryBits = this.chooseBinaryBits();
        this.retrieveBinaryBits(binaryBits);
        return this.unpackWorkDir(binaryBits);
    }

    private void createParentFolder() {
        File parent;
        if (this.outfile != null && !(parent = this.outfile.getParentFile()).exists()) {
            this.getLog().debug((CharSequence)("Parent " + parent.getPath() + " does not exist, creating it!"));
            boolean created = parent.mkdirs();
            if (created) {
                this.getLog().debug((CharSequence)("Parent " + parent.getPath() + " has been created!"));
            } else {
                this.getLog().warn((CharSequence)("Cannot create parent " + parent.getPath() + "!"));
            }
        }
    }

    private File unpackWorkDir(Artifact artifact) throws MojoExecutionException {
        Artifact localArtifact = this.localRepository.find(artifact);
        if (localArtifact == null || localArtifact.getFile() == null) {
            throw new MojoExecutionException("Cannot obtain file path to " + artifact);
        }
        this.getLog().debug((CharSequence)("Unpacking " + localArtifact + " into " + localArtifact.getFile()));
        File platJar = localArtifact.getFile();
        File dest = platJar.getParentFile();
        File marker = new File(dest, platJar.getName() + ".unpacked");
        String n = platJar.getName();
        File workdir = new File(dest, n.substring(0, n.length() - 4));
        if (marker.exists() && marker.lastModified() > platJar.lastModified()) {
            this.getLog().info((CharSequence)("Platform-specific work directory already exists: " + workdir.getAbsolutePath()));
        } else {
            try (JarFile jf = new JarFile(platJar);){
                Enumeration<JarEntry> en = jf.entries();
                while (en.hasMoreElements()) {
                    JarEntry je = en.nextElement();
                    File outFile = new File(dest, je.getName());
                    File parent = outFile.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    if (je.isDirectory()) {
                        outFile.mkdirs();
                        continue;
                    }
                    try (InputStream in = jf.getInputStream(je);
                         FileOutputStream fout = new FileOutputStream(outFile);){
                        int len;
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) >= 0) {
                            fout.write(buf, 0, len);
                        }
                    }
                    outFile.setLastModified(je.getTime());
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error unarchiving " + platJar, (Exception)e);
            }
            try {
                marker.createNewFile();
                marker.setLastModified(new Date().getTime());
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Trouble creating marker file " + marker), (Throwable)e);
            }
        }
        this.setPermissions(workdir);
        return workdir;
    }

    private void setPermissions(File workdir) {
        if (!System.getProperty("os.name").startsWith("Windows")) {
            try {
                new ProcessBuilder("chmod", "755", workdir + "/bin/ld").start().waitFor();
                new ProcessBuilder("chmod", "755", workdir + "/bin/windres").start().waitFor();
            }
            catch (InterruptedException e) {
                this.getLog().warn((CharSequence)"Interrupted while chmodding platform-specific binaries", (Throwable)e);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Unable to set platform-specific binaries to 755", (Throwable)e);
            }
        }
    }

    private List<String> relativizeAndCopy(File workdir, List<String> paths) throws MojoExecutionException {
        if (paths == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String path : paths) {
            Path source = this.basedir.toPath().resolve(path);
            Path dest = workdir.toPath().resolve(this.basedir.toPath().relativize(source));
            if (!source.startsWith(this.basedir.toPath())) {
                throw new MojoExecutionException("File must reside in the project directory: " + path);
            }
            if (Files.exists(source, new LinkOption[0])) {
                try {
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                    Path target = Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
                    result.add(workdir.toPath().relativize(target).toString());
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Can't copy file to workdir", (Exception)e);
                }
            }
            result.add(path);
        }
        return result;
    }

    private void retrieveBinaryBits(Artifact a) throws MojoExecutionException {
        ProjectBuildingRequest configuration = this.session.getProjectBuildingRequest();
        configuration.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        configuration.setLocalRepository(this.localRepository);
        configuration.setProject(this.session.getCurrentProject());
        this.getLog().debug((CharSequence)("Retrieving artifact: " + a + " stored in " + a.getFile()));
        try {
            this.resolver.resolveArtifact(configuration, a).getArtifact();
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Illegal Argument Exception", (Exception)e);
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Can't retrieve platform-specific components", (Exception)((Object)e));
        }
    }

    private Artifact chooseBinaryBits() throws MojoExecutionException {
        String plat;
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        this.getLog().debug((CharSequence)("OS = " + os));
        this.getLog().debug((CharSequence)("Architecture = " + arch));
        if (os.startsWith("Windows")) {
            plat = "win32";
        } else if ("Linux".equals(os)) {
            plat = "amd64".equals(arch) ? "linux64" : "linux";
        } else if ("Solaris".equals(os) || "SunOS".equals(os)) {
            plat = "solaris";
        } else if ("Mac OS X".equals(os) || "Darwin".equals(os)) {
            plat = "mac";
        } else {
            throw new MojoExecutionException("Sorry, Launch4j doesn't support the '" + os + "' OS.");
        }
        return this.factory.createArtifactWithClassifier(LAUNCH4J_GROUP_ID, LAUNCH4J_ARTIFACT_ID, this.getLaunch4jVersion(), "jar", "workdir-" + plat);
    }

    private File getBaseDir() {
        return this.basedir;
    }

    private void printState() {
        Log log = this.getLog();
        Config c = ConfigPersister.getInstance().getConfig();
        log.debug((CharSequence)("headerType = " + c.getHeaderType()));
        log.debug((CharSequence)("outfile = " + c.getOutfile()));
        log.debug((CharSequence)("jar = " + c.getJar()));
        log.debug((CharSequence)("dontWrapJar = " + c.isDontWrapJar()));
        log.debug((CharSequence)("errTitle = " + c.getErrTitle()));
        log.debug((CharSequence)("downloadUrl = " + c.getDownloadUrl()));
        log.debug((CharSequence)("supportUrl = " + c.getSupportUrl()));
        log.debug((CharSequence)("cmdLine = " + c.getCmdLine()));
        log.debug((CharSequence)("chdir = " + c.getChdir()));
        log.debug((CharSequence)("priority = " + c.getPriority()));
        log.debug((CharSequence)("stayAlive = " + c.isStayAlive()));
        log.debug((CharSequence)("restartOnCrash = " + c.isRestartOnCrash()));
        log.debug((CharSequence)("icon = " + c.getIcon()));
        log.debug((CharSequence)("objs = " + c.getHeaderObjects()));
        log.debug((CharSequence)("libs = " + c.getLibs()));
        log.debug((CharSequence)("vars = " + c.getVariables()));
        if (c.getSingleInstance() != null) {
            log.debug((CharSequence)("singleInstance.mutexName = " + c.getSingleInstance().getMutexName()));
            log.debug((CharSequence)("singleInstance.windowTitle = " + c.getSingleInstance().getWindowTitle()));
        } else {
            log.debug((CharSequence)"singleInstance = null");
        }
        if (c.getJre() != null) {
            log.debug((CharSequence)("jre.path = " + c.getJre().getPath()));
            log.debug((CharSequence)("jre.minVersion = " + c.getJre().getMinVersion()));
            log.debug((CharSequence)("jre.maxVersion = " + c.getJre().getMaxVersion()));
            log.debug((CharSequence)("jre.jdkPreference = " + c.getJre().getJdkPreference()));
            log.debug((CharSequence)("jre.initialHeapSize = " + c.getJre().getInitialHeapSize()));
            log.debug((CharSequence)("jre.initialHeapPercent = " + c.getJre().getInitialHeapPercent()));
            log.debug((CharSequence)("jre.maxHeapSize = " + c.getJre().getMaxHeapSize()));
            log.debug((CharSequence)("jre.maxHeapPercent = " + c.getJre().getMaxHeapPercent()));
            log.debug((CharSequence)("jre.opts = " + c.getJre().getOptions()));
        } else {
            log.debug((CharSequence)"jre = null");
        }
        if (c.getClassPath() != null) {
            log.debug((CharSequence)("classPath.mainClass = " + c.getClassPath().getMainClass()));
        }
        if (this.classPath != null) {
            log.debug((CharSequence)("classPath.addDependencies = " + this.classPath.addDependencies));
            log.debug((CharSequence)("classPath.jarLocation = " + this.classPath.jarLocation));
            log.debug((CharSequence)("classPath.preCp = " + this.classPath.preCp));
            log.debug((CharSequence)("classPath.postCp = " + this.classPath.postCp));
        } else {
            log.info((CharSequence)"classpath = null");
        }
        if (c.getSplash() != null) {
            log.debug((CharSequence)("splash.file = " + c.getSplash().getFile()));
            log.debug((CharSequence)("splash.waitForWindow = " + c.getSplash().getWaitForWindow()));
            log.debug((CharSequence)("splash.timeout = " + c.getSplash().getTimeout()));
            log.debug((CharSequence)("splash.timoutErr = " + c.getSplash().isTimeoutErr()));
        } else {
            log.debug((CharSequence)"splash = null");
        }
        if (c.getVersionInfo() != null) {
            log.debug((CharSequence)("versionInfo.fileVersion = " + c.getVersionInfo().getFileVersion()));
            log.debug((CharSequence)("versionInfo.txtFileVersion = " + c.getVersionInfo().getTxtFileVersion()));
            log.debug((CharSequence)("versionInfo.fileDescription = " + c.getVersionInfo().getFileDescription()));
            log.debug((CharSequence)("versionInfo.copyright = " + c.getVersionInfo().getCopyright()));
            log.debug((CharSequence)("versionInfo.productVersion = " + c.getVersionInfo().getProductVersion()));
            log.debug((CharSequence)("versionInfo.txtProductVersion = " + c.getVersionInfo().getTxtProductVersion()));
            log.debug((CharSequence)("versionInfo.productName = " + c.getVersionInfo().getProductName()));
            log.debug((CharSequence)("versionInfo.companyName = " + c.getVersionInfo().getCompanyName()));
            log.debug((CharSequence)("versionInfo.internalName = " + c.getVersionInfo().getInternalName()));
            log.debug((CharSequence)("versionInfo.originalFilename = " + c.getVersionInfo().getOriginalFilename()));
            log.debug((CharSequence)("versionInfo.language = " + c.getVersionInfo().getLanguage()));
            log.debug((CharSequence)("versionInfo.languageIndex = " + c.getVersionInfo().getLanguageIndex()));
            log.debug((CharSequence)("versionInfo.trademarks = " + c.getVersionInfo().getTrademarks()));
        } else {
            log.debug((CharSequence)"versionInfo = null");
        }
        if (c.getMessages() != null) {
            log.debug((CharSequence)("messages.startupErr = " + c.getMessages().getStartupErr()));
            log.debug((CharSequence)("messages.bundledJreErr = " + c.getMessages().getBundledJreErr()));
            log.debug((CharSequence)("messages.jreVersionErr = " + c.getMessages().getJreVersionErr()));
            log.debug((CharSequence)("messages.launcherErr = " + c.getMessages().getLauncherErr()));
            log.debug((CharSequence)("messages.instanceAlreadyExistsMsg = " + c.getMessages().getInstanceAlreadyExistsMsg()));
        } else {
            log.debug((CharSequence)"messages = null");
        }
    }

    private String getLaunch4jVersion() throws MojoExecutionException {
        String version = null;
        for (Artifact artifact : this.pluginArtifacts) {
            if (!LAUNCH4J_GROUP_ID.equals(artifact.getGroupId()) || !LAUNCH4J_ARTIFACT_ID.equals(artifact.getArtifactId()) || !"core".equals(artifact.getClassifier())) continue;
            version = artifact.getVersion();
            this.getLog().debug((CharSequence)("Found launch4j version " + version));
            break;
        }
        if (version == null) {
            throw new MojoExecutionException("Impossible to find which Launch4j version to use");
        }
        return version;
    }
}

