/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.edgegrid.signer;

import com.akamai.edgegrid.signer.ClientCredential;
import com.akamai.edgegrid.signer.ClientCredentialProvider;
import com.akamai.edgegrid.signer.Request;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class EdgeRcClientCredentialProvider
implements ClientCredentialProvider {
    private final INIConfiguration configuration;
    private final String defaultSectionName;

    public static EdgeRcClientCredentialProvider fromEdgeRc(File file, String section) throws ConfigurationException, IOException {
        Objects.requireNonNull(file, "file cannot be null");
        return EdgeRcClientCredentialProvider.fromEdgeRc(new FileReader(file), section);
    }

    public static EdgeRcClientCredentialProvider fromEdgeRc(InputStream inputStream, String section) throws ConfigurationException, IOException {
        Objects.requireNonNull(inputStream, "inputStream cannot be null");
        return EdgeRcClientCredentialProvider.fromEdgeRc(new InputStreamReader(inputStream), section);
    }

    public static EdgeRcClientCredentialProvider fromEdgeRc(Reader reader, String section) throws ConfigurationException, IOException {
        Objects.requireNonNull(reader, "reader cannot be null");
        return new EdgeRcClientCredentialProvider(reader, section);
    }

    public static EdgeRcClientCredentialProvider fromEdgeRc(String filename, String section) throws ConfigurationException, IOException {
        if (filename == null || "".equals(filename)) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        filename = filename.replaceFirst("^~", System.getProperty("user.home"));
        File file = new File(filename);
        return EdgeRcClientCredentialProvider.fromEdgeRc(new FileReader(file), section);
    }

    public EdgeRcClientCredentialProvider(Reader reader, String section) throws ConfigurationException, IOException {
        Objects.requireNonNull(reader, "reader cannot be null");
        this.configuration = new INIConfiguration();
        this.configuration.read(reader);
        this.defaultSectionName = section;
    }

    public ClientCredential getClientCredential(Request request) {
        String sectionName = this.pickSectionName(request);
        return this.getClientCredential(sectionName);
    }

    protected ClientCredential getClientCredential(String sectionName) {
        String headersString;
        SubnodeConfiguration s = this.configuration.getSection(sectionName);
        ClientCredential.ClientCredentialBuilder builder = ClientCredential.builder().accessToken(s.getString("access_token")).clientSecret(s.getString("client_secret")).clientToken(s.getString("client_token")).host(s.getString("host"));
        if (s.getInteger("max-body", null) != null) {
            builder.maxBodySize(s.getInteger("max-body", null).intValue());
        }
        if ((headersString = s.getString("headers_to_sign")) != null && !"".equals(headersString)) {
            for (String h : headersString.split(",")) {
                builder.headerToSign(h);
            }
        }
        return builder.build();
    }

    protected String pickSectionName(Request request) {
        return this.defaultSectionName;
    }
}

