/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.edgegrid.signer.apachehttpclient;

import com.akamai.edgegrid.signer.AbstractEdgeGridRequestSigner;
import com.akamai.edgegrid.signer.ClientCredential;
import com.akamai.edgegrid.signer.ClientCredentialProvider;
import com.akamai.edgegrid.signer.Request;
import java.io.IOException;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClientEdgeGridRequestSigner
extends AbstractEdgeGridRequestSigner<HttpRequest, HttpRequest> {
    public ApacheHttpClientEdgeGridRequestSigner(ClientCredential clientCredential) {
        super(clientCredential);
    }

    public ApacheHttpClientEdgeGridRequestSigner(ClientCredentialProvider clientCredentialProvider) {
        super(clientCredentialProvider);
    }

    protected URI requestUri(HttpRequest request) {
        if (request instanceof HttpRequestWrapper) {
            String uri = ((HttpRequestWrapper)request).getOriginal().getRequestLine().getUri();
            return URI.create(uri);
        }
        if (request instanceof RequestWrapper) {
            String uri = ((RequestWrapper)request).getOriginal().getRequestLine().getUri();
            return URI.create(uri);
        }
        return ((HttpRequestBase)request).getURI();
    }

    protected Request map(HttpRequest request) {
        Request.RequestBuilder builder = Request.builder().method(request.getRequestLine().getMethod()).uri(request.getRequestLine().getUri()).body(this.serializeContent(request));
        for (Header h : request.getAllHeaders()) {
            builder.header(h.getName(), h.getValue());
        }
        return builder.build();
    }

    private byte[] serializeContent(HttpRequest request) {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            return new byte[0];
        }
        HttpEntityEnclosingRequest entityWithRequest = (HttpEntityEnclosingRequest)request;
        HttpEntity entity = entityWithRequest.getEntity();
        if (entity == null) {
            return new byte[0];
        }
        try {
            if (!entity.isRepeatable()) {
                entityWithRequest.setEntity((HttpEntity)new BufferedHttpEntity(entity));
            }
            return EntityUtils.toByteArray((HttpEntity)entityWithRequest.getEntity());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setAuthorization(HttpRequest request, String signature) {
        request.setHeader("Authorization", signature);
    }

    protected void setHost(HttpRequest request, String host, URI uri) {
        request.setHeader("Host", host);
        this.setRequestUri(request, uri);
    }

    private void setRequestUri(HttpRequest request, URI uri) {
        if (request instanceof HttpRequestWrapper) {
            this.setRequestUri(((HttpRequestWrapper)request).getOriginal(), uri);
        } else if (request instanceof RequestWrapper) {
            this.setRequestUri(((RequestWrapper)request).getOriginal(), uri);
        } else {
            ((HttpRequestBase)request).setURI(uri);
        }
    }
}

