/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import android.os.Build;
import com.akamai.android.sdk.net.AkaNetUtils;
import com.akamai.android.sdk.net.AkaURLConnection;
import com.akamai.android.sdk.net.DnsHandler;
import com.akamai.android.sdk.net.IDNSWrapper;
import com.akamai.android.sdk.net.MultiPathRequest;
import com.akamai.android.sdk.net.VocAccelerator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

class AkaResolver {
    private static final String TAG = "AkaResolver";
    private final MultiPathRequest mParent;
    private final String mHost;
    private List<String> mPrimaryResults;
    private List<String> mSecondaryResults;
    private volatile transient boolean mIsWinnerSelected;
    private volatile transient boolean mIsSecondaryAvailable;
    private int mErrorCount = 0;
    private boolean mAAAANotFound;
    private IOException mResolveException;
    private final Object mLock = new Object();
    private static final int MAX_WAIT_AAAA_LOOKUP_IN_MS = 25;
    private boolean mIsPrimaryAAAA;
    private boolean mIsSecondaryAAAA;
    private static final ResolverCache LOCAL_DNS_CACHE = new ResolverCache(10);
    private static final ResolverCache SECONDARY_DNS_CACHE = new ResolverCache(10);

    public AkaResolver(MultiPathRequest multiPathRequest, String string) {
        this.mParent = multiPathRequest;
        this.mHost = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        Object object;
        Object object2;
        Object object3;
        int n2 = Build.VERSION.SDK_INT;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.mParent.mDNS;
        if (this.mParent.mDNSType == 1) {
            object3 = VocAccelerator.getInstance().getNetUtils();
            object2 = ((AkaNetUtils)object3).getLocalDns();
            if (((String)object2).isEmpty() || n2 < 21) {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(this.mHost);
                if (inetAddressArray != null) {
                    for (InetAddress inetAddress : inetAddressArray) {
                        arrayList.add(inetAddress.getHostAddress());
                    }
                }
                this.mPrimaryResults = arrayList;
                this.mIsSecondaryAvailable = true;
                return;
            }
            string = object2;
        }
        if (this.mParent.mDNSType == 1) {
            object3 = LOCAL_DNS_CACHE.getIp(this.mHost, 28);
            object2 = LOCAL_DNS_CACHE.getIp(this.mHost, 1);
        } else {
            object3 = SECONDARY_DNS_CACHE.getIp(this.mHost, 28);
            object2 = SECONDARY_DNS_CACHE.getIp(this.mHost, 1);
        }
        if (object3 == null) {
            AkaURLConnection.sThreadPool.submit(new DNSResolver(string, 28));
        } else {
            object = new DNSResolver(string, 28);
            ((DNSResolver)object).mResult = object3;
            ((DNSResolver)object).mLookupResult = !object3.isEmpty() ? 0 : 4;
            this.onResolutionCompletion((DNSResolver)object);
        }
        if (object2 == null) {
            AkaURLConnection.sThreadPool.submit(new DNSResolver(string, 1));
        } else {
            object = new DNSResolver(string, 1);
            ((DNSResolver)object).mResult = object2;
            ((DNSResolver)object).mLookupResult = !object2.isEmpty() ? 0 : 4;
            this.onResolutionCompletion((DNSResolver)object);
        }
        object = this;
        synchronized (object) {
            while (!this.mIsWinnerSelected) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public List<String> getPrimaryResults() {
        if (this.mPrimaryResults == null) {
            return new ArrayList<String>(0);
        }
        return this.mPrimaryResults;
    }

    public boolean isPrimaryAAAA() {
        return this.mIsPrimaryAAAA;
    }

    public boolean isSecondaryAAAA() {
        return this.mIsSecondaryAAAA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSecondaryResults() throws IOException {
        AkaResolver akaResolver = this;
        synchronized (akaResolver) {
            while (!this.mIsSecondaryAvailable) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.mSecondaryResults == null) {
            if (this.mResolveException != null) {
                throw this.mResolveException;
            }
            return new ArrayList<String>(0);
        }
        return this.mSecondaryResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResolutionCompletion(DNSResolver dNSResolver) {
        boolean bl2;
        boolean bl3 = bl2 = dNSResolver.mLookupType == 28;
        if (!dNSResolver.mResult.isEmpty()) {
            boolean bl4;
            Object object;
            if (!bl2) {
                object = this;
                synchronized (object) {
                    bl4 = this.mIsWinnerSelected;
                }
                if (!bl4) {
                    object = this.mLock;
                    synchronized (object) {
                        if (!this.mAAAANotFound) {
                            try {
                                this.mLock.wait(25L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            bl4 = false;
            object = this;
            synchronized (object) {
                if (!this.mIsWinnerSelected) {
                    this.mIsWinnerSelected = true;
                    bl4 = true;
                    this.mIsPrimaryAAAA = bl2;
                    this.mPrimaryResults = dNSResolver.mResult;
                    this.notifyAll();
                }
            }
            if (!bl4) {
                object = this;
                synchronized (object) {
                    this.mSecondaryResults = dNSResolver.mResult;
                    this.mIsSecondaryAAAA = bl2;
                    this.mIsSecondaryAvailable = true;
                    this.notifyAll();
                }
            } else if (bl2) {
                object = this.mLock;
                synchronized (object) {
                    this.mLock.notifyAll();
                }
            }
        } else {
            Object object;
            if (bl2 && dNSResolver.mLookupResult == 4) {
                object = this.mLock;
                synchronized (object) {
                    this.mAAAANotFound = true;
                    this.mLock.notifyAll();
                }
            }
            object = this;
            synchronized (object) {
                ++this.mErrorCount;
                this.mIsSecondaryAvailable = true;
                if (this.mResolveException == null && dNSResolver.mException != null) {
                    this.mResolveException = dNSResolver.mException;
                }
                if (this.mErrorCount == 2) {
                    this.mIsWinnerSelected = true;
                }
                this.notifyAll();
            }
        }
    }

    private static class ResolverCache {
        private final ConcurrentHashMap<CacheKey, CacheValue> mCache;
        static final long DEFAULT_TTL_ERROR_CASES = TimeUnit.SECONDS.toMillis(10L);

        ResolverCache(int n2) {
            this.mCache = new ConcurrentHashMap(n2);
        }

        void add(String string, int n2, List<String> list, long l2) {
            CacheKey cacheKey = new CacheKey(string, n2);
            CacheValue cacheValue = new CacheValue(list, System.currentTimeMillis() + l2);
            this.mCache.put(cacheKey, cacheValue);
        }

        List<String> getIp(String string, int n2) {
            if (n2 == 28 && !VocAccelerator.getInstance().getNetUtils().isIPv6Supported()) {
                return new ArrayList<String>();
            }
            long l2 = System.currentTimeMillis();
            CacheKey cacheKey = new CacheKey(string, n2);
            CacheValue cacheValue = this.mCache.get(cacheKey);
            if (cacheValue != null && cacheValue.expiry >= l2) {
                return cacheValue.ipList;
            }
            return null;
        }

        private class CacheKey {
            final String host;
            final int dnsType;

            CacheKey(String string, int n2) {
                this.host = string;
                this.dnsType = n2;
            }

            public int hashCode() {
                String string = this.host + "/" + this.dnsType;
                return string.hashCode();
            }

            public boolean equals(Object object) {
                if (object == null || !(object instanceof CacheKey)) {
                    return false;
                }
                CacheKey cacheKey = (CacheKey)object;
                return this.host.equals(cacheKey.host) && this.dnsType == cacheKey.dnsType;
            }
        }

        private class CacheValue {
            final List<String> ipList;
            final long expiry;

            CacheValue(List<String> list, long l2) {
                this.ipList = list;
                this.expiry = l2;
            }
        }
    }

    private class DNSResolver
    implements Runnable {
        final String mDns;
        final int mLookupType;
        List<String> mResult;
        IOException mException;
        int mLookupResult = -1;

        DNSResolver(String string, int n2) {
            this.mDns = string;
            this.mLookupType = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.mResult = new ArrayList<String>(2);
            try {
                IDNSWrapper iDNSWrapper = DnsHandler.sDNSWrapperImpl;
                if (iDNSWrapper == null) {
                    AkaURLConnection.sIsDNSLibraryPresent = false;
                    return;
                }
                DnsHandler.LookupResponse lookupResponse = iDNSWrapper.getResponse(AkaResolver.this.mHost, this.mLookupType, this.mDns);
                DnsHandler.Record[] recordArray = lookupResponse.records;
                if (recordArray != null) {
                    long l2 = Long.MIN_VALUE;
                    for (DnsHandler.Record record : recordArray) {
                        this.mResult.add(record.ip);
                        long l3 = record.ttl;
                        if (l3 <= l2) continue;
                        l2 = l3;
                    }
                    if (l2 > 0L) {
                        this.addResultsToCache(TimeUnit.SECONDS.toMillis(l2));
                    }
                } else {
                    this.mLookupResult = lookupResponse.lookupResult;
                    if (this.mLookupResult == 3) {
                        throw new UnknownHostException("Unable to resolve host: " + AkaResolver.this.mHost);
                    }
                    if (this.mLookupResult == 4) {
                        this.addResultsToCache(ResolverCache.DEFAULT_TTL_ERROR_CASES);
                    }
                }
            }
            catch (IOException iOException) {
                this.mException = iOException;
            }
            finally {
                AkaResolver.this.onResolutionCompletion(this);
            }
        }

        private void addResultsToCache(final long l2) {
            VocAccelerator.getInstance().submitTask(new Runnable(){

                @Override
                public void run() {
                    if (((AkaResolver)AkaResolver.this).mParent.mDNSType == 1) {
                        LOCAL_DNS_CACHE.add(AkaResolver.this.mHost, DNSResolver.this.mLookupType, DNSResolver.this.mResult, l2);
                    } else {
                        SECONDARY_DNS_CACHE.add(AkaResolver.this.mHost, DNSResolver.this.mLookupType, DNSResolver.this.mResult, l2);
                    }
                }
            });
        }
    }
}

