/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import androidx.annotation.Keep;
import com.akamai.android.annotations.AkamaiInternal;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.internal.AkaBackgroundService;
import com.akamai.android.sdk.util.AnaUtils;

@AkamaiInternal
@Keep
public class AnaBroadcastReceiver
extends BroadcastReceiver {
    private final Handler mHandler = new Handler();
    private static final long SERVICE_START_DELAY = 300000L;
    private static final String LOG_TAG = "AnaBroadcastReceiver";

    @AkamaiInternal
    @Keep
    public void onReceive(final Context context, Intent intent) {
        String string = intent.getAction();
        if (string != null) {
            switch (string) {
                case "android.net.wifi.STATE_CHANGE": {
                    NetworkInfo networkInfo;
                    ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                    NetworkInfo networkInfo2 = networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
                    if (networkInfo == null || !networkInfo.isConnected() || networkInfo.getType() != 1) break;
                    this.mHandler.postDelayed((Runnable)new Thread(){

                        @Override
                        public void run() {
                            if (AnaUtils.isWifiConnected()) {
                                AnaBroadcastReceiver.this.startService(context, "");
                            }
                        }
                    }, 300000L);
                    break;
                }
                case "android.intent.action.ACTION_POWER_CONNECTED": {
                    this.startService(context, "");
                    break;
                }
                case "com.google.android.c2dm.intent.RECEIVE": {
                    String string2 = "";
                    if (intent.hasExtra("mapsdk")) {
                        string2 = intent.getStringExtra("mapsdk");
                        Logger.dd((String)("AnaBroadcastReceiver: Gcm rcv Prepare sync " + string2), (Object[])new Object[0]);
                        this.startService(context, string2);
                        break;
                    }
                    Logger.dd((String)"AnaBroadcastReceiver: Not a sdk Gcm, skipping", (Object[])new Object[0]);
                }
            }
        }
    }

    private void startService(Context context, String string) {
        AkaBackgroundService.getInstance(context).performFullSync(context, string);
    }
}

