/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.net;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.internal.AkaNetworkQualityHandler;
import com.akamai.android.sdk.internal.AnaNetworkQualityStatus;
import com.akamai.android.sdk.util.AnaUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.json.JSONArray;

public class AkaMultiPathHandler {
    private static final String LOG_TAG = "MPathHandler";
    private final Context mContext;
    private final CopyOnWriteArrayList<Pattern> mPatternList;
    private final SharedPreferences mPreferences;
    private String mPrefs_urlList = "";
    private static final int METHOD_CANCEL_LOSER = 0;
    public static final int METHOD_DOWNLD_ALL = 1;
    public static final int METHOD_USE_WINNING_IP = 2;
    public static final int METHOD_GHOST_ABORT = 3;
    public static final int METHOD_NO_DISTINCT_IP = 4;
    private final ConcurrentHashMap<String, WinnerIP> mWinningIP;
    private final ConcurrentHashMap<String, String> mInProgressRaces;

    public AkaMultiPathHandler(Context context) {
        this.mContext = context.getApplicationContext();
        this.mPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        this.mPatternList = new CopyOnWriteArrayList();
        this.mWinningIP = new ConcurrentHashMap();
        this.mInProgressRaces = new ConcurrentHashMap();
        this.initPatterns();
    }

    public synchronized void initPatterns() {
        String string = this.mPreferences.getString("url_list", "");
        if (!string.equals(this.mPrefs_urlList)) {
            this.mPrefs_urlList = string;
            try {
                JSONArray jSONArray = new JSONArray(string);
                this.mPatternList.clear();
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    String string2 = "";
                    try {
                        string2 = jSONArray.getString(i2);
                        this.mPatternList.add(Pattern.compile(string2));
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.e((String)"AkaSdkLogger-map", (String)("MPathHandler: Invalid pattern: " + string2), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"MPathHandler: initPattern", (Throwable)exception);
            }
        }
    }

    public String getCompiledPatternList() {
        if (this.mPatternList != null) {
            return this.mPatternList.toString();
        }
        return "";
    }

    void addWinner(String string, String string2, int n2) {
        int n3 = this.mPreferences.getInt("stickyTime", 0);
        if (n3 > 0) {
            this.mWinningIP.put(string, new WinnerIP(string2, System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(n3), n2));
        }
    }

    WinnerIP getWinningIp(String string) {
        WinnerIP winnerIP = this.mWinningIP.get(string);
        if (winnerIP != null && !TextUtils.isEmpty((CharSequence)winnerIP.ip) && winnerIP.expiry >= System.currentTimeMillis()) {
            return winnerIP;
        }
        return null;
    }

    void markRaceInProgress(String string) {
        try {
            this.mInProgressRaces.put(string, string);
        }
        catch (Exception exception) {
            Logger.dd((String)"AkaSdkLogger-map", (String)("unable to mark race in progress " + exception.getMessage()));
        }
    }

    boolean isRaceInProgress(String string) {
        try {
            return this.mInProgressRaces.contains(string);
        }
        catch (Exception exception) {
            Logger.dd((String)"AkaSdkLogger-map", (String)("unable to check race in progress " + exception.getMessage()));
            return false;
        }
    }

    void clearRaceInProgress(String string) {
        try {
            this.mInProgressRaces.remove(string);
        }
        catch (Exception exception) {
            Logger.dd((String)"AkaSdkLogger-map", (String)("unable to remove host from set " + exception.getMessage()));
        }
    }

    void clearWinnerIps() {
        this.mWinningIP.clear();
    }

    void removeWinningIp(String string) {
        this.mWinningIP.remove(string);
    }

    boolean match(String string) {
        if (!this.mPatternList.isEmpty()) {
            for (Pattern pattern : this.mPatternList) {
                if (!pattern.matcher(string).find()) continue;
                return true;
            }
        }
        return false;
    }

    int selectMethod() {
        AnaNetworkQualityStatus anaNetworkQualityStatus = AkaNetworkQualityHandler.getNetworkQuality(this.mContext);
        if (anaNetworkQualityStatus.networkQuality == 0) {
            if (!(anaNetworkQualityStatus.networkType != 0 || anaNetworkQualityStatus.networkSubType != 0 && AnaUtils.is3GAndAbove(this.mContext, anaNetworkQualityStatus.networkSubType))) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    protected class WinnerIP {
        final String ip;
        final long expiry;
        final int ipType;

        WinnerIP(String string, long l2, int n2) {
            this.ip = string;
            this.expiry = l2;
            this.ipType = n2;
        }
    }
}

