/*
 * Decompiled with CFR 0.152.
 */
package com.akamai.android.sdk.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.location.Location;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.text.format.DateUtils;
import com.akamai.android.AkaLogger;
import com.akamai.android.sdk.Logger;
import com.akamai.android.sdk.db.AnaProviderContract;
import com.akamai.android.sdk.internal.AkaSSLWrapper;
import com.akamai.android.sdk.internal.AkaSessionHandler;
import com.akamai.android.sdk.internal.AkaWebAnalyticsRecord;
import com.akamai.android.sdk.internal.AnaDownloadPolicyManager;
import com.akamai.android.sdk.internal.AnaWebDebugRecord;
import com.akamai.android.sdk.net.AkaHttpUtils;
import com.akamai.android.sdk.net.VocAccelerator;
import com.akamai.android.sdk.util.AnaUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AkaWebAnalyticsHandler {
    private static final String LOG_TAG = "AkaWebAnalyticsHandler";
    private static final String PLATFORM = "platform";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String PLATFORM_TYPE = "Android";
    private static final String VERSION = "version";
    private static final String HOST_APP_VERSION = "hostAppVersion";
    private static final String STATS_DOWNLOAD_TYPE = "type";
    private static final String STATS_TIMESTAMP = "timeStamp";
    private static final String STATS_TTFB = "ttfb";
    private static final String STATS_BATTERYLEVEL = "batteryLevel";
    private static final String STATS_ISCHARGING = "isCharging";
    private static final String STATS_CONNECTION_TYPE = "connectionType";
    private static final String STATS_RESPONSE_CODE = "responseCode";
    private static final String STATS_REQUEST_HEADER_SZ = "requestHeaderSize";
    private static final String STATS_RESPONSE_HEADER_SZ = "responseHeaderSize";
    private static final String STATS_CONTENT_LENGTH = "contentLength";
    private static final String STATS_MIME_TYPE = "mimeType";
    private static final String STATS_MP_TYPE = "mpType";
    private static final String STATS_MP_WINNER = "mpWinner";
    private static final String STATS_MP_METHOD = "mpMethod";
    private static final String STATS_SERVER_PROFILE = "serverProfile";
    private static final String STATS_AMC_ID = "amcId";
    private static final String STATS_QUIC_ENABLED = "isQuic";
    private static final String STATS_REQUEST_TYPE = "requestType";
    private static final String STATS_IP_V4_TRIES = "v4Tries";
    private static final String STATS_IP_V6_TRIES = "v6Tries";
    private static final String STATS_CONTENT_LENGTH_HEADER = "contentLengthHeader";
    private static final String STATS_MAX_RWND = "maxRwnd";
    private static final String STATS_CACHEABLE = "cacheable";
    private static final String STATS_SESSIONS_ID = "sessionId";
    private static final String STATS_PRECACHED = "precached";
    private static final String STATS_REDIRECTED = "redirected";
    private static final String STATS_EVENT_NAME = "name";
    private static final String STATS_START_TIME = "startTime";
    private static final String STATS_STOP_TIME = "stopTime";
    private static final String STATS_TPRESULT = "tpResult";
    private static final String STATS_EXCEPTION = "error";
    private static final long HTTPSTATS_INVALID_DURATION_MILLISECS = 600000L;
    private static final String SESSION_LENGTH = "sessionLength";
    private static final String CARRIER = "carrier";
    private static final String URL_LIST = "urlList";
    private static final String USER_EVENTS = "userEvents";
    private static final String LOG_EVENTS = "logEvents";
    private static final String SDK_EVENTS = "sdkEvents";
    private static final String DEBUG_RECORD = "debug_record";
    private static final String STATS_BROTLI_USED = "isBrotliUsed";
    private static final int HTTP_SUCCESS = 200;
    private static final String CELL_PARAMS = "cellParams";
    private static final String AB_GROUPS = "abGroups";
    private static final String UNIQUE_ID = "uniqueId";
    private static final String DOWNLOAD_DURATION = "duration";
    private static final String LOCATION = "location";
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";
    private static final String ACCURACY = "accuracy";
    private static final String GEO_LOCATION = "geolocation";
    private static final String URL = "url";
    private static final String QUIC = "quic";
    private static final String AIC = "aic";
    private static final String IMAGE_MANAGER = "imageManager";
    private static final String NETWORK_QUALITY = "networkQuality";
    private static final String MASTER_AB = "masterAb";
    private static final String MASTER_ENABLED = "masterEnabled";
    private static final String UNIVERSAL_CACHE = "universalCache";
    private static final String TCP_OPTIMIZATION = "tcpOptimization";
    private static final String MULTIPATH = "multiPath";
    private static final String RAT_TYPE = "ratType";
    private static final String CELL_MCC = "mcc";
    private static final String CELL_MNC = "mnc";
    private static final String CELL_LAC = "lac";
    private static final String CELL_ID = "cellId";
    private static final String SIGNAL_STRENGTH = "sgs";
    private static final String BROTLI = "brotli";
    private static final String FGSEGMENTS = "fgSegments";
    private static final String SERVER_STATE = "serverState";
    private static final String EVENT_ID = "event_id";
    private static final long ANALYTICS_EXPIRY_TIME_MILLIS = TimeUnit.DAYS.toMillis(7L);
    private static final String EMP_VOC_CERT_NAME = "empvoc-api.akamai.com";
    private static final String SHARED_FE_ENVIRONMENT = "shared-fe.pvoc-anaina.com";
    private static final HostnameVerifier NON_PROD_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return "production".equals("dev") && AkaWebAnalyticsHandler.SHARED_FE_ENVIRONMENT.equals(string) || "production".equals("mock") && string.equals("127.0.0.1");
        }
    };
    private static boolean sIsSendingWebAnalytics;
    private final Context mContext;

    private AkaWebAnalyticsHandler(Context context) {
        this.mContext = context;
    }

    public static void sendWebAnalytics(Context context) {
        AnaDownloadPolicyManager anaDownloadPolicyManager = new AnaDownloadPolicyManager(context);
        AkaWebAnalyticsHandler akaWebAnalyticsHandler = new AkaWebAnalyticsHandler(context);
        if (anaDownloadPolicyManager.isDownloadPermitted() == 0) {
            akaWebAnalyticsHandler.sendWebAccAnalytics(false);
        } else {
            akaWebAnalyticsHandler.sendWebAccAnalyticsOOP();
        }
    }

    private void sendWebAccAnalyticsOOP() {
        boolean bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("upload_analytics_oop", true);
        if (!bl2) {
            return;
        }
        this.sendWebAccAnalytics(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWebAccAnalytics(boolean bl2) {
        boolean bl3 = VocAccelerator.getInstance().getSecurePreferenceBoolean("log_analytics", false);
        Logger.dd((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: capture analytics: " + bl3));
        if (!bl3 || AkaWebAnalyticsHandler.isSendingWebAnalytics()) {
            return;
        }
        AkaWebAnalyticsHandler.setSendingWebAnalytics(true);
        try {
            AkaWebAnalyticsHandler.deleteOldStats(true, this.mContext);
            boolean bl4 = false;
            int n2 = 1;
            boolean bl5 = VocAccelerator.getInstance().getSecurePreferenceBoolean("debug_logs", false);
            while (!bl4) {
                Logger.d((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: sendWebAccAnalytics: Preparing batch#" + n2));
                AkaWebAnalyticsRecord akaWebAnalyticsRecord = new AkaWebAnalyticsRecord();
                if (bl5) {
                    akaWebAnalyticsRecord.setDebugRecord(AnaWebDebugRecord.getDebugRecord(this.mContext));
                    bl5 = false;
                }
                if (AkaWebAnalyticsHandler.sendDailyUsageAnalytics(this.mContext)) {
                    akaWebAnalyticsRecord.setSdkEventRecordData(this.getSdkEventStat());
                }
                akaWebAnalyticsRecord.setHttpRecordData(this.getHttpStats(akaWebAnalyticsRecord.getHttpRecordIds(), akaWebAnalyticsRecord.spaceLeft()));
                if (!akaWebAnalyticsRecord.isFull()) {
                    akaWebAnalyticsRecord.setUserEventRecordData(this.getUserEventStats(akaWebAnalyticsRecord.getUserEventRecordIds(), akaWebAnalyticsRecord.spaceLeft()));
                    if (!akaWebAnalyticsRecord.isFull()) {
                        akaWebAnalyticsRecord.setLogEventRecordData(this.getLogEventStats(akaWebAnalyticsRecord.getLogEventRecordIds(), akaWebAnalyticsRecord.spaceLeft()));
                    }
                }
                ++n2;
                if (akaWebAnalyticsRecord.isEmpty()) {
                    AkaLogger.in((String)"AkaSdkLogger-map", (String)"AkaWebAnalyticsHandler Nothing available to send");
                    break;
                }
                if (!this.sendWebAccAnalytics(akaWebAnalyticsRecord)) {
                    break;
                }
                bl4 = !akaWebAnalyticsRecord.isFull() || bl2;
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: Exception in sendWebAccAnalytics, error message = " + exception.getMessage()));
        }
        finally {
            AkaWebAnalyticsHandler.setSendingWebAnalytics(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendWebAccAnalytics(AkaWebAnalyticsRecord akaWebAnalyticsRecord) {
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        boolean bl2 = false;
        try {
            URL uRL = new URL(AkaSessionHandler.getAnalyticsUploadUrl(this.mContext));
            httpURLConnection = (HttpsURLConnection)uRL.openConnection();
            if (httpURLConnection != null) {
                String string;
                httpURLConnection.setDoInput(true);
                httpURLConnection.setConnectTimeout(3000);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("Content-Type", "application/json");
                httpURLConnection.setRequestProperty("Content-Encoding", "gzip");
                if (!"production".equals("production")) {
                    ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(AkaSSLWrapper.getPinnedSSLSocketFactory(this.mContext));
                    ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(NON_PROD_HOSTNAME_VERIFIER);
                }
                AkaHttpUtils.setControlPathHeaders((HttpsURLConnection)httpURLConnection);
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(VERSION, (Object)AnaUtils.getBuildVersion());
                jSONObject.put(HOST_APP_VERSION, (Object)AnaUtils.getHostAppVersion(this.mContext));
                jSONObject.put(PLATFORM, (Object)PLATFORM_TYPE);
                jSONObject.put(DEVICE_TYPE, (Object)(Build.MODEL + " " + Build.VERSION.RELEASE));
                jSONObject.put(CELL_PARAMS, (Object)this.getCellParams());
                jSONObject.put(AB_GROUPS, (Object)this.getAbGroups());
                String string2 = this.getEventId();
                if (!string2.isEmpty()) {
                    jSONObject.put(EVENT_ID, (Object)string2);
                } else {
                    Logger.e((String)"AkaSdkLogger-map", (String)"First use is not send and even id is not getting send.");
                }
                if (TextUtils.isEmpty((CharSequence)AkaSessionHandler.getLicenseHash())) {
                    jSONObject.put(SERVER_STATE, (Object)AkaWebAnalyticsHandler.getOldServerState(this.mContext));
                } else {
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("sdkHash", (Object)AkaSessionHandler.getLicenseHash());
                    jSONObject2.put("sdkKey", (Object)AkaSessionHandler.getLicense(this.mContext));
                    jSONObject2.put("appId", (Object)this.mContext.getPackageName());
                    jSONObject.put(SERVER_STATE, (Object)jSONObject2);
                }
                boolean bl3 = VocAccelerator.getInstance().getSecurePreferenceBoolean("store_session", false);
                Logger.dd((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: capture session length: " + bl3));
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                if (bl3) {
                    jSONObject.put(SESSION_LENGTH, this.getSessionLength(arrayList));
                }
                boolean bl4 = VocAccelerator.getInstance().getSecurePreferenceBoolean("get_carrier", false);
                Logger.dd((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: get carrier info: " + bl4));
                if (bl4) {
                    string = AnaUtils.getCarrier(this.mContext);
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        jSONObject.put(CARRIER, (Object)string);
                    } else {
                        Logger.dd((String)"AkaSdkLogger-map", (String)"AkaWebAnalyticsHandler: Unable to get carrier info.");
                    }
                }
                jSONObject.put(URL_LIST, (Object)akaWebAnalyticsRecord.getHttpRecordData());
                jSONObject.put(USER_EVENTS, (Object)akaWebAnalyticsRecord.getUserEventRecordData());
                jSONObject.put(LOG_EVENTS, (Object)akaWebAnalyticsRecord.getLogEventRecordData());
                string = akaWebAnalyticsRecord.getSdkEventRecordData();
                if (string != null) {
                    jSONObject.put(SDK_EVENTS, (Object)string);
                }
                if (akaWebAnalyticsRecord.getDebugRecord() != null) {
                    jSONObject.put(DEBUG_RECORD, (Object)akaWebAnalyticsRecord.getDebugRecord().getJSONObject());
                }
                AkaLogger.in((String)"AkaSdkLogger-map", (String)jSONObject.toString());
                byte[] byArray = AkaWebAnalyticsHandler.gzipString(jSONObject.toString());
                Logger.dd((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: upload sz " + byArray.length));
                int n2 = byArray.length;
                httpURLConnection.setFixedLengthStreamingMode(n2);
                outputStream = httpURLConnection.getOutputStream();
                outputStream.write(byArray);
                outputStream.flush();
                outputStream.close();
                httpURLConnection.connect();
                int n3 = httpURLConnection.getResponseCode();
                Logger.d((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: sendWebAccAnalytics: " + n3));
                if (n3 == 200) {
                    SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
                    int n4 = sharedPreferences.getInt("http_stats_count", 0) + akaWebAnalyticsRecord.getHttpRecordData().length();
                    int n5 = sharedPreferences.getInt("log_events_count", 0) + akaWebAnalyticsRecord.getLogEventRecordData().length();
                    int n6 = sharedPreferences.getInt("user_events_count", 0) + akaWebAnalyticsRecord.getUserEventRecordData().length();
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putInt("http_stats_count", n4);
                    editor.putInt("log_events_count", n5);
                    editor.putInt("user_events_count", n6);
                    editor.putLong("lastanalyticsupload_ts", System.currentTimeMillis());
                    editor.remove("high_ttfb_1");
                    editor.remove("high_ttfb_5");
                    if (string != null) {
                        editor.putLong("lastsdkeventupload_ts", System.currentTimeMillis());
                    }
                    editor.apply();
                    Logger.d((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: Clearing stats...: " + akaWebAnalyticsRecord));
                    this.deleteStats(arrayList, akaWebAnalyticsRecord);
                    bl2 = true;
                } else {
                    Logger.e((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: Analytics upload failure " + n3 + ", response:"));
                }
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)"AkaWebAnalyticsHandler: Exception sending analytics to server", (Throwable)exception);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception) {
                Logger.e((String)"AkaSdkLogger-map", (String)"AkaWebAnalyticsHandler:  Unable to close the connection", (Throwable)exception);
            }
        }
        return bl2;
    }

    private void deleteStats(List<Integer> list, AkaWebAnalyticsRecord akaWebAnalyticsRecord) {
        try {
            String string;
            if (!list.isEmpty()) {
                string = this.getSelectionClauseByName("_id", list);
                this.mContext.getContentResolver().delete(AnaProviderContract.ACTIVITY_SESSION_STATS_URI, string, null);
            }
            if (!akaWebAnalyticsRecord.getHttpRecordIds().isEmpty()) {
                string = this.getSelectionClauseByName("_id", akaWebAnalyticsRecord.getHttpRecordIds());
                this.mContext.getContentResolver().delete(AnaProviderContract.HTTP_CONSUMPTION_STATS_URI, string, null);
            }
            if (!akaWebAnalyticsRecord.getUserEventRecordIds().isEmpty()) {
                string = this.getSelectionClauseByName("_id", akaWebAnalyticsRecord.getUserEventRecordIds());
                this.mContext.getContentResolver().delete(AnaProviderContract.USER_EVENTS_URI, string, null);
            }
            if (!akaWebAnalyticsRecord.getLogEventRecordIds().isEmpty()) {
                string = this.getSelectionClauseByName("_id", akaWebAnalyticsRecord.getLogEventRecordIds());
                this.mContext.getContentResolver().delete(AnaProviderContract.EVENT_LOG_URI, string, null);
            }
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: Unable to delete stats: " + exception));
        }
    }

    private static synchronized boolean isSendingWebAnalytics() {
        return sIsSendingWebAnalytics;
    }

    private static synchronized void setSendingWebAnalytics(boolean bl2) {
        sIsSendingWebAnalytics = bl2;
    }

    private String getSelectionClauseByName(String string, List<Integer> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = list.size();
        if (n2 > 0) {
            stringBuilder.append(string);
            stringBuilder.append(" IN (");
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(list.get(i2));
                if (i2 == n2 - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private JSONObject getSdkEventStat() {
        JSONObject jSONObject = new JSONObject();
        try {
            SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
            long l2 = sharedPreferences.getLong("last_fg_ts", 0L) / 1000L;
            String string = this.getEventId();
            if (TextUtils.isEmpty((CharSequence)string)) {
                this.generateEventId();
                jSONObject.put("first_use", l2);
            }
            jSONObject.put("last_use", l2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jSONObject;
    }

    private String getEventId() {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        String string = sharedPreferences.getString("unique_src_id", "");
        return string;
    }

    private String generateEventId() {
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        String string = UUID.randomUUID().toString();
        editor.putString("unique_src_id", string);
        editor.apply();
        return string;
    }

    private JSONArray getLogEventStats(List<Integer> list, int n2) {
        JSONArray jSONArray = new JSONArray();
        HashMap<String, JSONObject> hashMap = new HashMap<String, JSONObject>();
        HashMap hashMap2 = new HashMap();
        String string = "_id, sessionId ASC LIMIT " + n2;
        try {
            Object object;
            Cursor cursor = this.mContext.getContentResolver().query(AnaProviderContract.EVENT_LOG_URI, null, null, null, string);
            if (cursor != null) {
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    String string2 = cursor.getString(cursor.getColumnIndex(STATS_EVENT_NAME));
                    long l2 = cursor.getLong(cursor.getColumnIndex("timestamp"));
                    String string3 = cursor.getString(cursor.getColumnIndex(STATS_SESSIONS_ID));
                    String object2 = TextUtils.isEmpty((CharSequence)string3) ? string2 : string2 + "," + (String)string3;
                    object = (List)hashMap.get(object2);
                    if (object == null) {
                        object = new ArrayList();
                    }
                    object.add(l2);
                    hashMap.put(object2, (JSONObject)object);
                    list.add(cursor.getInt(cursor.getColumnIndex("_id")));
                    cursor.moveToNext();
                }
                cursor.close();
            }
            int n3 = 0;
            String string4 = "";
            String string2 = "";
            for (Map.Entry entry : hashMap.entrySet()) {
                object = new JSONObject();
                string4 = (String)entry.getKey();
                string2 = "";
                n3 = ((String)entry.getKey()).indexOf(",");
                if (n3 > 0 && n3 + 1 < string4.length()) {
                    string4 = ((String)entry.getKey()).substring(0, n3);
                    string2 = ((String)entry.getKey()).substring(n3 + 1);
                }
                object.put(STATS_EVENT_NAME, (Object)string4);
                JSONArray jSONArray2 = new JSONArray();
                Iterator iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    long l2 = (Long)iterator.next();
                    jSONArray2.put(l2);
                }
                object.put(STATS_TIMESTAMP, (Object)jSONArray2);
                object.put(STATS_SESSIONS_ID, (Object)string2);
                jSONArray.put(object);
            }
        }
        catch (Exception exception) {
            Logger.d((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: Exception getting log event stats: " + exception));
        }
        return jSONArray;
    }

    private JSONArray getUserEventStats(List<Integer> list, int n2) {
        JSONArray jSONArray = new JSONArray();
        String string = "_id ASC LIMIT " + n2;
        try {
            Cursor cursor = this.mContext.getContentResolver().query(AnaProviderContract.USER_EVENTS_URI, null, null, null, string);
            if (cursor != null) {
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put(STATS_EVENT_NAME, (Object)cursor.getString(cursor.getColumnIndex(STATS_EVENT_NAME)));
                    jSONObject.put(STATS_START_TIME, cursor.getLong(cursor.getColumnIndex("starttime")));
                    jSONObject.put(STATS_STOP_TIME, cursor.getLong(cursor.getColumnIndex("stoptime")));
                    String string2 = cursor.getString(cursor.getColumnIndex("connectiontype"));
                    jSONObject.put(STATS_CONNECTION_TYPE, (Object)(TextUtils.isEmpty((CharSequence)string2) ? "" : string2));
                    jSONObject.put(STATS_SESSIONS_ID, (Object)cursor.getString(cursor.getColumnIndex(STATS_SESSIONS_ID)));
                    jSONArray.put((Object)jSONObject);
                    list.add(cursor.getInt(cursor.getColumnIndex("_id")));
                    cursor.moveToNext();
                }
                cursor.close();
            }
        }
        catch (Exception exception) {
            Logger.d((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: Exception getting user event stats: " + exception));
        }
        return jSONArray;
    }

    private JSONArray getHttpStats(List<Integer> list, int n2) {
        JSONArray jSONArray = new JSONArray();
        String string = "_id ASC LIMIT " + n2;
        try {
            Cursor cursor = this.mContext.getContentResolver().query(AnaProviderContract.HTTP_CONSUMPTION_STATS_URI, null, null, null, string);
            if (cursor != null) {
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    int n3;
                    long l2;
                    String string2;
                    if (cursor.getLong(cursor.getColumnIndex(DOWNLOAD_DURATION)) > 600000L) {
                        list.add(cursor.getInt(cursor.getColumnIndex("_id")));
                        cursor.moveToNext();
                        continue;
                    }
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put(URL, (Object)cursor.getString(cursor.getColumnIndex(URL)));
                    jSONObject.put(UNIQUE_ID, (Object)cursor.getString(cursor.getColumnIndex("feedid")));
                    jSONObject.put(STATS_DOWNLOAD_TYPE, (Object)cursor.getString(cursor.getColumnIndex("downloadtype")));
                    jSONObject.put(STATS_TIMESTAMP, cursor.getLong(cursor.getColumnIndex("timestamp")));
                    jSONObject.put(DOWNLOAD_DURATION, cursor.getLong(cursor.getColumnIndex(DOWNLOAD_DURATION)));
                    jSONObject.put(STATS_TTFB, cursor.getLong(cursor.getColumnIndex(STATS_TTFB)));
                    jSONObject.put(STATS_BATTERYLEVEL, cursor.getInt(cursor.getColumnIndex("batterylevel")));
                    jSONObject.put(STATS_ISCHARGING, (Object)cursor.getString(cursor.getColumnIndex("ischarging")));
                    jSONObject.put(STATS_CONNECTION_TYPE, (Object)cursor.getString(cursor.getColumnIndex("connectiontype")));
                    jSONObject.put(LOCATION, (Object)cursor.getString(cursor.getColumnIndex(LOCATION)));
                    jSONObject.put(STATS_RESPONSE_CODE, cursor.getInt(cursor.getColumnIndex("respcode")));
                    jSONObject.put(STATS_REQUEST_HEADER_SZ, cursor.getLong(cursor.getColumnIndex("requestheadersize")));
                    jSONObject.put(STATS_RESPONSE_HEADER_SZ, cursor.getLong(cursor.getColumnIndex("responseheadersize")));
                    jSONObject.put(STATS_CONTENT_LENGTH, cursor.getLong(cursor.getColumnIndex("contentlength")));
                    jSONObject.put(STATS_MIME_TYPE, (Object)cursor.getString(cursor.getColumnIndex("mimetype")));
                    jSONObject.put(STATS_MP_TYPE, cursor.getInt(cursor.getColumnIndex("mptype")));
                    int n4 = cursor.getInt(cursor.getColumnIndex("mpmethod"));
                    if (n4 != -1) {
                        jSONObject.put(STATS_MP_METHOD, n4);
                        jSONObject.put(STATS_MP_WINNER, cursor.getInt(cursor.getColumnIndex("mpwinner")));
                        jSONObject.put(STATS_IP_V6_TRIES, cursor.getInt(cursor.getColumnIndex(STATS_IP_V6_TRIES)));
                        jSONObject.put(STATS_IP_V4_TRIES, cursor.getInt(cursor.getColumnIndex(STATS_IP_V4_TRIES)));
                    }
                    if (VocAccelerator.getInstance().getSecurePreferenceBoolean("use_quic", false) && VocAccelerator.getInstance().getCronetEngine() != null) {
                        jSONObject.put(STATS_QUIC_ENABLED, cursor.getInt(cursor.getColumnIndex("quicEnabled")));
                    }
                    if (!TextUtils.isEmpty((CharSequence)(string2 = cursor.getString(cursor.getColumnIndex(STATS_CONTENT_LENGTH_HEADER))))) {
                        jSONObject.put(STATS_CONTENT_LENGTH_HEADER, (Object)string2);
                    }
                    if ((l2 = cursor.getLong(cursor.getColumnIndex(STATS_MAX_RWND))) > 0L) {
                        jSONObject.put(STATS_MAX_RWND, l2);
                    }
                    jSONObject.put(STATS_SERVER_PROFILE, (Object)cursor.getString(cursor.getColumnIndex("serverprofile")));
                    jSONObject.put(STATS_AMC_ID, (Object)cursor.getString(cursor.getColumnIndex("amcid")));
                    jSONObject.put(STATS_REQUEST_TYPE, (Object)cursor.getString(cursor.getColumnIndex(STATS_REQUEST_TYPE)));
                    jSONObject.put(STATS_BROTLI_USED, cursor.getInt(cursor.getColumnIndex("brotliUsed")));
                    int n5 = cursor.getInt(cursor.getColumnIndex(STATS_CACHEABLE));
                    if (n5 >= 0) {
                        jSONObject.put(STATS_CACHEABLE, n5);
                    }
                    if ((n3 = cursor.getInt(cursor.getColumnIndex(STATS_TPRESULT))) != -1) {
                        jSONObject.put(STATS_TPRESULT, n3);
                    }
                    jSONObject.put(STATS_SESSIONS_ID, (Object)cursor.getString(cursor.getColumnIndex(STATS_SESSIONS_ID)));
                    String string3 = cursor.getString(cursor.getColumnIndex("exceptionMessage"));
                    if (!TextUtils.isEmpty((CharSequence)string3)) {
                        jSONObject.put(STATS_EXCEPTION, (Object)string3);
                    }
                    jSONObject.put(STATS_PRECACHED, (Object)cursor.getString(cursor.getColumnIndex(STATS_PRECACHED)));
                    jSONObject.put(STATS_REDIRECTED, (Object)cursor.getString(cursor.getColumnIndex(STATS_REDIRECTED)));
                    jSONArray.put((Object)jSONObject);
                    list.add(cursor.getInt(cursor.getColumnIndex("_id")));
                    cursor.moveToNext();
                }
                cursor.close();
            }
        }
        catch (Exception exception) {
            Logger.d((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: Exception getting http stats: " + exception));
        }
        return jSONArray;
    }

    private long getSessionLength(List<Integer> list) {
        long l2 = 0L;
        try {
            Cursor cursor = this.mContext.getContentResolver().query(AnaProviderContract.ACTIVITY_SESSION_STATS_URI, null, null, null, null);
            if (cursor != null) {
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    int n2 = cursor.getInt(cursor.getColumnIndex("_id"));
                    long l3 = cursor.getLong(cursor.getColumnIndex(DOWNLOAD_DURATION));
                    l2 += l3;
                    list.add(n2);
                    cursor.moveToNext();
                }
                cursor.close();
            }
        }
        catch (Exception exception) {
            Logger.d((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler: Exception getting session length: " + exception));
        }
        return l2;
    }

    private static byte[] gzipString(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(string.getBytes());
        gZIPOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return byArray;
    }

    private JSONObject getCellParams() {
        JSONObject jSONObject = new JSONObject();
        try {
            boolean bl2;
            Location location;
            String string;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            boolean bl3 = VocAccelerator.getInstance().getSecurePreferenceBoolean("get_carrier", false);
            if (bl3) {
                String string6;
                string = (TelephonyManager)this.mContext.getSystemService("phone");
                String string7 = string6 = string != null ? string.getSimOperator() : null;
                if (string6 != null) {
                    try {
                        string2 = string6.substring(0, 3);
                        string3 = string6.substring(3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string != null && string.getPhoneType() == 1) {
                    try {
                        location = (GsmCellLocation)string.getCellLocation();
                        if (location != null) {
                            string4 = Integer.toHexString(location.getLac());
                            string5 = Integer.toHexString(location.getCid());
                        }
                    }
                    catch (Exception exception) {
                        Logger.d((String)"AkaSdkLogger-map", (String)"AkaWebAnalyticsHandler: Exception getting cell location ");
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    jSONObject.put(CELL_MCC, (Object)string2);
                }
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    jSONObject.put(CELL_MNC, (Object)string3);
                }
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    jSONObject.put(CELL_LAC, (Object)string4);
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    jSONObject.put(CELL_ID, (Object)string5);
                }
                jSONObject.put(SIGNAL_STRENGTH, AnaUtils.getSignalStrength(this.mContext));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = AnaUtils.getNetworkTypeName(this.mContext)))) {
                jSONObject.put(RAT_TYPE, (Object)string);
            }
            if (bl2 = VocAccelerator.getInstance().getSecurePreferenceBoolean("get_location", false)) {
                location = AnaUtils.getLocation(this.mContext);
                JSONObject jSONObject2 = new JSONObject();
                if (location != null) {
                    try {
                        DecimalFormat decimalFormat = new DecimalFormat("#.####");
                        jSONObject2.put(LATITUDE, (Object)decimalFormat.format(location.getLatitude()));
                        jSONObject2.put(LONGITUDE, (Object)decimalFormat.format(location.getLongitude()));
                        jSONObject2.put(ACCURACY, (Object)decimalFormat.format(location.getAccuracy()));
                        jSONObject.put(GEO_LOCATION, (Object)jSONObject2);
                    }
                    catch (Exception exception) {
                        Logger.d((String)"AkaSdkLogger-map", (String)"AkaWebAnalyticsHandler: Exception getting location ");
                    }
                }
            }
        }
        catch (Exception exception) {
            Logger.dd((String)"AkaSdkLogger-map", (String)"AkaWebAnalyticsHandler Unable to create cell params object ");
        }
        return jSONObject;
    }

    private JSONObject getAbGroups() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(MASTER_AB, VocAccelerator.getInstance().getSecurePreferenceBoolean("use_master_ab", false));
            jSONObject.put(MASTER_ENABLED, VocAccelerator.getInstance().getSecurePreferenceBoolean("use_master_ab_server_flag", false));
            jSONObject.put(QUIC, VocAccelerator.getInstance().getSecurePreferenceBoolean("use_quic", false));
            jSONObject.put(UNIVERSAL_CACHE, VocAccelerator.getInstance().getSecurePreferenceBoolean("universal_cache", false));
            jSONObject.put(TCP_OPTIMIZATION, VocAccelerator.getInstance().getSecurePreferenceBoolean("transport_opt", false));
            jSONObject.put(MULTIPATH, VocAccelerator.getInstance().getSecurePreferenceBoolean("use_multipath", false));
            jSONObject.put(NETWORK_QUALITY, VocAccelerator.getInstance().getSecurePreferenceBoolean("congestion_control", false));
            jSONObject.put(AIC, VocAccelerator.getInstance().getSecurePreferenceBoolean("use_aic", false));
            jSONObject.put(BROTLI, VocAccelerator.getInstance().getSecurePreferenceBoolean("use_brotli", false));
            jSONObject.put(IMAGE_MANAGER, VocAccelerator.getInstance().getSecurePreferenceBoolean("use_IM", false));
            jSONObject.put(FGSEGMENTS, VocAccelerator.getInstance().getSecurePreferenceBoolean("enable_fgsegments", false));
        }
        catch (Exception exception) {
            Logger.e((String)"AkaSdkLogger-map", (String)("AkaWebAnalyticsHandler Unable to create AB groups object " + exception));
        }
        return jSONObject;
    }

    public static void deleteOldStats(boolean bl2, Context context) {
        String string = null;
        if (bl2) {
            string = "timestamp < " + (System.currentTimeMillis() - ANALYTICS_EXPIRY_TIME_MILLIS);
        }
        context.getContentResolver().delete(AnaProviderContract.HTTP_CONSUMPTION_STATS_URI, string, null);
        context.getContentResolver().delete(AnaProviderContract.ACTIVITY_SESSION_STATS_URI, string, null);
        context.getContentResolver().delete(AnaProviderContract.EVENT_LOG_URI, string, null);
        if (bl2) {
            string = "stoptime < " + (System.currentTimeMillis() - ANALYTICS_EXPIRY_TIME_MILLIS);
        }
        context.getContentResolver().delete(AnaProviderContract.USER_EVENTS_URI, string, null);
    }

    public static boolean sendDailyUsageAnalytics(Context context) {
        boolean bl2 = false;
        SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
        long l2 = sharedPreferences.getLong("last_fg_ts", 0L);
        long l3 = sharedPreferences.getLong("lastanalyticsupload_ts", 0L);
        long l4 = sharedPreferences.getLong("lastsdkeventupload_ts", 0L);
        if (!DateUtils.isToday((long)l4) && l3 < l2) {
            AkaWebAnalyticsHandler.sendWebAnalytics(context);
            bl2 = true;
        }
        return bl2;
    }

    public static JSONObject getOldServerState(Context context) {
        JSONObject jSONObject = new JSONObject();
        try {
            SharedPreferences sharedPreferences = AnaUtils.getSDKSharedPreferences(context);
            String string = sharedPreferences.getString("server_state", "");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                jSONObject = new JSONObject(string);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }
}

